﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="Regra.aspx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.Regra" %>

<%@ Register Src="~/WFAdmin/WFWorkflow/Modules/RegraCondicao.ascx" TagPrefix="uc1" TagName="RegraCondicao" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style>
        .regra input[type=submit] {
            margin: 0 8px !important;
        }

        .rulesItem {
            width: 100%;
            display: inline-block;
            padding: 4px;
        }

        .conditionItem {
            display: inline-block;
            width: 850px;
            text-align: center;
            margin: 2px;
            padding: 2px;
        }

        .conditionTitle {
            width: 120px;
            display: block;
            float: left;
            text-align: right;
            padding: 7px;
        }

        .conditionValue {
            width: 700px;
            display: block;
            text-align: right;
            float: left;
        }

        .conditionError {
            border: 2px solid red;
        }

        .ruleItem {
            width: 100%;
            display: block;
            text-align: left;
        }

        .ruleTitle {
            font-size: 1.1em;
            font-weight: bold;
        }

        .ruleButton {
            width: 30px;
            display: block;
            float: left;
            text-align: right;
        }
    </style>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <div style="width: 100%;">
        <h1>
            <asp:Label Text="" ID="lblModuleName" runat="server" /></h1>
        <div class="fields no-columns">
            <label>
                <asp:Label ID="lblName" runat="server" />
                <asp:TextBox ID="txtName" runat="server" MaxLength="50" />
                <asp:RequiredFieldValidator ID="reqName" runat="server" Display="Dynamic" ControlToValidate="txtName" />
            </label>
            <div>
                <asp:UpdatePanel ID="pnlCondition" runat="server">
                    <ContentTemplate>
                        <div class="actions">
                            <asp:Button ID="btnAddRule" runat="server" />
                        </div>
                        <placeholder id="phConditions" visible="false" runat="server">
                            <fieldset class="regra">
                                <asp:HiddenField ID="hidProcessId" runat="server" />
                                <asp:HiddenField ID="hidConditionId" runat="server" />
                                <uc1:RegraCondicao runat="server" ID="MainCondition" />
                                <asp:Repeater ID="rptConditions" runat="server">
                                    <ItemTemplate>
                                        <uc1:RegraCondicao runat="server" ID="AditionalCondition" />
                                    </ItemTemplate>
                                </asp:Repeater>
                                <div class="conditionItem">
                                    <asp:Label ID="lblExitAs" CssClass="conditionTitle" runat="server" Text="SAIR COMO" />
                                    <div class="conditionValue">
                                        <asp:TextBox ID="txtExitName" Width="100%" runat="server" />
                                    </div>
                                </div>
                                <div class="d-flex align-center">
                                    <div class="d-flex justify-end flex-1">
                                        <asp:Button ID="btnSaveCondition" runat="server" />
                                    </div>
                                    <div class="flex-1">
                                        <asp:Button ID="btnCancelCondition" runat="server" />
                                    </div>
                                </div>
                            </fieldset>
                        </placeholder>
                        <asp:Label ID="lblConditions" CssClass="rulesItem" runat="server" />
                        <fieldset>
                            <asp:Label ID="lblNoConditions" Visible="false" runat="server" />
                            <asp:Repeater ID="rptRules" runat="server">
                                <HeaderTemplate>
                                    <table class="unstyled">
                                </HeaderTemplate>
                                <FooterTemplate></table></FooterTemplate>
                                <ItemTemplate>
                                    <tr>
                                        <td style="width: 94%">
                                            <asp:Label ID="lblExitName" CssClass="ruleItem ruleTitle" runat="server" />
                                            <asp:Label ID="lblRuleText" CssClass="ruleItem" runat="server" />
                                        </td>
                                        <td style="width: 3%">
                                            <asp:LinkButton ID="btnEditRule" CssClass="edit-item" Width="20px" CausesValidation="false" runat="server">&nbsp;</asp:LinkButton>
                                            <asp:LinkButton ID="btnDeleteRule" CssClass="remove-item" runat="server" Width="20px" CausesValidation="false">&nbsp;</asp:LinkButton>
                                        </td>
                                        <td style="width: 3%">
                                            <asp:LinkButton ID="btnMoveUp" CssClass="move-up" Width="20px" CausesValidation="false" runat="server">&nbsp;</asp:LinkButton>
                                            <asp:LinkButton ID="btnMoveDown" CssClass="move-down" Width="20px" CausesValidation="false" runat="server">&nbsp;</asp:LinkButton>
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>
                        </fieldset>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </div>
            <label>
                <asp:CheckBox ID="includeelse" runat="server" />
            </label>
        </div>
        <section class="actions">
            <asp:Button ID="btnok" runat="server" />
            <input id="btncancel" type="button" value="button" runat="server" />
        </section>
    </div>
</asp:Content>
