﻿<%@ Page MaintainScrollPositionOnPostback="true" Language="vb" MasterPageFile="~/WFAdmin/ModalAdminPage.master" AutoEventWireup="false" CodeBehind="PDFCreator.aspx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.PDFCreator" %>

<%@ Register TagPrefix="zff" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <h1>
        <asp:Label Text="" ID="lblModuleName" runat="server" />
    </h1>
    <div class="fields pdf-creator">
        <label>
            <asp:Label ID="lblnome" runat="server" />
            <asp:TextBox ID="txtnome" runat="server" MaxLength="50" />
            <asp:RequiredFieldValidator ID="obrnome" runat="server" Display="Dynamic" ControlToValidate="txtnome" ValidationGroup="PDFCreation" />
        </label>
        <label>
            <asp:Label ID="lblacesso" runat="server" />
            <wff:accesslist id="listaacesso" disableitems="-7;-6;-5;-4;-3;-2" enableuser="true" enablerole="true" enablerolegroup="true" runat="server" />
        </label>
        <label>
            <asp:Label ID="lblArquivo" runat="server" />
            <asp:FileUpload ID="pdfFile" runat="server" />
            <asp:RegularExpressionValidator ID="vlarquivo" runat="server" Display="Dynamic" ValidationExpression=".+\.(pdf|PDF)" ControlToValidate="pdfFile" />
        </label>
        <label>
            <asp:Button ID="btnLoad" runat="server" />
            <asp:Label ID="lblFileName" runat="server" />
        </label>
        <asp:PlaceHolder ID="phFields" runat="server" Visible="false">
            <fieldset>
                <legend>
                    <asp:Label ID="lblFields" runat="server" />
                </legend>
                <div>
                    <div style="margin-bottom: 5px;">
                        <asp:DropDownList ID="ddlPDFFields" Width="100%" runat="server" />
                        <asp:Label ID="lblEditFieldName" runat="server" Visible="false" />
                        <zff:zuricontextlist id="PDFFieldValue" filterproviders="REQUESTINFO;CTXWORKFLOWDATA" dropdownautowidth="enabled" width="100%" pagersize="10" runat="server" />
                        <section class="actions">
                            <asp:Button ID="btnAdd" CssClass="actbutton" runat="server" />
                            <asp:Button ID="btnCancelEdit" CssClass="actbutton" runat="server" Visible="false" />
                        </section>
                    </div>
                </div>

                <asp:Repeater ID="rptFields" runat="server">
                    <headertemplate>
                        <table>
                    </headertemplate>
                    <footertemplate></table></footertemplate>
                    <itemtemplate>
                        <tr>
                            <td class="fieldlistname">
                                <asp:Label ID="lblFieldName" runat="server" />
                            </td>
                            <td>
                                <asp:Image ID="imgIcon" CssClass="fieldlisticon" Style="width: 20px;" runat="server" />
                                <asp:Label ID="lblFieldValue" runat="server" />
                            </td>
                            <td class="fieldlistaction">
                                <asp:ImageButton ID="editField" ImageUrl="~/WFResources/Common/Images/Icons/edit.png" runat="server" />
                            </td>
                            <td class="fieldlistaction">
                                <asp:ImageButton ID="removeField" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" />
                            </td>
                        </tr>
                    </itemtemplate>
                </asp:Repeater>
            </fieldset>
        </asp:PlaceHolder>
    </div>
    <section class="actions">
        <asp:Button ID="btnok" runat="server" ValidationGroup="PDFCreation" />
        <input id="btncancel" type="button" value="button" runat="server" />
    </section>
</asp:Content>
