﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="ExcelImporter.aspx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.ExcelImporter1" %>

<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register TagPrefix="wfhtml" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <script type="text/javascript">
        function confirmReplaceFile(msg) {
            if ($('.file.excel').attr('href')) {
                return confirm(msg);
            } else {
                return true;
            }
        }
    </script>

    <h1>
        <asp:Label Text="" ID="lblModuleName" runat="server" /></h1>

    <asp:HiddenField runat="server" ID="hidField" />
    <asp:HiddenField runat="server" ID="hidPageColumns" />
    <div class="fields">
        <label>
            <asp:Label runat="server" ID="lblName" Text="Nome: " />
            <asp:TextBox runat="server" ID="txtName" />
            <asp:RequiredFieldValidator ID="reqName" runat="server" Display="Dynamic" ControlToValidate="txtName" />
        </label>
        <label>
            <asp:Label runat="server" ID="lblAlias" Text="Apelido: " />
            <asp:TextBox runat="server" ID="txtAlias" MaxLength="50" />
            <asp:RequiredFieldValidator ID="reqAlias" runat="server" Display="Dynamic" ControlToValidate="txtAlias" />
        </label>
        <label>
            <div style="margin-bottom: 1em;">
                <asp:Label runat="server" ID="lblFileExcel" Text="Arquivo de template Excel" />
                <asp:FileUpload runat="server" ID="uplFileExcel" />
            </div>
            <asp:Button runat="server" ID="btnFileExcel" Text="Carregar arquivo" />
            <div id="wf-excel-importer" class="wf-excel-importer fields no-columns">
                <asp:LinkButton runat="server" ID="btnRemoveFileExcel" CssClass="remove" Text="remover" Visible="false" OnClick="btnRemoveFileExcel_Click"></asp:LinkButton>
                <asp:HyperLink runat="server" ID="lnkFileExcel" CssClass="file excel" />
            </div>

        </label>
        <label>
            <asp:Label runat="server" ID="lblPageIndex" Text="Qual aba (posição) do excel deseja importar?" />
            <asp:TextBox runat="server" ID="txtPageIndex" />
            <asp:Label runat="server" ID="lblPageIndexMsg" Text=" Sem valor será importada a primeira planilha" CssClass="excel-import-label" />
        </label>
        <label>
            <asp:Label runat="server" ID="lblColumnIndex" Text="Quais colunas do excel deseja importar?" />
            <asp:TextBox runat="server" ID="txtColumnIndex" />
            <asp:Label runat="server" ID="Label1" Text=" Ex.: '1;4;5;8' - Sem valor (ou com valor '0') serão importadas todas as colunas." CssClass="excel-import-label" />
        </label>
        <label>
            <asp:CheckBox runat="server" ID="chkUseFirstRowColumnNames" Text="Utilizar nomes das colunas contidas na primeira linha." />
        </label>
        <asp:Button runat="server" ID="btnUpdateColumns" Text="Atualizar colunas" />
        <label>
            <asp:Label ID="lbltexto" runat="server" />
            <wfhtml:ZuriHTMLEditor Height="540px" width="100%" runat="server" ID="HTMLContent" />
        </label>
        <label>
            <asp:Label ID="lblacesso" runat="server" />
            <wff:AccessList id="listaacesso" DisableItems="-7;-6;-5;-4;-3;-2" EnableUser="true" EnableRole="true" EnableRoleGroup="true" runat="server" />
        </label>
    </div>
    <fieldset>
        <legend>
            <asp:Literal runat="server" ID="lblColumnConfig" Text="Configurações das colunas" /></legend>
        <asp:Repeater runat="server" ID="lstColumns">
            <HeaderTemplate>
                <table>
            </HeaderTemplate>
            <ItemTemplate>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="lblColumnIndex" Text="1" /></td>
                    <td>
                        <asp:Label runat="server" ID="lblColumnName" Text="Nome: " /></td>
                    <td>
                        <asp:TextBox runat="server" ID="txtColumnName" Enabled="false" /></td>
                    <td>
                        <asp:Label runat="server" ID="lblColumnType" Text="Tipo de dado: " /></td>
                    <td>
                        <asp:DropDownList runat="server" ID="ddlColumnType">
                            <asp:ListItem Text="Texto" Value="System.String" />
                            <asp:ListItem Text="Data/Hora" Value="System.DateTime" />
                            <asp:ListItem Text="Número" Value="System.Double" />
                        </asp:DropDownList>
                    </td>
                </tr>
            </ItemTemplate>
            <FooterTemplate>
                </table>
            </FooterTemplate>
        </asp:Repeater>
    </fieldset>
    <section class="actions">
        <asp:Button runat="server" ID="btnOK" Text="OK" />
        <input id="btnCancel" type="button" value="Cancelar" runat="server" />
    </section>
</asp:Content>
