﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="MobileConfig.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.MobileConfig" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="WFF" %>
<section class="mobile-theme">
    <asp:PlaceHolder ID="phMobileStyle" runat="server" />
    <fieldset class="config no-columns mobile">
        <legend><asp:Literal runat="server" Text="Colors" /></legend>
        <label>
            <asp:Label runat="server" ID="lblTheme" Text="Theme" />
            <WFF:colorpicker id="cpkTheme" OnClientLoad="pickerLoaded" data-name="theme" runat="server" />
        </label>
        <label>
            <asp:Label runat="server" ID="lblContrast" Text="Contrast" />
            <WFF:colorpicker id="cpkContrast" OnClientLoad="pickerLoaded" data-name="contrast" runat="server" />
        </label>
    </fieldset>

    <fieldset class="config logo mobile">
        <legend><asp:Literal runat="server" Text="Logo" /></legend>
        <asp:FileUpload runat="server" ID="upLogo" />
        <asp:Button runat="server" ID="btAddLogo" CssClass="btnEnviar3" Text="Adicionar" />
        <asp:Repeater ID="rptLogos" runat="server">
            <HeaderTemplate>
                <ul>
            </HeaderTemplate>
            <ItemTemplate>
                <li>
                    <label>
                        <input type="radio" name="selected-logo-mobile" <%#Eval("checked") %> value="<%#Eval("value")%>" /><div><%#Eval("name")%><img src="<%#Eval("path")%>" /><%#Eval("size")%></div>
                    </label>
                </li>
            </ItemTemplate>
            <FooterTemplate></ul></FooterTemplate>
        </asp:Repeater>
    </fieldset>

    <script type="text/javascript">
        (function () {
            var pickers = [];

            window.pickerLoaded = function (sender) {
                var name = $("#" + sender.get_id()).attr("data-name");

                var f = (function (name, field) {
                    return function () {
                        var c = field.get_selectedColor();
                        return "".concat(" svg .m", name, " {fill:", c, ";} svg path.m", name, " {stroke:", c, ";} .mobile-", name, " .logo li img{background-color:", c, "}")
                    }
                })(name, sender);

                pickers.push(f);
                sender.add_colorChange(updateMobileTheme)
                updateMobileTheme();
            }

            var updateMobileTheme = function () {
                var css = "";

                if (pickers && pickers.length) {
                    for (var i = 0; i < pickers.length; i++) {
                        var f = pickers[i];
                        if (f) { css = css.concat(f()); }
                    }
                }

                setMobileStyle(css);
            }

            var setMobileStyle = function (mobstyle) {
                var styles = document.getElementById("mobile-style");
                if (!styles) {
                    styles = document.createElement("style");
                    styles.id = "mobile-style";
                    document.body.appendChild(styles);
                }
                styles.innerHTML = mobstyle;
            }

            var setLogo = function () {
                var scope = $("input[name=selected-logo-mobile]:checked").parent()
                var img = $("img", scope).attr("src");
                if (img) {
                    $("#mobile-preview-logo").attr("href", img);
                }
            }

            $(document).ready(function () {
                $("input[name=selected-logo-mobile]").change(setLogo);
                setLogo();
            });
        })()
    </script>

    <% Response.WriteFile("~/WFAdmin/WFWorkflow/mobile-preview.svg") %>
</section>
