﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Markers.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.Markers" %>
<asp:Content ContentPlaceHolderID="TagHead" runat="server">
	<script language="JavaScript" src="/wfresources/formsweb/Scripts/WFForms.Masks.js"></script>
	<style>
		.accordion {
		  background-color: #eee;
		  color: #444;
		  cursor: pointer;
		  padding: 4px;
		  width: 70%;
		  border: none;
		  text-align: left;
		  outline: none;
		  font-size: 15px;
		  transition: 0.4s;
		  margin-top:.1em;
		  padding-left:.6em;
		}

		.active, .accordion:hover {
		  background-color: #ccc;
		}

		.accordion:after {
		  content: '\2304';
		  color: #777;
		  float: right;
		  padding-right: .6em;
		  position:relative;
		  top:-.5em;
		  margin-left: 5px;
		  margin-bottom: 5px;
		}

		.active:after {
		  content: "\2303";
		  position:relative;
		  top:.2em;
		}

		.panel {
		  padding: 0 18px;
		  background-color: white;
		  max-height: 0;
		  overflow: hidden;
		  transition: max-height 0.2s ease-out;
		}

		.warning:after {
		  content: "\26A0";
		  margin-right: 5px;
		  color:orange;
		}
		
		.switch {
		  position: relative;
		  display: inline-block;
		  width: 30px;
		  height: 17px;
		}

		.switch input { 
		  opacity: 0;
		  width: 0;
		  height: 0;
		}

		.slider {
		  position: absolute;
		  cursor: pointer;
		  top: 0;
		  left: 0;
		  right: 0;
		  bottom: 0;
		  background-color: #ccc;
		  -webkit-transition: .4s;
		  transition: .4s;
		}

		.slider:before {
		  position: absolute;
		  content: "";
		  height: 13px;
		  width: 13px;
		  left: 2px;
		  bottom: 2px;
		  background-color: white;
		  -webkit-transition: .4s;
		  transition: .4s;
		}

		input:checked + .slider {
		  background-color: #2196F3;
		}

		input:focus + .slider {
		  box-shadow: 0 0 1px #2196F3;
		}

		input:checked + .slider:before {
		  -webkit-transform: translateX(13px);
		  -ms-transform: translateX(13px);
		  transform: translateX(13px);
		}

		/* Rounded sliders */
		.slider.round {
		  border-radius: 17px;
		}

		.slider.round:before {
		  border-radius: 50%;
		}

		.baseinputbox{
			width:80px !important ;
			margin-top:5px;
		}
	</style>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

	<div class="no-columns">
		<label>
			<h2><asp:label id="lblmarkerstitle" runat="server" /></h2>
			<small><asp:label id="lblmarkers" runat="server" /></small>
		</label>
		<asp:Repeater runat="server" ID="rptMarkers">
			<HeaderTemplate><div style="width:80%; margin-top:.5em; "></HeaderTemplate>
			<ItemTemplate>
				<div class="accordion"><asp:PlaceHolder ID="phname" runat="server"></asp:PlaceHolder></div>
				<div class="panel">
					<asp:HiddenField ID="hidName" runat="server" /><br />
					<label class="switch">
						<input type="checkbox" id="chkupdate" runat="server">
						<span class="slider round"></span>
					</label>
					<asp:Label ID="lblupdate" runat="server" /><br /><br />
					<asp:Label ID="lblperiod" runat="server" /><br />
					<asp:TextBox ID="txtperiod" CssClass="baseinputbox" runat="server" data-mask="00:00:00" placeholder="hh:mm:ss" /><br /><br />
					<asp:Label ID="lblwindow" runat="server" />
					<div>
						<asp:TextBox ID="txtStart" CssClass="baseinputbox" runat="server" data-mask="00:00:00" placeholder="hh:mm:ss" /><asp:label id="lblTo" runat="server" /><asp:TextBox ID="txtEnd" CssClass="baseinputbox" runat="server" data-mask="00:00:00" placeholder="hh:mm:ss" />
					</div>
					<br />
					<asp:Button ID="btnUpdate" style="width:250px;" runat="server" />
					<br />
					<small><span class="warning"></span><b><asp:label id="lblwarning" runat="server" /></b></small><br />&nbsp;
				</div>
			</ItemTemplate>
			<FooterTemplate></div></FooterTemplate>
		</asp:Repeater>
	</div>
	<script>
		var acc = document.getElementsByClassName("accordion");
		var i;

		for (i = 0; i < acc.length; i++) {
			acc[i].addEventListener("click", function () {
				this.classList.toggle("active");
				var panel = this.nextElementSibling;
				if (panel.style.maxHeight) {
					panel.style.maxHeight = null;
				} else {
					panel.style.maxHeight = panel.scrollHeight + "px";
				}
			});
		}
	</script>
	<section class="actions">
		<asp:Button ID="btnsave" style="width:250px;" runat="server" />
	</section>
</asp:Content>
