﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="GPSSettings.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.GPSSettings" %>

<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register Src="~/WFAdmin/TagHeadAdmin.ascx" TagPrefix="wf" TagName="TagHeadAdmin" %>

<!DOCTYPE html>
<html class="gps-settings">
<head runat="server">
    <wf:TagHeadAdmin runat="server" />
</head>
<body id="rootbody" runat="server">
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server" />
        <dl class="views">
            <dt>
                <asp:Literal runat="server" ID="lblGpsViews" Text="Views" /></dt>
            <dd class="add" runat="server" id="ddAdd">
                <asp:LinkButton ID="btAdd" CausesValidation="false" runat="server" Text="+" OnClick="Add_Click" />
            </dd>
            <asp:Repeater runat="server" ID="rptViews">
                <ItemTemplate>
                    <dd>
                        <asp:LinkButton runat="server" CausesValidation="false" ToolTip='<%#Eval("Name") + " (" + Eval("Provider") + ")"%>' CssClass='<%#Eval("Css")%>' CommandArgument='<%#Eval("Id")%>' OnClick="DisplayView_Click"><%#Eval("Name")%><span><%#Eval("Provider")%></span></asp:LinkButton>
                    </dd>
                </ItemTemplate>
            </asp:Repeater>
        </dl>
        <asp:Panel ID="phGpsTypes" CssClass="view-types" runat="server" Visible="false">
            <dl>
                <dt>
                    <asp:Literal runat="server" ID="lblGpsChooseType" Text="Escolha o tipo de GPS que deseja adicionar" /></dt>
                <asp:Repeater runat="server" ID="rptProviders">
                    <ItemTemplate>
                        <dd>
                            <asp:LinkButton runat="server" CausesValidation="false" CssClass='<%# "view-" + Eval("Id")%>' CommandArgument='<%#Eval("Id")%>' OnClick="Add_Click"><%#Eval("Name")%></asp:LinkButton>
                        </dd>
                    </ItemTemplate>
                </asp:Repeater>
            </dl>
        </asp:Panel>
        <asp:Panel ID="phConfigGps" CssClass="view-settings" runat="server" Visible="false">
            <nav>
                <asp:LinkButton ID="tabDef" runat="server" CommandArgument="0" OnClick="tab_Click" Text="Definitions" />
                <asp:LinkButton ID="tabSet" runat="server" CommandArgument="1" OnClick="tab_Click" Text="Settings" />
                <asp:LinkButton ID="tabPre" runat="server" CommandArgument="2" OnClick="tab_Click" Text="Preview" />
            </nav>
            <asp:MultiView runat="server" ID="mvPages" ActiveViewIndex="0">
                <asp:View runat="server">
                    <fieldset class="fields no-columns">
                        <legend>Definition</legend>
                        <label class="name">
                            <asp:Label runat="server" ID="lbName" Text="Name" /><asp:TextBox ID="txtName" runat="server" />
                            <asp:RequiredFieldValidator ControlToValidate="txtName" runat="server" Text="*" Display="Dynamic" />
                        </label>
                        <asp:LinkButton ID="lnkSetDefault" CssClass="set-default" Text="Definir como GPS padrão" runat="server" OnClick="SetDefault_Click" />
                        <label class="type">
                            <asp:Label runat="server" ID="lbType" Text="Type" />
                            <asp:Literal runat="server" ID="viewType" Text="Qualquer" />
                        </label>
                        <label class="access">
                            <asp:Label runat="server" ID="lbAccess" Text="Access" />
                            <wff:AccessList id="listaacesso" enableuser="true" enablerole="true" enablerolegroup="true" runat="server" />
                        </label>
                    </fieldset>
                </asp:View>
                <asp:View ID="vwSet" runat="server">
                    <asp:PlaceHolder ID="phSettings" runat="server" />
                </asp:View>
                <asp:View runat="server">
                    <fieldset class="preview">
                        <legend>Preview</legend>
                        <asp:Literal ID="gpsPreview" runat="server" />
                    </fieldset>
                </asp:View>
            </asp:MultiView>
        </asp:Panel>
        <aside class="actions">
            <asp:Button ID="btSave" runat="server" Text="Salvar" OnClick="btSave_Click" />
            <asp:Button ID="btRemove" runat="server" Text="Remover" OnClick="btRemove_Click" />
            <asp:Label runat="server" ID="lbMessage" CssClass="msg" Text="" />
        </aside>
    </form>
    <script type="text/javascript">
        try {
            var c = document.body.className;
            if (c) {
                var cs = c.split(" ");
                for (i = 0; i < cs.length; i++) {
                    var s = "dd a." + cs[i];
                    $(s).addClass("active");
                }
            }
        } catch (error) { alert(error); }
    </script>
</body>
</html>
