﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Feriados.aspx.vb"
    Inherits="WebFoundations.WFWorkflow.UI.Feriados" Title="Untitled Page" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>


<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <script type="text/javascript">
        function pageLoad(sender, eventArgs) {
            Telerik.Web.UI.Calendar.RenderDay.prototype.ApplyHoverBehavior = function () { return false; };
        }
    </script>
    <div class="fields no-columns">
        <label>
            <asp:Label ID="lbllocal" runat="server" />
            <asp:DropDownList ID="lstlocal" runat="server" AutoPostBack="True" />
        </label>
        <div class="holiday-page-container">
            <div class="divCalendar">
                <telerik:RadCalendar RenderMode="Lightweight" runat="server" ID="calFeriados"
                    EnableMultiSelect="false" BackColor="White" AutoPostBack="true" BorderColor="#00ABF8"
                    BorderWidth="1px" Font-Size="18pt" RowHeaderText=" " ForeColor="#00ABF8" Height="400px"
                    Width="500px" DayNameFormat="Short" EnableNavigation="true" FastNavigationSettings-CancelButtonCaption="Cancelar"
                    FastNavigationSettings-TodayButtonCaption="Hoje" EnableMonthYearFastNavigation="true" OnDayRender="calFeriados_DayRender"
                    OnSelectionChanged="calFeriados_SelectionChanged"
                    OnDefaultViewChanged="calFeriados_DefaultViewChanged">
                </telerik:RadCalendar>
                <div id="divLegenda" runat="server" class="legendaCalendar">
                    <label class="spnFeriados"><span>
                        <asp:Literal id="lblholiday" runat="server" />
                                               </span></label>
                    <label class="spnFeriadosRecorrentes"><span>

                        <asp:Literal ID="lblrholiday" runat="server" />
                                                          </span></label>
                </div>
            </div>
            <div class="divForm">
                <asp:LinkButton ID="btnCadastrarFeriado" CssClass="btnAddHoliday-hidden" runat="server"
                    OnClick="btnCadastrarFeriado_Click">
							<div class="divCadastraFeriados">
								<div class="svgCadastraFeriados">
									<svg class="svgImage" width="25" height="25" viewBox="0 0 25 25" fill="none"
										xmlns="http://www.w3.org/2000/svg">
										<path
											d="M19.0244 4.25635H5.02441C3.91984 4.25635 3.02441 5.15178 3.02441 6.25635V20.2563C3.02441 21.3609 3.91984 22.2563 5.02441 22.2563H19.0244C20.129 22.2563 21.0244 21.3609 21.0244 20.2563V6.25635C21.0244 5.15178 20.129 4.25635 19.0244 4.25635Z"
											stroke="#00ABF8" stroke-width="2" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M16.0244 2.25635V6.25635" stroke="#00ABF8" stroke-width="2"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M8.02441 2.25635V6.25635" stroke="#00ABF8" stroke-width="2"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M3.02441 10.2563H21.0244" stroke="#00ABF8" stroke-width="2"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M12.0244 13.2563V18.6606" stroke="#00ABF8" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M9.32227 15.9585H14.7266" stroke="#00ABF8" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
									</svg>
									<span class="spnCadastrarFeriados">
                                        Cadastrar Feriados</span>
								</div>
								<svg class="svgImage" width="25" height="25" viewBox="0 0 25 25" fill="none"
									xmlns="http://www.w3.org/2000/svg">
									<path
										d="M19.9902 3.62793H5.99023C4.88566 3.62793 3.99023 4.52336 3.99023 5.62793V19.6279C3.99023 20.7325 4.88566 21.6279 5.99023 21.6279H19.9902C21.0948 21.6279 21.9902 20.7325 21.9902 19.6279V5.62793C21.9902 4.52336 21.0948 3.62793 19.9902 3.62793Z"
										stroke="#00ABF8" stroke-width="2" stroke-linecap="round"
										stroke-linejoin="round" />
									<path d="M12.9902 8.62793V16.6279" stroke="#00ABF8" stroke-width="2"
										stroke-linecap="round" stroke-linejoin="round" />
									<path d="M8.99023 12.6279H16.9902" stroke="#00ABF8" stroke-width="2"
										stroke-linecap="round" stroke-linejoin="round" />
								</svg>
							</div>

                </asp:LinkButton>
                <asp:Panel ID="pnlEdicaoFeriado" CssClass="feriados-edicao" runat="server" Visible="false">
                    <fieldset class="fields">
                        <legend>
                            <asp:Label ID="lblDataSelecionada" runat="server"></asp:Label>
                        </legend>
                        <label>
                            <asp:TextBox ID="txtDescricao" runat="server"></asp:TextBox>
                        </label>

                        <asp:RadioButtonList ID="rdbTipoFeriado" runat="server" CssClass="unstyled">
                            <asp:ListItem Value="F" Selected="True"></asp:ListItem>
                            <asp:ListItem Value="FR"></asp:ListItem>
                        </asp:RadioButtonList>
                        <section class="actions">
                            <asp:LinkButton ID="btnSalvar" CssClass="button" runat="server">
											<span class="spnSalvaFeriados">Cadastrar Feriados</span>
											<svg width="25" height="25" viewBox="0 0 25 25" fill="none"
												xmlns="http://www.w3.org/2000/svg">
												<path
													d="M19.9902 3.62793H5.99023C4.88566 3.62793 3.99023 4.52336 3.99023 5.62793V19.6279C3.99023 20.7325 4.88566 21.6279 5.99023 21.6279H19.9902C21.0948 21.6279 21.9902 20.7325 21.9902 19.6279V5.62793C21.9902 4.52336 21.0948 3.62793 19.9902 3.62793Z"
													stroke="white" stroke-width="2" stroke-linecap="round"
													stroke-linejoin="round" />
												<path d="M12.9902 8.62793V16.6279" stroke="white" stroke-width="2"
													stroke-linecap="round" stroke-linejoin="round" />
												<path d="M8.99023 12.6279H16.9902" stroke="white" stroke-width="2"
													stroke-linecap="round" stroke-linejoin="round" />
											</svg>
                            </asp:LinkButton>
                        </section>
                    </fieldset>

                </asp:Panel>
                <asp:Panel ID="pnlFeriadosCadastradosMes" CssClass="feriados-cadastrados" runat="server">
                    <fieldset>
                        <legend>
                            <asp:Label ID="lblFeriadosCadastradosMes" runat="server"></asp:Label>
                        </legend>

                        <div class="no-records">
                            <asp:Label ID="lblNoRecords" runat="server" Visible="false"></asp:Label>
                            <div>
                                <asp:Repeater ID="rptFeriadosMes" runat="server"
                                    OnItemDataBound="rptFeriadosMes_ItemDataBound"
                                    OnItemCommand="rptFeriadosMes_ItemCommand">
                                    <ItemTemplate>
                                        <div class="feriados-mes">

                                            <asp:LinkButton ID="btnMonth" CssClass="descricao"
                                                CommandArgument='<%# DataBinder.Eval(Container.DataItem, "id") %>'
                                                runat="server" CommandName="EditHoliday"></asp:LinkButton>
                                            <asp:Label ID="lblHolidayDescription" runat="server"></asp:Label>
                                            <asp:LinkButton ID="btnRemoveHoliday" runat="server"
                                                CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                CommandName="RemoveHoliday">


														<svg width="21" height="21" viewBox="0 0 21 21" fill="none"
															xmlns="http://www.w3.org/2000/svg">
															<path d="M2.85352 5.77734H4.52018H17.8535" stroke="#EA4C4E"
																stroke-linecap="round" stroke-linejoin="round" />
															<path
																d="M16.1869 5.77743V17.4441C16.1869 17.8861 16.0113 18.31 15.6988 18.6226C15.3862 18.9352 14.9623 19.1108 14.5203 19.1108H6.18693C5.7449 19.1108 5.32098 18.9352 5.00842 18.6226C4.69586 18.31 4.52026 17.8861 4.52026 17.4441V5.77743M7.02026 5.77743V4.11076C7.02026 3.66873 7.19586 3.24481 7.50842 2.93225C7.82098 2.61969 8.2449 2.44409 8.68693 2.44409H12.0203C12.4623 2.44409 12.8862 2.61969 13.1988 2.93225C13.5113 3.24481 13.6869 3.66873 13.6869 4.11076V5.77743"
																stroke="#EA4C4E" stroke-linecap="round"
																stroke-linejoin="round" />
															<path d="M8.68677 9.94409V14.9441" stroke="#EA4C4E"
																stroke-linecap="round" stroke-linejoin="round" />
															<path d="M12.0203 9.94409V14.9441" stroke="#EA4C4E"
																stroke-linecap="round" stroke-linejoin="round" />
														</svg>


                                            </asp:LinkButton>
                                        </div>
                                    </ItemTemplate>
                                </asp:Repeater>
                    </fieldset>
                </asp:Panel>
            </div>
        </div>
    </div>
</asp:Content>
