﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="EtapaSla.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.EtapaSla" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';

        function ShowNewForm() {
            window.radopen("EtapaSlaEdit.aspx", "EditDialog");
        }
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>

</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:hyperlink id="lnkadd" runat="server" cssclass="add" />
        </li>
        <li>
            <asp:hyperlink id="lnkedit" runat="server" cssclass="edit" />
        </li>
        <li>
            <asp:hyperlink id="lnkdelete" runat="server" cssclass="delete" />
        </li>
        <li>
            <asp:hyperlink id="lnkrefresh" runat="server" cssclass="refresh" />
        </li>
        <li>
            <asp:linkbutton id="lnkExport" runat="server" cssclass="export" />
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:objectdatasource id="EtapaSlaODS" runat="server" selectmethod="GetItems"
        typename="WebFoundations.WFWorkflow.Services.ObjectDataSources.EtapaSla"
        enablepaging="True" sortparametername="column" selectcountmethod="CountItems"
        maximumrowsparametername="MaximumRows" startrowindexparametername="StartRowIndex">
	</asp:objectdatasource>
    <asp:updatepanel id="updateform" runat="server" updatemode="Always">
	<ContentTemplate>
		<telerik:RadGrid id="grdEtapaSla" runat="server" 
				AutoGenerateColumns="false" DataSourceID="EtapaSlaODS" AllowSorting="True" 
				GridLines="None" AllowPaging="True" EnablePostBackOnRowClick="true" AllowRowSelect="true" PageSize=15>
			<MasterTableView DataSourceID="EtapaSlaODS" >
				<Columns>
					<telerik:GridTemplateColumn UniqueName="GeraAtraso" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="Justify" HeaderStyle-Width ="20px">
						<ItemTemplate>
                            <asp:Image ID="imgAtraso" ImageUrl="~/WFResources/process/images/important.gif" Visible="false"  runat="server" />
						</ItemTemplate>
					</telerik:GridTemplateColumn>
					<telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id"  ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="Justify" />
					<telerik:GridBoundColumn DataField="Nome" HeaderText="Nome" UniqueName="Nome"  ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="Justify" />
					<telerik:GridTemplateColumn HeaderText="Cor" UniqueName="Cor" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="Justify">
						<ItemTemplate>
                            &nbsp;
						</ItemTemplate>
					</telerik:GridTemplateColumn>
					<telerik:GridBoundColumn DataField="Ordem" HeaderText="Ordem" UniqueName="Ordem"  ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="Justify" />
				</Columns>
			</MasterTableView>
			<ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false" 
				 AllowColumnHide="false" 
				Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false" 
				Scrolling-UseStaticHeaders="true">
			</ClientSettings>
			<ExportSettings ExportOnlyData="True"  FileName="Modules" IgnorePaging="True" OpenInNewWindow="True" />
		</telerik:RadGrid>
		<asp:HiddenField id="PostBackHidden" runat="server"></asp:HiddenField>
	</ContentTemplate>
	</asp:updatepanel>
    <wff:WindowManager ID="EditWindow" runat="server">
        <windows>
			<telerik:RadWindow ID="EditDialog" runat="server" Height="430px" Width="450px" ReloadOnShow="true" Modal="true"  />
		</windows>
    </wff:WindowManager>
</asp:Content>
