﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="ProcessDesigner.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.ProcessDesigner" %>
<style type="text/css">
    .process-designer #activate-proc + button:before {
        content: "<%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.activate)%>\A";
    }

    .process-designer #activate-proc:checked + button:before {
        content: "<%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.deactivate)%>\A";
    }

    .process-readonly h2:after {
        content: " [<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.isreadonly%>]";
    }

    body.start #process-info #close-proc-config::before {
        content: "<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.save%>";
    }
</style>
<!--[if IE 9]>
<style type="text/css">
    .wfdesigner #process-info fieldset {
        width: 100%;
        max-width: 40em;
        display: inline-block;
        vertical-align: top;
    }
</style>
<![endif]-->

<asp:Literal ID="litTranslation" runat="server" />

<header>
    <div class="logo-container">
        <svg xmlns="http://www.w3.org/2000/svg" width="53" height="48" viewBox="0 0 53 48" fill="none">
            <path d="M9.5 0.5H49.5L50.5 8.5H3L9.5 0.5Z" fill="#00ABF8" />
            <path d="M40.7687 8.31458L50.5001 8.5005L26.9858 36.989L17.7666 36.8128L40.7687 8.31458Z" fill="#00ABF8" />
            <path d="M52 5C51.3937 7.42536 50.5 9.5 48.5 9.5C46.8431 9.5 46 6.433 46 4.5C46 2.567 47.8431 0.5 49.5 0.5C51.1569 0.5 52.5 3 52 5Z" fill="#00ABF8" />
            <path d="M50.5 39H1.90524L3 47H44L50.5 39Z" fill="white" />
            <path d="M25.0021 10.6837L34.7335 10.8696L11.2192 39.3581L2.00003 39.182L25.0021 10.6837Z" fill="white" />
            <path d="M0.443981 42.5632C0.994062 40.1316 2.5 38.4996 3.72558 38.0262C5.19703 37.4579 6.13989 41.0664 6.16152 42.9993C6.18316 44.9321 4.45164 47.0187 2.87433 47.0363C1.29702 47.054 -0.00962732 44.5685 0.443981 42.5632Z" fill="white" />
        </svg>
        <h1>
            <h1><%=Page.Title%></h1>
        </h1>
    </div>
    <h2 id="process-title"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.name %></h2>
    <menu type="toolbar" id="toolbar">
    </menu>
</header>

<main id="designer-host" xmlns:xlink="http://www.w3.org/1999/xlink">
    <svg id="designer" xmlns="http://www.w3.org/2000/svg">
        <g id="proc-mov">
            <g id="proc">
                <g id="sub-procs"></g>
                <g id="links"></g>
            </g>
        </g>
    </svg>
    <input type="checkbox" id="birdsview-visible" style="display: none;" checked="checked" />
    <label for="birdsview-visible" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.showHideMap %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.showHideMap %></label>
    <menu type="toolbar" id="zoom">
        <label id="zoom-level">100%</label>
        <li>
            <button id="zoom-up">+</button></li>
        <li>
            <button id="zoom-down">-</button></li>
    </menu>
    <svg id="birdsview" xmlns="http://www.w3.org/2000/svg">
        <rect x="1" y="1" width="99%" height="149px" />
        <use id="viewproc" xlink:href="#proc" transform="scale(.3)" />
        <rect id="viewfinder" x="1" y="1" width="10" height="10" />
    </svg>

    <aside id="searchbox">
        <input type="search" id="search" />
        <button id="search-jump" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.searchJump%>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.searchJump%></button>
    </aside>

    <menu type="toolbar" id="alignment">
        <li>
            <button class="align" disabled="disabled" id="vtop" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignTop %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignTop %></button></li>
        <li>
            <button class="align" disabled="disabled" id="vmiddle" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignMiddle %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignMiddle %></button></li>
        <li>
            <button class="align" disabled="disabled" id="vbottom" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignBase %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignBase %></button></li>
        <li>
            <button class="align" disabled="disabled" id="vjustify" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.verticalDistribution%>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.verticalDistribution%></button></li>
        <li>
            <button class="align" disabled="disabled" id="hleft" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignLeft %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignLeft %></button></li>
        <li>
            <button class="align" disabled="disabled" id="hcenter" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignCenter %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignCenter %></button></li>
        <li>
            <button class="align" disabled="disabled" id="hright" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignRight %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignRight %></button></li>
        <li>
            <button class="align" disabled="disabled" id="hjustify" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.horizontalDistribution %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.horizontalDistribution %></button></li>
        <li>
            <button id="undo-align" disabled="disabled" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.undoLastAlign %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.undoAlign %></button></li>
    </menu>

    <menu type="toolbar" id="selection-context">
        <label></label>
        <li id="ctx-linkstatus" class="link-one link-one-only">
            <input id="txtLnkstatus" maxlength="100" />
            <button><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.save %></button></li>
        <li id="ctx-remove" class="node-one node-many link-one link-many">
            <button><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.remove %></button></li>
        <li id="ctx-marker">
            <button><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.markers %></button></li>
        <li id="ctx-config">
            <button><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.settings %></button></li>
        <menu type="toolbar" id="selected-atv">
            <label></label>
            <li id="atv-remove">
                <button><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.remove %></button></li>
            <li id="atv-config">
                <button><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.settings %></button></li>
        </menu>
        <menu id="timed" type="context">
        </menu>
    </menu>
</main>

<footer></footer>

<input type="checkbox" style="display: none;" id="process-info-max" />
<aside class="sidebar" id="process-info">
    <menu>
        <li class="activate">
            <input id="activate-proc" type="checkbox" />
            <button title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.activateDeactivateProcess%>"><%= System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.process)%></button>
        </li>
        <li class="gps"><a id="zuri-gps" href="about:blank" target="_blank" title="<%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.gps)%>"><%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.gps)%></a></li>
        <li class="config">
            <button id="proc-config" title="<%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.processSettings) %>"><%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.processSettings) %></button>
        </li>
        <li class="variables"><a id="zuri-variables" href="VariaveisContexto.aspx?PROCID=" target="_blank" title="<%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.availableVariables) %>"><%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.availableVariables) %></a></li>
        <li class="help"><a class="help" href="#help" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.help%>"><%=System.Globalization.CultureInfo.CurrentCulture.TextInfo.ToTitleCase(WebFoundations.WFWorkflow.UI.ProcessDesignerResources.help)%></a></li>
    </menu>

    <label for="process-info-max" id="resize-proc-config"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.expandRestore %></label>
    <button id="close-proc-config" title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.closeSettings %>"></button>
    <div class="fields">
        <fieldset class="process">
            <legend><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.process %></legend>
            <label>
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.name %></span>
                <input id="txtName" type="text" />
            </label>
            <label>
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.description %></span>
                <textarea id="txtDescription"></textarea>
            </label>
            <label id="managers" class="access">
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.managers %></span>
                <button title="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.settings %>"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.settings %></button>
                <div data-default="<%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.processCreatorDesc %>"></div>
            </label>
        </fieldset>
        <fieldset class="item">
            <legend><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.item %></legend>
            <label>
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.itemTitle %></span>
                <input id="txtTitle" type="text" />
            </label>
            <label class="archive">
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.archiveDeadline %></span>
                <input type="number" id="txtArchive" value="" min="0" max="99999" maxlength="5" />
                <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.days %>.
            </label>
        </fieldset>
        <fieldset class="general">
            <legend><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.general %></legend>
            <div class="d-flex align-center">
                <input type="checkbox" id="chkAllowMobile" />
                <label for="chkAllowMobile" class="labelItem"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.allowMobile %></label>
            </div>
            <div class="d-flex align-center">
                <input type="checkbox" id="chkRemoveDup" />
                <label for="chkRemoveDup" class="labelItem"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.removeDuplicatedProc %></label>
            </div>
            <div class="d-flex align-center">
                <input type="checkbox" id="chkAllowStepAttachment" />
                <label for="chkAllowStepAttachment" class="labelItem"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.allowAttachStage %></label>
            </div>
            <div class="d-flex align-center">
                <input type="checkbox" id="chkGroupAttachments" />
                <label for="chkGroupAttachments" class="labelItem"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.groupAttachement %></label>
            </div>
            <div class="d-flex align-center">
                <input type="checkbox" id="chkHideId" />
                <label for="chkHideId" class="labelItem"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.hideId %></label>
            </div>
        </fieldset>
        <fieldset class="workhours">
            <legend><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.workHours %></legend>
            <label>
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.mondayToFriday %></span><input type="time" id="txtWeekdayStart" maxlength="5" placeholder="09:00" />
                <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionTo %>
                <input type="time" id="txtWeekdayEnd" maxlength="5" placeholder="18:00" /></label>
            <label>
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.saturday %></span><input type="time" id="txtSaturdayStart" maxlength="5" placeholder="09:00" />
                <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionTo %>
                <input type="time" id="txtSaturdayEnd" maxlength="5" placeholder="18:00" /></label>
            <label>
                <span><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.sunday %></span><input type="time" id="txtSundayStart" maxlength="5" placeholder="09:00" />
                <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionTo %>
                <input type="time" id="txtSundayEnd" maxlength="5" placeholder="18:00" /></label>
        </fieldset>
    </div>
</aside>

<aside id="help">
    <h2><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.help%></h2>
    <dl>
        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.general%></dt>
        <dd><em><kbd>H</kbd></em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.openhelp%></dd>
        <dd><em><kbd class="esc">ESC</kbd></em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.closeModalDesc %></dd>

        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.selection %></dt>
        <dd><em><kbd class="ctrl">Ctrl</kbd> + <kbd>A</kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.selectAllDesc %></dd>
        <dd><em><kbd class="click"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.click%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atAnItem%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.simpleSelectionDesc %></dd>
        <dd><em><kbd class="esc">ESC</kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionOr %> <kbd class="click"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.click%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.unselectAllDesc %></dd>
        <dd><em><kbd class="shift">Shift</kbd> + <kbd class="click"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.click%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atAnItem%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.addItemSelectionDesc %></dd>
        <dd><em><kbd class="ctrl">Ctrl</kbd> + <kbd class="click"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.click%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atAnItem%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.invertItemSelectionDesc %></dd>

        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.areaSelection %></dt>
        <dd><em><kbd class="drag"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.clickDrag%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.areaSelectionDesc %></dd>
        <dd><em><kbd class="shift">Shift</kbd> + <kbd class="drag"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.clickDrag%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.addItemsSelectionDesc %></dd>
        <dd><em><kbd class="ctrl">Ctrl</kbd> + <kbd class="drag"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.clickDrag%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.invertSelectionDesc %></dd>

        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.alignmentDisposition %></dt>
        <dd><em><kbd class="drag"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.clickDrag%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atASelectedItem %>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.moveSelectedItems %></dd>
        <dd><em><kbd class="ctrl">Ctrl</kbd> + <kbd>Z</kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.undoAlignDesc %></dd>

        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.navigation %></dt>
        <dd><em>(<kbd class="space"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.spacebar%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionOr%> <kbd class="alt">alt</kbd>) + <kbd class="drag"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.clickDrag%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.moveDrawing %></dd>
        <dd><em><kbd class="drag"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.clickDrag%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atMiniatureArea%>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.moveDrawing %></dd>

        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.zoom%></dt>
        <dd><em><kbd class="scroll"><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.mouseScroll%></kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionOr%> <kbd class="ctrl">Ctrl</kbd> + <kbd>+/-</kbd>  <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atDrawing %>:</em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.changeZoom %></dd>
        <dd><em><kbd class="ctrl">Ctrl</kbd> + <kbd>0</kbd></em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.resetZoomDesc %></dd>

        <dt><%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.search %></dt>
        <dd><em><kbd class="ctrl">Ctrl</kbd> + <kbd>F</kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.junctionOr %> <kbd>F3</kbd></em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.focusSearchAndMove %></dd>
        <dd><em><kbd class="enter">Enter</kbd> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.atSearchBox %></em> <%=WebFoundations.WFWorkflow.UI.ProcessDesignerResources.moveNextSearch %></dd>
    </dl>
</aside>

<script src="<%=VersionResource("~/WFResources/Process/js/zuri-designer.min.js") %>"></script>
