﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="OutputsByStatusCode.ascx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.OutputsByStatusCode" %>
<div class="config-outputs-service">
    <h3><asp:Literal ID="litOutputConfig" runat="server" Text="Configuração de Saídas" /></h3>
    <p><asp:Literal ID="litExplanation" runat="server" Text="É possível configurar saídas extras para casos de erro ou com base no código de HTTP retornado pelo web service." /></p>

    <asp:HiddenField runat="server" ID="hdEditKey" />
    <div class="new-http-output">
        <asp:Label runat="server" ID="lblType" CssClass="label output-type" Text="Tipo" />
        <asp:DropDownList runat="server" ID="ddlOutputType" CssClass="output-type no-margin">
            <asp:ListItem Value="exception" Text="Exception" />
            <asp:ListItem Value="code" Text="HTTP Status Code" />
            <asp:ListItem Value="range" Text="HTTP Status Range" />
        </asp:DropDownList>
        <asp:Label runat="server" ID="lblStart" CssClass="label range-boundary range-start" Text="Início" />
        <asp:TextBox runat="server" CssClass="range-boundary range-start no-margin" type="number" min="300" max="599" ID="txtRangeStart" MaxLength="3" />
        <asp:Label runat="server" CssClass="info range-boundary range-start" Text="300~599" />
        <asp:Label runat="server" ID="lblEnd" CssClass="label range-boundary range-end" Text="Fim" />
        <asp:TextBox runat="server" CssClass="range-boundary range-end no-margin" type="number" min="300" max="599" ID="txtRangeEnd" MaxLength="3" />
        <asp:Label runat="server" CssClass="info range-boundary range-end" Text="300~599" />
        <asp:Label runat="server" ID="lblTitle" CssClass="label title" Text="Title" />
        <asp:TextBox runat="server" CssClass="title no-margin" ID="txtTitle" ToolTip="Title" />
        <asp:Button runat="server" CssClass="add-output" ID="btAddOutput" Text="Adicionar" OnClick="Add_Click" />
    </div>

    <asp:CustomValidator runat="server" CssClass="config-error" ID="ValAddOutput" Display="Dynamic" />

    <asp:PlaceHolder runat="server" ID="phOutputs">
        <h4><asp:Literal ID="litConfiguredOutputs" runat="server" Text="Saídas" /></h4>
        <asp:CheckBox runat="server" ID="chkAttachErrorResponse" Text="Attach Error Response" />
        <asp:Repeater runat="server" ID="rptOutputs">
            <HeaderTemplate>
                <ul class="outputs"></HeaderTemplate>
            <ItemTemplate>
                <li>
                    <asp:LinkButton runat="server" Text='<%#Container.DataItem.ToString()%>' CommandName="edit" />
                    <asp:LinkButton CssClass="wfbal-aclremove" runat="server" ToolTip="Remove" CommandName="x" Text="x" /></li>
            </ItemTemplate>
            <FooterTemplate></ul></FooterTemplate>
        </asp:Repeater>
    </asp:PlaceHolder>

    <asp:PlaceHolder runat="server" ID="noOutputs">
        <h4><asp:Literal ID="litNoOutputs" runat="server" Text="Não há saídas extras configuradas!" /></h4>
    </asp:PlaceHolder>
</div>
