﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="Etapa.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.Etapa" %>

<%@ Register TagPrefix="zzf" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <h1>
        <asp:Literal ID="lblModuleName" runat="server" Text="Etapa" /></h1>
    <telerik:radtabstrip rendermode="Lightweight" runat="server" id="tbConfig" multipageid="configPages" causesvalidation="false" selectedindex="0">
        <tabs>
            <telerik:radtab text="Definições"></telerik:radtab>
            <telerik:radtab text="Mensagem"></telerik:radtab>
            <telerik:radtab text="SLA"></telerik:radtab>
            <telerik:radtab text="Avançadas"></telerik:radtab>
            <telerik:radtab text="Jornada"></telerik:radtab>
        </tabs>
    </telerik:radtabstrip>
    <telerik:radmultipage runat="server" id="configPages" selectedindex="0">
        <telerik:radpageview runat="server" id="Configuracoes">
            <div class="fields">
                <label>
                    <asp:Label ID="lblNome" runat="server" />
                    <asp:TextBox ID="txtNome" runat="server" MaxLength="100" />
                    <asp:RequiredFieldValidator ID="obrNome" runat="server" ControlToValidate="txtNome" Display="Dynamic" />
                </label>
                <label>
                    <asp:CheckBox ID="chketapas" CssClass="checkbox" runat="server" AutoPostBack="True" />
                </label>
                <label>
                    <asp:Label ID="lblAccessList" runat="server" />
                    <asp:UpdatePanel ID="pnlacesso" class="fill-width" runat="server" UpdateMode="Conditional">
                        <ContentTemplate>
                            <asp:PlaceHolder ID="Acesso" runat="server">
                                <wff:accesslist id="listaacesso" disableitems="-7;-6;-5;-4;-3" enableuser="true" enablerole="true" enablerolegroup="false" runat="server" />
                            </asp:PlaceHolder>
                            <asp:PlaceHolder ID="Etapas" Visible="false" runat="server">
                                <asp:DropDownList ID="lstetapa" runat="server" />
                            </asp:PlaceHolder>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </label>
                <label>
                    <asp:Label ID="lblUsuGestor" runat="server" />
                    <wff:accesslist id="aclGestores" disableitems="-7;-6;-5;-4;-3;-2" enableuser="true" enablerole="true" enablerolegroup="false" runat="server" />
                </label>
            </div>
        </telerik:radpageview>
        <telerik:radpageview runat="server" id="Mensagem">
            <div class="fields no-columns">
                <asp:PlaceHolder ID="tipoMensagem" runat="server">
                    <label>
                        <asp:Label ID="lblTipoMensagem" runat="server" />
                        <asp:DropDownList ID="ddlTipoMensagem" runat="server" CausesValidation="False" AutoPostBack="True" />
                    </label>
                </asp:PlaceHolder>
                <label>
                    <asp:PlaceHolder ID="phConfigMensagem" runat="server" />
                </label>
            </div>
        </telerik:radpageview>
        <telerik:radpageview runat="server" id="configsla">
            <asp:Repeater ID="rptSLA" runat="server">
                <HeaderTemplate>
                    <table class="sla">
                        <colgroup>
                            <col width="40%" />
                            <col width="20%" />
                            <col width="40%" />
                        </colgroup>
                        <thead>
                            <tr>
                                <th>
                                    <asp:Literal ID="lblSLA" runat="server" /></th>
                                <th>
                                    <asp:Literal ID="lblUnidade" runat="server" /></th>
                                <th>
                                    <asp:Literal ID="lblPrazo" runat="server" /></th>
                            </tr>
                        </thead>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <asp:HiddenField ID="slaID" runat="server" />
                            <div id="divCor" runat="server" class="sla-color"></div>
                            <asp:Label ID="lblSLAName" runat="server" />
                        </td>
                        <td>
                            <asp:DropDownList ID="ddlType" runat="server" />
                        </td>
                        <td>
                            <zzf:zuricontextlist id="ddlSLA" width="100%" filterproviders="REQUESTINFO;CTXWORKFLOWDATA" dropdownautowidth="enabled" pagersize="10" runat="server" />
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </telerik:radpageview>
        <telerik:radpageview runat="server" id="Avancadas">
            <div class="fields">
                <label>
                    <asp:Label ID="lblAlias" runat="server" />
                    <asp:TextBox ID="txtAlias" runat="server" MaxLength="100" />
                </label>
                <label>
                    <asp:CheckBox ID="chkautoexec" CssClass="checkbox" runat="server" />
                </label>
                <label>
                    <asp:CheckBox ID="chkContinuous" CssClass="checkbox" runat="server" />
                </label>
                <label>
                    <asp:CheckBox ID="chkAutoDetach" CssClass="checkbox" runat="server" />
                </label>
                <label>
                    <asp:CheckBox ID="chkVinculada" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:CheckBox ID="chkVinculadaG" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:CheckBox ID="chkAtribuicao" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:CheckBox ID="chkattribreq" runat="server" CssClass="checkbox" />
                </label>
                <asp:UpdatePanel ID="pnldelega" runat="server" UpdateMode="Conditional">
                    <ContentTemplate>
                        <label>
                            <asp:CheckBox ID="chkdelegate" runat="server" CssClass="checkbox" AutoPostBack="True" />
                        </label>
                        <asp:PlaceHolder ID="delegar" runat="server" Visible="false">
                            <label>
                                <asp:Label ID="lblgrupodelega" runat="server" />
                                <wff:rolepicker id="myRolePicker" runat="server" />
                            </label>
                        </asp:PlaceHolder>
                    </ContentTemplate>
                </asp:UpdatePanel>
                <asp:UpdatePanel ID="pnkDelHistory" runat="server" UpdateMode="Conditional">
                    <ContentTemplate>
                        <label>
                            <asp:CheckBox ID="chkdelAttachments" runat="server" CssClass="checkbox" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkDelHistory" runat="server" CssClass="checkbox" />
                        </label>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </div>
        </telerik:radpageview>
        <telerik:radpageview runat="server" id="Jornada">
            <div class="config workhours">
                <div>
                    <asp:Label ID="lblsegsex" runat="server" />
                    <asp:TextBox ID="txtsegsexini" runat="server" CssClass="time" MaxLength="5" />
                    <asp:Label ID="lbla1" runat="server" />
                    <asp:TextBox ID="txtsegsexfim" CssClass="time" runat="server" MaxLength="5" />
                    <asp:RegularExpressionValidator ID="vlsegsexini" runat="server" ControlToValidate="txtsegsexini"
                        ValidationExpression="([01]?[0-9]|2[0-3]):[0-5][0-9]" Display="Dynamic" />
                    <asp:RegularExpressionValidator ID="vlsegsexfim" runat="server" ControlToValidate="txtsegsexfim"
                        ValidationExpression="([01]?[0-9]|2[0-3]):[0-5][0-9]" Display="Dynamic" />
                </div>
                <div>
                    <asp:Label ID="lblsabado" runat="server" />
                    <asp:TextBox ID="txtsabadoini" runat="server" CssClass="time" MaxLength="5" />
                    <asp:Label ID="lbla2" runat="server" />
                    <asp:TextBox ID="txtsabadofim" CssClass="time" runat="server" MaxLength="5"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="vlsabadoini" runat="server" ControlToValidate="txtsabadoini"
                        ValidationExpression="([01]?[0-9]|2[0-3]):[0-5][0-9]" Display="Dynamic" />
                    <asp:RegularExpressionValidator ID="vlsabadofim" runat="server" ControlToValidate="txtsabadofim"
                        ValidationExpression="([01]?[0-9]|2[0-3]):[0-5][0-9]" Display="Dynamic" />
                </div>
                <div>
                    <asp:Label ID="lbldomingo" runat="server" />
                    <asp:TextBox ID="txtdomingoini" runat="server" CssClass="time" MaxLength="5" />
                    <asp:Label ID="lbla3" runat="server" />
                    <asp:TextBox ID="txtdomingofim" CssClass="time" runat="server" MaxLength="5" />
                    <asp:RegularExpressionValidator ID="vldomingoini" runat="server" ControlToValidate="txtdomingoini"
                        ValidationExpression="([01]?[0-9]|2[0-3]):[0-5][0-9]" Display="Dynamic" />
                    <asp:RegularExpressionValidator ID="vldomingofim" runat="server" ControlToValidate="txtdomingofim"
                        ValidationExpression="([01]?[0-9]|2[0-3]):[0-5][0-9]" Display="Dynamic" />
                </div>
            </div>
        </telerik:radpageview>
    </telerik:radmultipage>
    <section class="actions">
        <asp:Button ID="btnok" runat="server" />
        <input id="btncancel" type="button" value="button" runat="server" />
    </section>
</asp:Content>
