﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="ConfigMarker.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.ConfigMarker" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style type="text/css">
        a.edit, a.remove {
            white-space: nowrap;
            text-indent: 100%;
            overflow: hidden;
            display:inline-block;
            width:24px;
            height:24px;
            background-size:contain;
        }

        .marker-actions{
            width:70px;
            text-align:center;
        }

        a.edit {
            background: url(data:image/gif;base64,R0lGODlhDwAPAIQAAERCRKSmpNTW1ISChGRiZLy+vPT29FRSVOTm5JyanLS2tGxqbMzOzExKTKyurNze3IyOjERGRKyqrNza3ISGhGRmZMTGxPz+/FRWVOzq7JyenGxubNTS1P///wAAAAAAACH5BAEAAB0ALAAAAAAPAA8AAAVPYCeOooARDKl2FwEA0bOOHPQC3NwZR+VsG10ncaNkdIhIUTi4RY4zzg2g0V0Wt4NBV5gqhImAsnLRGRydzCalmwg6goCwY3lw0HPOgq0LAQA7) no-repeat center center;
        }

        a.remove {
            background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAA/klEQVR4Ae3TA2j3YRDA8ZeTsj0baciz7czFZUuz0pymbGsZs3Nzbs7j7Tvp+tu6+vx4j/QrEH4ceTk5nejFHxM5aZhFkjUV/0UH7iDox18DeYnYhWANCZY2UIh7yDeDKicJOypn0dIGIjEBUQbxBzHYUv8u0WjtNI1BlEksq28XqLBlkUNUI4aco9KenfQXI7iDKKcoc8R2TcQFRFlwROVJWIcYcIdueypPMLBbHiBKvy2Vx2DDwFZswpChRvDP0srTsWdgK1a+//+PcYgybE0Dh5B3V6hVOcGY1GfEmilKxQFuUGUk5w+m8YBxBFu7DlkoMJMTjnZE/QqEx8Yz0PfXTgfTascAAAAASUVORK5CYII=) no-repeat center center;
        }
    </style>
    <script type="text/javascript">
        function OnClientItemsRequesting(sender, eventArgs) {
            var namesCombo = $find('<%= ddlName.ClientID%>');
            var context = eventArgs.get_context();
            context["namesValue"] = namesCombo.get_value();;
            context["namesText"] = namesCombo.get_text();;
        }

        function LimpaValores(sender, eventArgs) {
            var namesCombo = $find('<%= ddlValue.ClientID%>');
                namesCombo.clearItems();
            }
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <h1>
        <asp:Label ID="lblTitulo" runat="server" /></h1>
    <asp:Panel ID="pnlList" runat="server">
        <table>
            <colgroup>
                <col />
                <col class="marker-actions" />
            </colgroup>
            <thead>
                <tr>
                    <th colspan="2"><asp:Literal runat="server" ID="ltHead" Text="Marker" /></th>
                </tr>
            </thead>
            <asp:Repeater ID="rptMarkers" runat="server">
                <ItemTemplate>
                    <tr>
                        <td>
                            <asp:Label ID="lblName" runat="server" /></td>
                        <td>
                            <asp:LinkButton ID="btnEdit" CssClass="edit" runat="server" Text="edit" />
                            <asp:LinkButton ID="btnDel" CssClass="remove" runat="server" Text="remove" />
                        </td>
                    </tr>
                </ItemTemplate>
            </asp:Repeater>
        </table>
    </asp:Panel>
    <asp:Panel ID="pnlItem" runat="server" CssClass="fields no-columns">
        <asp:HiddenField ID="markerId" runat="server" />
        <label>
            <asp:Label ID="lblName" runat="server" />
            <telerik:RadComboBox ID="ddlName" OnItemsRequested="CarregaMarcadores"
                OnClientSelectedIndexChanging="LimpaValores"
                MarkFirstMatch="true" EnableLoadOnDemand="true" runat="server" />
        </label>
        <label>
            <asp:Label ID="lblValue" runat="server" />
            <telerik:RadComboBox ID="ddlValue" OnItemsRequested="CarregaValores"
                OnClientItemsRequesting="OnClientItemsRequesting"
                MarkFirstMatch="true" EnableLoadOnDemand="true" runat="server" />
        </label>
    </asp:Panel>
    <section class="actions">
        <asp:Button ID="btnNew" runat="server" />
        <asp:Button ID="btnAdd" runat="server" />
        <asp:Button ID="btnCancel" runat="server" />
        <input id="btnClose" type="button" value="button" runat="server" />
    </section>

</asp:Content>
