﻿<%@ page language="vb" autoeventwireup="false" masterpagefile="~/WFAdmin/AdmMaster.Master" codebehind="Formularios.aspx.vb" inherits="WebFoundations.WFForms.UI.Formularios" %>

<%@ register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>
<%@ register src="~/WFControls/WFPagePicker.ascx" tagname="WFPagePicker" tagprefix="uc1" %>
<%@ register tagprefix="wff" namespace="WebFoundations.ServerControls" assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';

        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                __doPostBack(hiddenFieldID, '');
            }
        }

        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }

        var selectedArea = function () { return document.getElementById('<%=SelectedAreaId.ClientID%>').value; };
        var postbackHidden = '<%=PostBackHidden.ClientID%>';

        var msgSelectAForm = '<%=SelectAFormMessage%>'
        var msgConfirmDelete = '<%=ConfirmDeleteMessage%>';

        function editForm() {
            if (MySelectedItem) {
                openEditor(MySelectedItem);
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }

        function openTest() {
            if (MySelectedItem) {
                var ww = 800, wh = 600;
                var m = 10;
                if (screen) {
                    ww = Math.floor(Math.min(1600, Math.max(ww, screen.availWidth * .9)));
                    wh = Math.floor(Math.min(wh, screen.availHeight * .9));
                    m = Math.floor(Math.max(m, Math.min(screen.availHeight, screen.availWidth) * .05));
                    console.log(ww, wh, m);
                }
                var url = "Editor/FormTest.aspx?AreaId=" + selectedArea() + "&FormId=" + MySelectedItem + "&rwndrnd=" + Math.random();
                var w;
                try {
                    var features = 'resizable=1,directories=0,toolbar=0,scrollbars,status,menubar=0,location,personalbar=0,dependent,top=' + m + ',left=' + m + ',width=' + ww + ',height=' + wh;
                    console.log(features);
                    w = window.open(url, "formstest", features)
                } catch (error) {
                    console.log("openPreview", error);
                } finally {
                    if (w && w.focus) {
                        w.focus();
                    } else {
                        alert("Não foi possível abrir a janela de teste do formulário. Verifique se o browser está bloqueando popups.");
                    }
                }
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }


        function openEditor(item) {
            var ww = 800; var wh = 600; if (screen) { ww = screen.availWidth; wh = screen.availHeight; }
            var url = "?AREAID=" + selectedArea();
            if (item) {
                url = "Editor/MainEditor.aspx" + url + "&Id=" + item + "&FormId=" + item;
            } else {
                url = "FormEdit.aspx" + url;
            }

            var w;
            try {
                w = window.open(url, 'formsdesigner', 'resizable=1,directories=0,toolbar=0,scrollbars=1,status=0,menubar=0,location=0,top=0,left=0,width=' + ww + ',height=' + wh);
            } catch (error) {
                console.log("openEditor", error);
            } finally {
                if (w && w.focus) {
                    w.focus();
                    w.moveTo(0, 0);
                    w.resizeTo(ww, wh);
                } else {
                    alert("Não foi possível abrir a janela de edição de formulários. Verifique se o browser está bloqueando popups.")
                }
            }
        }

        function checkDelete() {
            if (MySelectedItem) {
                if (confirm(msgConfirmDelete)) {
                    postBackDelete(postbackHidden)
                };
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }

        function refreshGrid() {
            postBackHiddenField(postbackHidden);
            return false;
        }

        function showExportForm() {
            if (MySelectedItem) {
                window.radopen("FormExport.aspx?AREAID=" + selectedArea() + "&Id=" + MySelectedItem, "ExportDialog");
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }

        function showImportForm() {
            window.radopen("FormImport.aspx?AREAID=" + selectedArea(), "ImportDialog");
            return false;
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <a href="#" class="add" onclick="return openEditor();">
                <asp:Literal ID="lnkadd" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="edit" onclick="return editForm();">
                <asp:Literal ID="lnkconfig" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="test" onclick="return openTest();">
                <asp:Literal ID="lnktest" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="delete" onclick="return checkDelete();">
                <asp:Literal ID="lnkdelete" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="refresh" onclick="return refreshGrid();">
                <asp:Literal ID="lnkrefresh" runat="server" />
            </a>
        </li>
        <li style="display: none;">
            <asp:LinkButton ID="lnkexport" CssClass="export" runat="server" />
        </li>
        <li>
            <a href="#" class="download" onclick="return showExportForm();">
                <asp:Literal ID="lnkdownload" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="upload" onclick="return showImportForm();">
                <asp:Literal ID="lnkupload" runat="server" />
            </a>
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:wfpagepicker id="portalpicker" runat="server" width="199" addselect="false" forcecheckevenforsiteadmin="true"
            adminmode="true" autoselectlast="true" showarea="true" showpage="false" nolabels="false" />
        <div>
            <asp:Label ID="lblName" runat="server" />
            <asp:TextBox ID="txtName" runat="server" />
        </div>
    </div>
    <asp:Button ID="btnbuscar" runat="server" ValidationGroup="SEARCH" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="updateform" runat="server">
        <contenttemplate>
            <telerik:radgrid id="grdFormulario" cssclass="wfforms-list" runat="server" autogeneratecolumns="false" allowsorting="True" gridlines="None" allowpaging="True" pagesize="15">
                <mastertableview>
                    <columns>
                        <telerik:gridtemplatecolumn headertext="" uniquename="PUBLISHED" headerstyle-width="40px" headerstyle-horizontalalign="center" itemstyle-horizontalalign="center" itemstyle-verticalalign="middle">
                            <itemtemplate>
                                <asp:Image ID="imgPublished" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Titulo" HeaderText="Titulo" UniqueName="Titulo" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Apelido" HeaderText="Apelido" UniqueName="Apelido" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="DataPublicacao" HeaderText="Última Publicação" UniqueName="DataPublicacao" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="PublisherName" HeaderText="Último Editor" UniqueName="Editor" ItemStyle-HorizontalAlign="center" />
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnHide="false" Selecting-AllowRowSelect="true"
                    Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Pages" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server" />
            <asp:HiddenField ID="SelectedAreaId" runat="server" />
        </contenttemplate>
        <triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </triggers>
    </asp:UpdatePanel>

    <wff:windowmanager id="EditWindow" runat="server">
        <windows>
            <telerik:radwindow id="ExportDialog" runat="server" height="450px" width="800px" reloadonshow="true" modal="true" />
            <telerik:radwindow id="ImportDialog" runat="server" height="450px" width="800px" reloadonshow="true" modal="true" />
        </windows>
    </wff:windowmanager>
</asp:Content>

