﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="MainEditor.aspx.vb" Inherits="WebFoundations.WFForms.UI.MainEditor" EnableEventValidation="false" %>

<%@ Register Src="~/WFAdmin/TagHeadAdmin.ascx" TagPrefix="wf" TagName="TagHeadAdmin" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/WFAdmin/WFForms/Editor/ConfigFrame.ascx" TagPrefix="wf" TagName="ConfigFrame" %>
<%@ Register Src="~/WFAdmin/WFForms/Editor/DataFrame.ascx" TagPrefix="wf" TagName="DataFrame" %>
<%@ Register Src="~/WFAdmin/WFForms/Editor/FormSettings.ascx" TagPrefix="fs" TagName="FormSettings" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <wf:tagheadadmin runat="server" id="TagHeadAdmin" />
    <script type="text/javascript">
        (function ($) {
            $.fn.resizable = function () {
                this.each(function () {
                    if (this && this.addEventListener && this.getBoundingClientRect && !this.ninkiResize) {
                        this.ninkiResize = true;

                        var down = function (ev) {
                            var bounds = this.getBoundingClientRect();

                            var checkHit = function () {
                                var result = (
                                    ev.offsetX < 4 || //se clicou na borda esquerda
                                    (ev.offsetX >= (bounds.width - 16) && ev.offsetY >= (bounds.height - 16)) //se clicou no símbolo no canto inferior direito
                                );
                                console.log({
                                    name: "resizable checkHit",
                                    offsetX: ev.offsetX,
                                    offsetY: ev.offsetY,
                                    width: bounds.width,
                                    height: bounds.height,
                                    result: result
                                });
                                return result;
                            }

                            if (checkHit()) {
                                (function (e, obj, bounds) {
                                    var start = { x: ev.clientX, y: ev.clientY };

                                    var myup = function (ev) {
                                        obj.ownerDocument.removeEventListener("mouseup", myup, true);
                                        obj.ownerDocument.removeEventListener("mousemove", mymove, true);
                                        start = null;
                                        ev.stopImmediatePropagation();
                                    };

                                    var mymove = function (ev) {
                                        var d = { x: ev.clientX - start.x, y: ev.clientY - start.y };
                                        var s = {
                                            w: Math.max(bounds.width + d.x, 0),
                                            h: Math.max(bounds.height + d.y, 0)
                                        };
                                        $(obj).width(s.w).height(s.h);
                                        ev.stopImmediatePropagation();
                                    };

                                    obj.ownerDocument.addEventListener("mouseup", myup, true);
                                    obj.ownerDocument.addEventListener("mousemove", mymove, true);
                                })(ev, this, bounds);

                                ev.preventDefault();
                                ev.stopImmediatePropagation();
                                select(this.outerHTML);
                                return false;
                            }
                        }

                        this.addEventListener("mousedown", down, false);
                    }
                });
                return this;
            };

            var myEditor;
            var myPageId = %%PAGEID%%;
            var myFormId = %%FORMID%%;
            var contrHtml;
            var confFrame;

            function turnDivControlsResizable(editor) {
                $("div[moditemid]", editor.get_contentArea()).resizable();
            }

            function handleUnstyledTables(content) {
                try {
                    const tables = content.querySelectorAll('table');
                    tables.forEach(table => {
                        table.classList.add('unstyled', 'form-table');
                    })
                } catch (e) {
                    console.log("ERROR: ", e);
                }
            }

            window.OnClientLoad = function (editor) {
                myEditor = editor;
                turnDivControlsResizable(editor);
                handleUnstyledTables(editor.get_contentArea());
            };

            function select(contrHtml) {
                var hiddenTxt = document.getElementById('txtHidden');
                if (contrHtml != '') {
                    var idd, aId, fId, objName, mItemId, a, t;
                    idd = ''; aId = ''; fId = '';
                    objName = contrHtml.substring(contrHtml.indexOf(' id=') + 4);
                    objName = objName.substring(0, objName.indexOf(' '));
                    objName = objName.replace('"', '').replace('"', '');
                    mItemId = contrHtml.substring(contrHtml.indexOf(' moditemid="') + 12);
                    mItemId = mItemId.substring(0, mItemId.indexOf('"'));
                    if (mItemId == '' || contrHtml.indexOf(' moditemid="') === -1) {
                        return false;
                    }
                    t = contrHtml.substring(contrHtml.indexOf(' tipo="') + 7);
                    t = t.substring(0, t.indexOf('"'));
                    var queries = window.location.search.split(/[\?&]+/);
                    if (queries != null && queries.length > 0) {
                        for (var i = 0; i < queries.length; i++) {
                            if (queries[i].substring(0, 2) == 'Id') { idd = queries[i].substring(3); }
                            if (queries[i].substring(0, 6) == 'AREAID') { aId = queries[i].substring(7); }
                            if (queries[i].substring(0, 6) == 'FormId') { fId = queries[i].substring(7); }
                        }
                    }
                    hiddenTxt.value = 'AREAID=' + aId + '&Id=' + idd + '&FormId=' + fId + '&ObjectName=' + objName + '&ModItemId=' + mItemId + '&Type=' + t;
                    __doPostBack('lnkConfigFrame', '');
                }
                else {
                    return false;
                }
            }
            window.OnClientSelectionChange = function (editor) {
                if (editor.getSelectionHtml() != '') {
                    select(editor.getSelectionHtml());
                } else {
                    //Este codigo serve para garantir que clicando ao fim de um div permite a onclusão de um texto
                    var existingHTML = editor.get_html(true);
                    if (existingHTML.endsWith('</div>')) {
                        editor.set_html(existingHTML + '&nbsp;');
                    }
                }
            };

            window.AddHTMLBlock = function (EditorControl, HTMLBlock) {
                EditorControl.pasteHtml(HTMLBlock);
                turnDivControlsResizable(EditorControl);
                __doPostBack('lnkConfigFrame', '');
            };

            window.GetNewControlId = function (ControlName) {
                var intControlId = 0;
                var myHTML = myEditor.get_html();
                if (myHTML != '') {
                    var strControls = new Array();
                    strControls = myHTML.split('id="' + ControlName);
                    for (var i = 1; i < strControls.length; i++) {
                        var strUltimoControleId = strControls[i].split(" ")[0].split("p")[1];
                        if (parseInt(intControlId) < parseInt(strUltimoControleId)) {
                            intControlId = strUltimoControleId;
                        }
                    }
                }
                intControlId = parseInt(intControlId) + 1;
                return ControlName + myPageId + 'p' + intControlId;
            };

            window.OnClicking = function (sender, eventArgs) {
                switch (eventArgs.Item.Value) {
                    case undefined:
                        return false;
                        break;
                    case 'insertdata':
                        return false;
                        break;
                    case 'test':
                        return false;
                        break;
                    default:
                        return true;
                }
            };

            window.UpdateDataPanel = function (formula) {
                if (formula) {
                    __doPostBack('btnRefreshFormulas', null);
                } else {
                    __doPostBack('btnRefreshDataSources', null);
                }
            };

            $(document).ready(function () {
                $("a.form-config").click(function () {
                    var isopen = $("div.form-config").is(":visible");
                    if (!isopen) {
                        $("div.form-config").css({ display: "inline-block" });
                        $("aside.sidebar").addClass("active");
                    } else {
                        $("div.form-config .form-save").click();
                    }
                    return false;
                });
            });

            window.onFormSaved = function () {
                if (window) {
                    var o = window.opener;
                    if (o && o.refreshGrid) {
                        try { o.refreshGrid(); } catch (error) { }
                    }
                    try {
                        $("aside.sidebar").removeClass("active");
                        $("div.form-config").hide();
                    } catch (error) { }
                }
            };

            window.onTitleChange = function (value) {
                $("h2#form-title").text(value || "");
            }

            //ao fechar a janela, faz o update da listagem
              $(window).on("unload", function () {
                if (window.opener && window.opener.refreshGrid) {
                    try {
                        window.opener.refreshGrid();
                    } catch (error) { }
                }
            }) 

            window.OnClientPasteHtml = function (sender, args) {
                var commandName = args.get_commandName();
                var value = args.get_value();

                console.log(commandName)
                console.log(value)

                if (commandName == "InsertTable") {
                    var div = document.createElement("DIV");

                    Telerik.Web.UI.Editor.Utils.setElementInnerHtml(div, value);
                    var table = div.firstChild;
                    table.classList.add('unstyled');
                    args.set_value(div.innerHTML);
                }
            }

        })(jQuery);
    </script>
    <style type="text/css">
        div[moditemid] {
            position: relative;
        }

        div[moditemid]:after {
            position: absolute;
            content: "\25e2"; /*http://www.w3schools.com/charsets/ref_utf_geometric.asp */
            right: 0;
            bottom: 2px;
            width: 1em;
            height: 1em;
            color: gray;
            text-align: right;
            cursor: nwse-resize;
            pointer-events: all;
            font-size: 16px;
        }
    </style>
</head>
<body class="wf-designer forms-designer">
    <form runat="server">
        <asp:ScriptManager runat="server" />
        <header>
            <div class="logo-container">
                <svg xmlns="http://www.w3.org/2000/svg" width="53" height="48" viewBox="0 0 53 48" fill="none">
                    <path d="M9.5 0.5H49.5L50.5 8.5H3L9.5 0.5Z" fill="#00ABF8" />
                    <path d="M40.7687 8.31458L50.5001 8.5005L26.9858 36.989L17.7666 36.8128L40.7687 8.31458Z" fill="#00ABF8" />
                    <path d="M52 5C51.3937 7.42536 50.5 9.5 48.5 9.5C46.8431 9.5 46 6.433 46 4.5C46 2.567 47.8431 0.5 49.5 0.5C51.1569 0.5 52.5 3 52 5Z" fill="#00ABF8" />
                    <path d="M50.5 39H1.90524L3 47H44L50.5 39Z" fill="white" />
                    <path d="M25.0021 10.6837L34.7335 10.8696L11.2192 39.3581L2.00003 39.182L25.0021 10.6837Z" fill="white" />
                    <path d="M0.443981 42.5632C0.994062 40.1316 2.5 38.4996 3.72558 38.0262C5.19703 37.4579 6.13989 41.0664 6.16152 42.9993C6.18316 44.9321 4.45164 47.0187 2.87433 47.0363C1.29702 47.054 -0.00962732 44.5685 0.443981 42.5632Z" fill="white" />
                </svg>
                <h1>
                    <asp:Literal ID="ltTitle" runat="server" />
                </h1>
            </div>
            <h2 id="form-title">
                <asp:Literal ID="ltName" runat="server" /></h2>
            <menu type="toolbar" id="toolbar">
                <li class="formulas">
                    <input type="radio" name="toolgroup" id="toolgroup-formula" checked="checked" />
                    <label for="toolgroup-formula">
                        <asp:Literal ID="ltFormulas" runat="server" Text="Fórmulas" /></label>
                    <div class="content">
                        <asp:HyperLink ID="lnkInsertFormula" CssClass="add" runat="server" Text="Adicionar" />
                        <asp:UpdatePanel ID="updDataFormulas" class="data-sources" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <wf:dataframe id="formulasFrame" runat="server" formulas="true" />
                                <asp:Button ID="btnRefreshFormulas" runat="server" Style="display: none;" />
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </div>
                </li>
                <li class="data">
                    <input type="radio" name="toolgroup" id="toolgroup-data" />
                    <label for="toolgroup-data">
                        <asp:Literal ID="ltData" runat="server" Text="Dados" /></label>
                    <div class="content">
                        <asp:HyperLink ID="lnkInsertData" CssClass="add" runat="server" Text="Adicionar" />
                        <asp:UpdatePanel ID="updDataPanel" class="data-sources" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <wf:dataframe id="dataSourcesFrame" runat="server" />
                                <asp:Button ID="btnRefreshDataSources" runat="server" Style="display: none;" />
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </div>
                </li>
            </menu>
        </header>
        <main>
            <telerik:radtabstrip id="tabPages" runat="server" autopostback="true" />
            <telerik:radeditor runat="server" cssclass="maineditor" id="HTMLContent" width="100%" height="100%"
                onclientselectionchange="OnClientSelectionChange" haspermission="True" enabledocking="false"
                allowthumbgeneration="false" showsubmitcancelbuttons="false" allowscripts="true" cachelocalization="true"
                localizationpath="~/wfresources/formsweb/Editor/Localization"
                toolsfile="~/wfresources/formsweb/Editor/WFFormsToolbar.xml" spellallowaddcustom="False" causesvalidation="False"
                onclientload="OnClientLoad" toolbarmode="RibbonBar" onclientpastehtml="OnClientPasteHtml" />
            <asp:PlaceHolder ID="phEditorScripts" runat="server" />
        </main>
        <aside class="sidepanel props">
            <asp:UpdatePanel ID="updConfigs" runat="server" UpdateMode="Conditional">
                <ContentTemplate>
                    <wf:configframe clientidmode="Static" name="cFrame" runat="server" id="ConfigFrame" />
                    <asp:LinkButton ID="lnkConfigFrame" runat="server" />
                </ContentTemplate>
            </asp:UpdatePanel>
        </aside>
        <aside class="sidebar form-info">
            <menu>
                <li class="activate">
                    <asp:LinkButton ID="lnkGenerate" runat="server" />
                </li>
                <li class="test">
                    <asp:HyperLink ID="lnkTest" runat="server" />
                </li>
                <li id="liInsertPage" runat="server">
                    <asp:LinkButton ID="lnkInsertPage" CssClass="inserir-pag" runat="server" />
                </li>
                <li class="config">
                    <asp:LinkButton ID="lnkSettings" CssClass="form-config" runat="server" />
                </li>
            </menu>
            <asp:UpdatePanel runat="server" class="fields form-config" ID="uppFormInfo">
                <ContentTemplate>
                    <fs:formsettings runat="server" id="FormSettings" />
                </ContentTemplate>
            </asp:UpdatePanel>
        </aside>
        <wff:windowmanager id="EditWindow" runat="server">
            <windows>
                <telerik:radwindow id="EditDialog" runat="server" behaviors="Close,Move,Reload,Resize" height="800px" visiblestatusbar="false" width="1050px" reloadonshow="true" modal="true" />
            </windows>
        </wff:windowmanager>
    </form>
</body>
</html>
