﻿<%@ Page Language="vb" MasterPageFile="~/WFAdmin/ModalAdminPage.master" AutoEventWireup="false" CodeBehind="ConfigDataSources.aspx.vb" Inherits="WebFoundations.WFForms.UI.ConfigDataSources" %>

<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>
<%@ Register Src="~/WFAdmin/WFForms/Components/RestApiParameters.ascx" TagPrefix="wf" TagName="RestApiParameters" %>
<%@ Register Src="~/WFAdmin/WFForms/Components/RestApiHeaders.ascx" TagPrefix="wf" TagName="RestApiHeaders" %>
<%@ Register Src="~/WFAdmin/WFForms/Components/OutputsByStatusCode.ascx" TagPrefix="wf" TagName="OutputsByStatusCode" %>

<asp:Content ContentPlaceHolderID="taghead" runat="server">
    <script type="text/javascript">
        function CloseAndRebind(formula) {
            try {
                var w = GetRadWindow();
                if (w) {
                    w.Close();
                    w.BrowserWindow.UpdateDataPanel(formula);
                }
            } catch (error) { }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:PlaceHolder ID="pnlInsert" runat="server">
        <section class="actions">
            <asp:Button ID="btnInserirSQL" Width="150px" runat="server" />
            &nbsp;&nbsp;
            <asp:Button ID="btnInserirXML" Width="150px" runat="server" />
            &nbsp;&nbsp;
            <asp:Button ID="btnInsertForm" Width="150px" runat="server" />
            &nbsp;&nbsp;
            <asp:Button ID="btnInserirFormula" Width="150px" runat="server" />
            &nbsp;&nbsp;
            <asp:Button ID="btnInserirWEB" Width="150px" runat="server" />
            &nbsp;&nbsp;
            <asp:Button ID="btnInserirRest" Width="150px" runat="server" />
            &nbsp;&nbsp;
        </section>
    </asp:PlaceHolder>
    <!------------------------------Painel PROCEDURE------------------------------------------>
    <asp:PlaceHolder ID="pnlSQL" runat="server" Visible="false">
        <div class="fields no-columns">
            <h4>
                <asp:Literal ID="lblSubTitleSql" runat="server" /></h4>
            <label>
                <asp:Label ID="lblconnection" runat="server" />
                <asp:DropDownList ID="lstconnection" runat="server" />
            </label>
            <div>
                <asp:Label ID="lblprocname" runat="server" />
                <div>
                    <asp:TextBox ID="txtprocname" runat="server" Style="width: 80%; display: inline;" MaxLength="100" />
                    <asp:Button ID="btnconfig" Style="width: 80px; display: inline; margin-left: 5px;" runat="server" />
                    <asp:RequiredFieldValidator ID="obrprocname" runat="server" ControlToValidate="txtprocname" Display="Dynamic" />
                </div>
            </div>
            <asp:PlaceHolder ID="phParametros" runat="server">
                <h4>
                    <asp:Literal ID="lbltestparam" runat="server" /></h4>
                <asp:Repeater ID="lstParam" runat="server">
                    <HeaderTemplate>
                        <table>
                            <tr class="gridCaption">
                                <td>
                                    <asp:Label ID="lblParametros" runat="server" />
                                </td>
                                <td>
                                    <asp:Label ID="lblParDefValue" runat="server" />
                                </td>
                                <td>
                                    <asp:Label ID="lblContexto" runat="server" />
                                </td>
                                <td>
                                    <asp:Label ID="lblTeste" runat="server" />
                                </td>
                            </tr>
                    </HeaderTemplate>
                    <FooterTemplate>
                        </table>
                    </FooterTemplate>
                    <ItemTemplate>
                        <tr class="gridRow">
                            <td>
                                <asp:Label ID="lblparname" runat="server" CssClass="destaque" />
                                <asp:Label ID="lblpardets" runat="server" Visible="false" />
                            </td>
                            <td>
                                <asp:TextBox ID="txtparvalue" runat="server" Text="NULL" />
                            </td>
                            <td>
                                <asp:DropDownList ID="lstContext" runat="server" />
                            </td>
                            <td>
                                <asp:TextBox ID="txtpartstvalue" runat="server" Text="NULL" />
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </asp:PlaceHolder>
            <asp:PlaceHolder ID="phParamSaida" runat="server">
                <div>
                    <h4>
                        <asp:Literal ID="lblParamSaida" runat="server" /></h4>
                    <div>
                        <asp:Label ID="lblCampos" runat="server" CssClass="destaque"></asp:Label>
                    </div>
                </div>
            </asp:PlaceHolder>
        </div>
        <section class="actions">
            <asp:Button ID="btntest" runat="server" Width="100px" Visible="False" />
            <asp:Button ID="btnok" runat="server" Visible="False" />
            <asp:Button ID="btncancelsql" runat="server" Text="btncancelsql" CausesValidation="False" />
            <asp:Label ID="lblformat" runat="server" Visible="False" />
        </section>
    </asp:PlaceHolder>
    <!------------------------------Painel XML------------------------------------------>
    <asp:PlaceHolder ID="pnlXML" runat="server" Visible="false">
        <div class="fields no-columns">
            <!--------------------------------------------------->
            <h4>
                <asp:Literal ID="lblSubTitleXML" runat="server" /></h4>
            <asp:RadioButtonList runat="server" ID="rdbXmlType" AutoPostBack="true" OnSelectedIndexChanged="rdbXmlType_SelectedIndexChanged" RepeatDirection="Horizontal">
                <asp:ListItem Text="Arquivo" Value="file" Selected="True" />
                <asp:ListItem Text="Formulário" Value="form" />
            </asp:RadioButtonList>
            <label runat="server" id="pnlXmlFile">
                <asp:Label ID="lblfilename" runat="server" />
                <input id="impupload" type="file" name="impupload" runat="server" />
            </label>
            <label runat="server" id="pnlXmlForm" visible="false">
                <asp:Label runat="server" ID="lblXmlForm" />
                <asp:DropDownList runat="server" ID="ddlXmlForm" />
            </label>
        </div>
        <section class="actions">
            <asp:Button ID="btnokxml" runat="server" Text="OK" />
            <asp:Button ID="btncancelxml" runat="server" Text="btncancelxml" />
        </section>
    </asp:PlaceHolder>
    <!------------------------------Painel FORMULÁRIO------------------------------------------>
    <asp:PlaceHolder ID="pnlForm" runat="server" Visible="false">
        <asp:HiddenField runat="server" ID="hidFormDataSourceName" />
        <div class="fields no-columns">
            <!--------------------------------------------------->
            <h4>
                <asp:Literal ID="lblSubTitleForm" runat="server" /></h4>
            <label>
                <asp:Label ID="lblFormName" runat="server" />
                <asp:DropDownList runat="server" ID="ddlForms" AutoPostBack="true" OnSelectedIndexChanged="ddlForms_SelectedIndexChanged" />
            </label>
        </div>
        <div runat="server" id="divFields">
            <div>
                <label>
                    <asp:Label runat="server" ID="lblOrderByFieldForm" />
                    <asp:DropDownList runat="server" ID="ddlOrderByFieldForms" />
                    <asp:RadioButtonList runat="server" ID="rdbOrderByFieldsForms" RepeatDirection="Horizontal">
                        <asp:ListItem Text="Sem ordenação" Value="0" />
                        <asp:ListItem Text="Ascendente" Value="1" />
                        <asp:ListItem Text="Descendente" Value="2" />
                    </asp:RadioButtonList>
                </label>
            </div>
            <div style="padding-bottom: 2em;">
                <label>
                    <div style="width: 100%; padding-top: 2em; padding-bottom: 2em">
                        <div style="width: 45%; float: left">
                            <asp:Label ID="lblFormFields" runat="server" />
                        </div>
                        <div style="width: 45%; float: right">
                            <asp:Label ID="lblusedFields" runat="server" />
                        </div>
                    </div>
                </label>
                <wff:selectlist id="dataFieldsForms" autopostback="false" runat="server" />
            </div>
        </div>
        <section class="actions">
            <asp:Button ID="btnOKForm" runat="server" Text="OK" OnClick="btnOKForm_Click" />
            <asp:Button ID="btnCancelForm" runat="server" Text="btncancelxml" OnClick="btnCancelForm_Click" />
        </section>
    </asp:PlaceHolder>
    <!------------------------------Painel REST--------------------------------------->
    <asp:PlaceHolder ID="pnlRest" runat="server" Visible="false">
        <style type="text/css">
            .config-error {
                max-height: 9em;
                overflow: auto;
                background: rgba(255,0,0,.15);
                margin-bottom: .5em;
            }

                .config-error li {
                    white-space: pre-wrap;
                    margin: .5em;
                }

            .fields > fieldset > .rest-method, .fields > fieldset > .rest-reqtype, .fields > fieldset > .rest-addheader {
                display: grid;
                grid-template-columns: 15em;
                grid-column-gap: .5em;
            }

            .rest-addheader input, .rest-addparam input {
                max-width: 7em !important;
            }

            .rest-method select, .rest-reqtype select, .rest-addheader select {
                grid-column-start: 1;
            }

                .rest-method select + input, .rest-reqtype select + input, .rest-addheader select + input {
                    grid-column-start: 2;
                }

            .rest-body textarea {
                font-family: Consolas, monospace;
                min-height: 15em;
            }

            @supports (display: grid) {
                .rest-method select + input, .rest-reqtype select + input, .rest-addheader select + input {
                    height: 100%;
                }
            }

            .restAddParam {
                width: 170px !important
            }
        </style>
        <script type="text/javascript">
            $(document).ready(function () {
                var met = $(".rest-method select");
                var req = $(".rest-reqtype select");
                var resp = $(".rest-responsetype select");

                var checkReqType = function () {
                    var v = req.val();
                    var v2 = met.val();
                    if (v === "application/x-www-form-urlencoded" || v2 === "GET" || v2 === "DELETE") {
                        a = $(".rest-body").hide();
                    } else {
                        a = $(".rest-body").css("display", "");
                    }
                    if (v && $(".rest-reqtype").is(":visible")) {
                        b = $(".rest-reqtype select + input").hide();
                    } else {
                        $(".rest-reqtype select + input").css("display", "");
                    }
                };
                req.change(function () { checkReqType(); });

                var checkMethod = function () {
                    var v = met.val();
                    if (v === "GET" || v === "DELETE") {
                        a = $(".rest-reqtype").hide();
                    } else {
                        a = $(".rest-reqtype").css("display", "");
                    }
                    if (v) {
                        b = $(".rest-method select + input").hide();
                    } else {
                        b = $(".rest-method select + input").css("display", "");
                    }
                    checkReqType();
                };
                met.change(function () { checkMethod(); });

                var checkResponseType = function () {
                    var v = resp.val();
                    if (v) {
                        $(".attach-info").show();
                    } else {
                        $(".attach-info").hide();
                    }
                };
                resp.change(function () { checkResponseType(); });

                checkMethod();
                checkResponseType();

                var x = document.getElementById("<%=hdApiResult.ClientID%>");
                if (x && x.value) {
                    var w = window.open("OutputXmlContent.aspx?k=" + x.value, x.value, 'resizable=1,directories=0,toolbar=0,scrollbars=0,status=0,menubar=0,location=0,top=0,left=0,width=700,height=500');
                    w.focus();
                }
            });
        </script>

        <asp:HiddenField ID="hdApiResult" runat="server" />
        <div class="config-error">
            <asp:ValidationSummary runat="server" />
        </div>
        <div class="fields no-columns mod-rest-config">
            <div>
                <h4>
                    <asp:Literal ID="lblSubTitleRest" runat="server" />
                </h4>
            </div>
            <fieldset class="main">
                <legend>
                    <asp:Literal runat="server" ID="litMainInfo" Text="Informações Iniciais" /></legend>
                <label class="rext-name">
                    <asp:Literal runat="server" ID="litName" Text="Nome" />*:
                    <asp:TextBox CssClass="remain" ID="txtName" runat="server" />
                    <asp:RequiredFieldValidator runat="server" ControlToValidate="txtName" Display="None" ErrorMessage="O campo Nome é obrigatório." Text="" />
                </label>
                <label>
                    <asp:RadioButtonList ID="rblAuthType" runat="server" RepeatDirection="Horizontal" AutoPostBack="true">
                        <asp:ListItem Value="0" Selected="true"></asp:ListItem>
                        <asp:ListItem Value="1"></asp:ListItem>
                        <asp:ListItem Value="2"></asp:ListItem>
                    </asp:RadioButtonList>
                </label>
                <asp:Panel ID="pnlAuth" runat="server" Visible="false">
                    <asp:Label ID="lblAuthUser" runat="server" Style="float: left !important;" Width="60px" />
                    <asp:RequiredFieldValidator ID="rfvAuthUser" runat="server" Display="Dynamic" ControlToValidate="txtAuthUser" Text="*" />
                    <asp:TextBox ID="txtAuthUser" runat="server" MaxLength="50" ClientIDMode="Static" AutoCompleteType="None" />
                    <asp:Label ID="lblAuthPWD" runat="server" />
                    <asp:RequiredFieldValidator ID="rfvauthPWD" runat="server" Display="Dynamic" ControlToValidate="txtAuthPWD" Text="*" />
                    <asp:TextBox ID="txtAuthPWD" runat="server" MaxLength="20" ClientIDMode="Static" AutoCompleteType="None" />
                </asp:Panel>
                <asp:Panel ID="pnlCertificate" runat="server" Visible="false">
                    <asp:Label runat="server" ID="lblCertificate" />
                    <asp:DropDownList runat="server" ID="ddlCertificates" />
                    <asp:RequiredFieldValidator ID="rfvCertificate" runat="server" Display="Dynamic" ControlToValidate="ddlCertificates" Text="*" />
                </asp:Panel>
                <label class="rest-method">
                    <span>
                        <asp:Literal runat="server" ID="litMethod" Text="Método" />:</span>
                    <asp:DropDownList runat="server" ID="ddlMethod" />
                    <asp:TextBox ID="txtMethod" runat="server" />
                    <asp:CustomValidator runat="server" Display="None" ID="MethodValidation" ErrorMessage="O método de request é obrigatório." OnServerValidate="MethodValidation_ServerValidate" />
                </label>
                <label class="rest-url">
                    <asp:Label ID="lblUrlRest" runat="server" />
                    *:
                    <asp:TextBox CssClass="remain" ID="txtUrlRest" runat="server" />
                    <asp:RequiredFieldValidator runat="server" ControlToValidate="txtUrlRest" Display="None" ErrorMessage="O campo Url é obrigatório." Text="" />
                    <asp:RegularExpressionValidator runat="server" ControlToValidate="txtUrlRest" Display="None" ValidationExpression="(h|H)(t|T){2}(p|P)(s|S)?://.{3,}" ErrorMessage="O campo Url deve ser uma url absoluta, começando com http." Text="" />
                </label>
                <label class="rest-reqtype">
                    <span>
                        <asp:Literal runat="server" ID="litReqType" Text="Request Content Type" />:</span>
                    <asp:DropDownList runat="server" ID="ddlRequestContentType" />
                    <asp:TextBox ID="txtRequestContentType" runat="server" />
                    <asp:CustomValidator runat="server" Display="None" ID="ReqTypeValidation" ErrorMessage="O tipo de conteúdo do request deve ser informado quando há conteúdo." OnServerValidate="ReqTypeValidation_ServerValidate" />
                </label>
            </fieldset>


            <fieldset class="config">
                <legend>
                    <asp:Literal runat="server" ID="litParameters" Text="Informações Iniciais" /></legend>
                <label class="restAddParam">
                    <asp:Button ID="btnAdd" CausesValidation="false" CssClass="btn" runat="server" OnClick="Add_Click" />
                </label>
                <div>
                    <table class="rest-params">
                        <thead>
                            <tr>
                                <th>
                                    <asp:Literal runat="server" ID="litParameter" Text="Parâmetro" /></th>
                                <th>
                                    <asp:Literal runat="server" ID="litValue" Text="Valor Padrão" /></th>
                                <th>
                                    <asp:Literal runat="server" ID="litContext" Text="Contexto" /></th>
                                <th>
                                    <asp:Literal runat="server" ID="litTestValue" Text="Valor de Teste" /></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <asp:Repeater ID="rptItems" runat="server">
                                <ItemTemplate>
                                    <tr>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtKey" Text='<%#Eval("Key")%>' />
                                        </td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtValue" Text='<%#Eval("Value")%>' />
                                        </td>
                                        <td>
                                            <asp:DropDownList ID="lstContext" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtTest" Text='<%#Eval("TestValue")%>' />
                                        </td>
                                        <td>
                                            <asp:Button CausesValidation="false" Text="X" runat="server" ToolTip="Remover Header" CommandArgument='<%#Eval("Key")%>' CommandName="remove" />
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>
                        </tbody>
                    </table>
                </div>
            </fieldset>
            <fieldset class="config rest-body">
                <legend>
                    <asp:Literal runat="server" ID="litContent" Text="Conteúdo" /></legend>
                <label class="rest-body">
                    <span></span>
                    <asp:TextBox runat="server" ID="txtContent" TextMode="MultiLine" />
                </label>
            </fieldset>
            <wf:restapiheaders runat="server" id="restHeaders" />
            <fieldset class="result">
                <legend>
                    <asp:Literal runat="server" ID="litRetorno" Text="Retorno Esperado" />
                </legend>
                <label class="rest-responsetype">
                    <span>
                        <asp:Literal runat="server" ID="litReturnFmt" Text="Formato" />:
                    </span>
                    <asp:DropDownList runat="server" ID="ddlResultType" />
                </label>
            </fieldset>

            <asp:PlaceHolder ID="phResult" runat="server">
                <fieldset class="result">
                    <legend>
                        <asp:Literal runat="server" ID="litResult" Text="Resultado e Saídas" /></legend>
                    <wf:outputsbystatuscode runat="server" id="serviceOutputs" allowerrorattachment="true" />
                </fieldset>
            </asp:PlaceHolder>

            <label style="display: none;">
                <asp:Label ID="lblMethodsRest" runat="server" />
                <asp:DropDownList ID="lstMethodsRest" runat="server" AutoPostBack="True" />
                <asp:RequiredFieldValidator ID="rfvMethodsRest" runat="server" ControlToValidate="lstMethodsRest" Display="Dynamic" />
            </label>

            <asp:PlaceHolder ID="ParametrosSaidaRest" runat="server">
                <h4>
                    <asp:Literal ID="lblParamSaidaRest" runat="server" /></h4>
                <table>
                    <asp:Label ID="lblCamposRest" runat="server" />
                </table>
            </asp:PlaceHolder>
        </div>



        <section class="actions mod-rest-config">
            <asp:Button ID="btnTestRest" runat="server" OnClick="Test_Click" />
            <asp:Button ID="btnOKRest" runat="server" Visible="False" OnClick="Ok_Click" />
            <asp:Button ID="btnCancelRest" runat="server" CausesValidation="False" />
            <asp:Label ID="lblFormatRest" runat="server" Visible="False" />
        </section>
    </asp:PlaceHolder>
    <!------------------------------Painel WEBSERVICE--------------------------------------->
    <asp:PlaceHolder ID="pnlWEB" runat="server" Visible="false">

        <style>
            .switch {
                position: relative;
                display: inline-block;
                width: 30px;
                height: 17px;
            }

                .switch input {
                    opacity: 0;
                    width: 0;
                    height: 0;
                }

            .slider {
                position: absolute;
                cursor: pointer;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background-color: #ccc;
                -webkit-transition: .4s;
                transition: .4s;
            }

                .slider:before {
                    position: absolute;
                    content: "";
                    height: 13px;
                    width: 13px;
                    left: 2px;
                    bottom: 2px;
                    background-color: white;
                    -webkit-transition: .4s;
                    transition: .4s;
                }

            input:checked + .slider {
                background-color: #2196F3;
            }

            input:focus + .slider {
                box-shadow: 0 0 1px #2196F3;
            }

            input:checked + .slider:before {
                -webkit-transform: translateX(13px);
                -ms-transform: translateX(13px);
                transform: translateX(13px);
            }

            /* Rounded sliders */
            .slider.round {
                border-radius: 17px;
            }

                .slider.round:before {
                    border-radius: 50%;
                }

            .no-border:read-only {
                border: none !important;
            }

            table:not(.reLayoutWrapper) tbody > tr:nth-child(2n) .no-border:read-only {
                background: #ededed;
            }
        </style>

        <div class="fields no-columns">
            <div>
                <h4>
                    <asp:Literal ID="lblSubTitleWEB" runat="server" />
                </h4>
            </div>

            <fieldset id="fldAutenticacao">
                <legend>
                    <asp:Label ID="lblAutenticacaoWS" runat="server" Text="Autenticação de Usuário" />
                </legend>
                <label>
                    <asp:RadioButtonList ID="rdlTipoAutenticacao" runat="server" RepeatDirection="Horizontal" AutoPostBack="true">
                        <asp:ListItem Value="0" Selected="true"></asp:ListItem>
                        <asp:ListItem Value="1"></asp:ListItem>
                        <asp:ListItem Value="2"></asp:ListItem>
                        <asp:ListItem Value="3"></asp:ListItem>
                    </asp:RadioButtonList>
                </label>

                <asp:Panel ID="pnlAuthentication" runat="server" Visible="false">
                    <asp:Label ID="lblAutenticacaoUsuario" runat="server" Style="float: left !important;" Width="60px" />
                    <asp:RequiredFieldValidator ID="rfvUsuario" runat="server" Display="Dynamic" ControlToValidate="txtUsuario" Text="*" />
                    <asp:TextBox ID="txtUsuario" runat="server" MaxLength="50" ClientIDMode="Static" AutoCompleteType="None" />
                    <asp:Label ID="lblAutenticacaoSenha" runat="server" />
                    <asp:RequiredFieldValidator ID="rfvSenha" runat="server" Display="Dynamic" ControlToValidate="txtSenha" Text="*" />
                    <asp:TextBox ID="txtSenha" runat="server" MaxLength="20" ClientIDMode="Static" AutoCompleteType="None" />
                </asp:Panel>
            </fieldset>

            <div style="margin-top: 5px">
                <label class="switch" style="display: inline-block;">
                    <asp:CheckBox ID="chkUserAgent" runat="server" OnCheckedChanged="chkUserAgent_CheckedChanged" AutoPostBack="true" />
                    <span class="slider round"></span>
                </label>
                <asp:Label ID="lblConfigurarUserAgent" runat="server" />
                <asp:Panel ID="pnlUserAgent" runat="server" Visible="false">
                    <asp:Label ID="lblUserAgent" runat="server" />
                    <asp:TextBox ID="txtUserAgent" runat="server" MaxLength="100" />
                </asp:Panel>
            </div>

            <div>
                <asp:Label ID="lblUrlWeb" runat="server" />
                <div>
                    <asp:TextBox ID="txtUrlWeb" runat="server" Style="width: 80%; display: inline;" MaxLength="200" />
                    <asp:Button ID="btnSearchWeb" Style="width: 80px; display: inline; margin-left: 5px;" runat="server" />
                </div>
            </div>
            <label>
                <asp:Label ID="lblMethodsWeb" runat="server" />
                <asp:DropDownList ID="lstMethodsWeb" runat="server" AutoPostBack="True" />
                <asp:RequiredFieldValidator ID="rfvMethodsWeb" runat="server" ControlToValidate="lstMethodsWeb" Display="Dynamic" />
            </label>


            <asp:Panel runat="server" ID="pnlToggleNivelXml">
                <label class="switch" style="display: inline-block;">
                    <asp:CheckBox ID="chkNivelXml" runat="server" OnCheckedChanged="chkNivelXml_CheckedChanged" AutoPostBack="true" />
                    <span class="slider round"></span>
                </label>
                <asp:Label ID="lblAlterarNivelXml" runat="server" />
                <asp:Panel ID="pnlNivelXml" runat="server" Visible="False">
                    <asp:Label ID="lblNivelXml" runat="server" />
                    <asp:TextBox ID="txtNivelXml" runat="server" MaxLength="50" Text="0" />
                </asp:Panel>
            </asp:Panel>


            <asp:PlaceHolder ID="parametrosWeb1" runat="server" Visible="false">
                <h4>
                    <asp:Literal ID="lblTestParamsWeb" Text="Parâmetros" runat="server" /></h4>
                <div>
                    <asp:Repeater ID="lstParamWeb" runat="server">
                        <HeaderTemplate>
                            <table>
                                <tr class="gridCaption">
                                    <td>
                                        <asp:Label ID="lblParametros" runat="server" />
                                    </td>
                                    <td>
                                        <asp:Label ID="lblParDefValue" runat="server" />
                                    </td>
                                    <td>
                                        <asp:Label ID="lblContexto" runat="server" />
                                    </td>
                                    <td>
                                        <asp:Label ID="lblTeste" runat="server" />
                                    </td>
                                </tr>
                        </HeaderTemplate>
                        <FooterTemplate>
                            </table>
                        </FooterTemplate>
                        <ItemTemplate>
                            <tr class="gridRow">
                                <td>
                                    <asp:TextBox ID="txtParName" runat="server" Width="300px" CssClass="no-border" ReadOnly="true" />
                                    <asp:Label ID="lblpardets" runat="server" Visible="false" />
                                </td>
                                <td>
                                    <asp:TextBox ID="txtparvalue" runat="server" Text="NULL" />
                                </td>
                                <td>
                                    <asp:DropDownList ID="lstContext" runat="server" />
                                </td>
                                <td>
                                    <asp:TextBox ID="txtpartstvalue" runat="server" Text="NULL" />
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
            </asp:PlaceHolder>
            <asp:PlaceHolder ID="ParametrosSaidaWeb" runat="server">
                <h4>
                    <asp:Literal ID="lblParamSaidaWeb" runat="server" /></h4>
                <table>
                    <asp:Label ID="lblCamposWeb" runat="server" />
                </table>
            </asp:PlaceHolder>
        </div>
        <section class="actions">
            <asp:Button ID="btnTestWeb" runat="server" Visible="False" />
            <asp:Button ID="btnOkWeb" runat="server" Visible="False" />
            <asp:Button ID="btnCancelWeb" runat="server" CausesValidation="False" />
            <asp:Label ID="lblFormatWeb" runat="server" Visible="False" />
        </section>
    </asp:PlaceHolder>
    <!------------------------------Painel FORMULA--------------------------------------->
    <asp:Panel ID="pnlFormula" runat="server" Visible="false">
        <div class="fields no-columns">
            <h4>
                <asp:Literal ID="lblSubTitleFORMULA" runat="server" /></h4>
            <label>
                <asp:Label runat="server" ID="lblFormulaMetodos" />
                <asp:DropDownList runat="server" ID="ddlFormulaMetodos" AutoPostBack="true" OnSelectedIndexChanged="ddlFormulaMetodos_SelectedIndexChanged" />
            </label>
            <div>
                <asp:Label runat="server" ID="lblFormulaParams" />
                <table>
                    <asp:Repeater runat="server" ID="rptFormulaParams">
                        <HeaderTemplate>
                            <tr>
                                <td>
                                    <asp:Label runat="server" ID="lblParametros" />
                                </td>
                                <td>
                                    <asp:Label runat="server" ID="lblTipoParam" />
                                </td>
                                <td>
                                    <asp:Label runat="server" ID="lblParDefValue" />
                                </td>
                                <td>
                                    <asp:Label runat="server" ID="lblContexto" />
                                </td>
                                <td>
                                    <asp:Label runat="server" ID="lblTeste" />
                                </td>
                            </tr>
                        </HeaderTemplate>
                        <ItemTemplate>
                            <tr>
                                <td>
                                    <asp:Label runat="server" ID="lblParam" />
                                </td>
                                <td>
                                    <asp:Label runat="server" ID="lblParamType" />
                                </td>
                                <td>
                                    <asp:TextBox runat="server" ID="txtValue" />
                                </td>
                                <td>
                                    <asp:DropDownList runat="server" ID="ddlValue" />
                                </td>
                                <td>
                                    <asp:TextBox runat="server" ID="txtValueTest" />
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                    <tr id="ParametrosSaidaFormula1" runat="server">
                        <td>
                            <h4>
                                <asp:Literal ID="lblParamSaidaFormula" runat="server" /></h4>
                        </td>
                    </tr>
                    <tr id="ParametrosSaidaFormula2" runat="server">
                        <td>
                            <asp:Label ID="lblCamposFormula" runat="server" CssClass="destaque" />
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <section class="actions">
            <asp:Button runat="server" ID="btnFormulaOK" Enabled="false" OnClick="btnFormulaOK_Click" />
            <asp:Button runat="server" ID="btnFormulaTest" Enabled="false" OnClick="btnFormulaTest_Click" />
            <asp:Button runat="server" ID="btnFormulaCancel" OnClick="btnFormulaCancel_Click" />
            <asp:Label ID="lblFormatFormula" runat="server" Visible="False" />
        </section>
    </asp:Panel>
</asp:Content>


