﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="RestApiHeaders.ascx.vb" Inherits="WebFoundations.WFForms.UI.RestApiHeaders" %>
<fieldset class="config rest-headers">
    <legend>Headers</legend>
    <label class="rest-addheader">
        <span>Header:</span>
        <asp:DropDownList runat="server" ID="ddlKeys">
            <asp:ListItem Value="Accept-Language" Text="Accept-Language" />
            <asp:ListItem Value="Authorization" Text="Authorization" title="Authentication credentials for HTTP authentication" />
            <asp:ListItem Value="Cache-Control" Text="Cache-Control" title="Used to specify directives that MUST be obeyed by all caching mechanisms along the request/response chain" />
            <asp:ListItem Value="From" Text="From" title="The email address of the user making the request" />
            <asp:ListItem Value="Origin" Text="Origin" title="Initiates a request for cross-origin resource sharing (asks server for an 'Access-Control-Allow-Origin' response header) ." />
            <asp:ListItem Value="Pragma" Text="Pragma" title="Implementation-specific headers that may have various effects anywhere along the request-response chain." />
            <asp:ListItem Value="Proxy-Authorization" Text="Proxy-Authorization" title="Authorization credentials for connecting to a proxy." />
            <asp:ListItem Value="Range" Text="Range" title="Request only part of an entity. Bytes are numbered from 0." />
            <asp:ListItem Value="User-Agent" Text="User-Agent" title="The user agent string of the user agent" />
            <asp:ListItem Value="X-HTTP-Method-Override" Text="X-HTTP-Method-Override" title="HTTP method override used by some web apis when the usage of the desired method is not allowed by the browser or proxies." />
            <asp:ListItem Text="CUSTOM" Value="" title="adiciona um cabeçalho personalizado que não esteja nesta lista" />
        </asp:DropDownList>
        <asp:Button CssClass="btn" ID="btnAdd" runat="server" Text="Adicionar" ToolTip="adicionar header" OnClick="Add_Click" CausesValidation="false" /></label>
    <div>
        <table class="rest-params">
            <thead>
                <tr>
                    <th>
                        <asp:Literal runat="server" ID="litName" Text="Informações Iniciais" /></th>
                    <th>
                        <asp:Literal runat="server" ID="litValue" Text="Informações Iniciais" /></th>
                    <th>
                        <asp:Literal runat="server" ID="litTestValue" Text="Informações Iniciais" /></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <asp:Repeater ID="rptItems" runat="server">
                    <ItemTemplate>
                        <tr>
                            <td>
                                <asp:TextBox runat="server" ID="txtKey" Text='<%#Eval("Key")%>' /></td>
                            <td>
                                <asp:TextBox runat="server" ID="txtValue" Text='<%#Eval("Value")%>' /></td>
                            <td>
                                <asp:TextBox runat="server" ID="txtTest" Text='<%#Eval("TestValue")%>' /></td>
                            <td>
                                <asp:Button CausesValidation="false" Text="X" runat="server" ToolTip="Remover Header" CommandArgument='<%#Eval("Key")%>' CommandName="remove" /></td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </tbody>
        </table>
    </div>
</fieldset>
