<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Messages.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Messages" %>

<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="cc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = 0;
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = 0;
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <table>
        <tr>
            <td>
                <asp:Label ID="lblcategory" runat="server" />&nbsp;</td>
            <td colspan="3" width="250px">
                <asp:DropDownList ID="lstcategory" runat="server" Width="250px"></asp:DropDownList></td>
            <td rowspan="2" width="80px">
                <asp:Button ID="btnbuscar" runat="server" CssClass="btnEnviar" /></td>
        </tr>
        <tr>
            <td align="right">
                <asp:Label ID="lbldatefrom" runat="server" />&nbsp;</td>
            <td align="left">
                <cc1:DatePicker ID="datefrom" width="80px" runat="server"></cc1:DatePicker></td>
            <td align="right" width="27px">
                <asp:Label ID="lbldateto" runat="server" />&nbsp;</td>
            <td align="left">
                <cc1:DatePicker ID="dateto" width="80px" runat="server"></cc1:DatePicker></td>
            <td></td>
        </tr>
    </table>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul>
        <li><asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" /></li>
        <li><asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
        <li><asp:LinkButton ID="lnkExport" runat="server" CssClass="export" /></li>
    </ul>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="MessageODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.Message"
        MaximumRowsParameterName="" StartRowIndexParameterName="">
        <SelectParameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$lstcategory" Name="Category" PropertyName="SelectedValue" Type="String" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$datefrom" Name="FromDate" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$dateto" Name="ToDate" PropertyName="Text" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    
    <asp:UpdateProgress runat="server" AssociatedUpdatePanelID="updateform">
        <ProgressTemplate>
            <div class="up-loading"></div>
        </ProgressTemplate>
    </asp:UpdateProgress>
    
    <asp:UpdatePanel ID="updateform" runat="server" UpdateMode="Always">
        <ContentTemplate>
            <telerik:RadGrid ID="grdMessage" runat="server"
                AutoGenerateColumns="false" DataSourceID="MessageODS" AllowSorting="False"
                GridLines="Horizontal" PageSize="8">
                <MasterTableView DataSourceID="MessageODS">
                    <Columns>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" HeaderStyle-Width="40px" UniqueName="Id" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Category" HeaderText="Category" HeaderStyle-Width="200px" UniqueName="Category" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="PublishDate" HeaderText="PublishDate" HeaderStyle-Width="110px" UniqueName="PublishDate" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Message" HeaderText="Message" HeaderStyle-Width="500px" UniqueName="Message" ItemStyle-HorizontalAlign="center" />
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
                    AllowColumnHide="false"
                    Selecting-AllowRowSelect="true" Scrolling-AllowScroll="true"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Messages" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server" />
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>

