<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="LogsAudit.aspx.vb" Inherits="WebFoundations.WFPortal.UI.LogsAudit"
    Title="Untitled Page" %>

<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="cc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <div>
            <asp:Label ID="lblcategory" runat="server" />
            <asp:DropDownList ID="lstcategory" runat="server" />
        </div>
        <div>
            <asp:Label ID="lbldatefrom" runat="server" />
            <cc1:datepicker id="datefrom" disablelowervaluesfor="dateto" width="115px" runat="server" />
        </div>
        <div>
            <asp:Label ID="lbldateto" runat="server" />
            <cc1:datepicker id="dateto" runat="server" width="115px" />
        </div>
    </div>
    <asp:Button ID="btnbuscar" runat="server" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" /></li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
        <li>
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" /></li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="LogAuditODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.LogsAudit"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex">
        <SelectParameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$lstcategory" Name="Category" PropertyName="SelectedValue" Type="String" />
            <asp:Parameter Name="LogType" Type="Int32" DefaultValue="0" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$datefrom" Name="FromDate" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$dateto" Name="ToDate" PropertyName="Text" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
        <ProgressTemplate>
            <div class="up-loading"></div>
        </ProgressTemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:radgrid id="grdLog" runat="server" cssclass="zuri-logs horizontal-scroll"
                autogeneratecolumns="false"
                datasourceid="LogAuditODS" allowsorting="true" allowcustompaging="true"
                gridlines="None" allowpaging="True" pagesize="13">
                <mastertableview datasourceid="LogAuditODS">
                    <columns>
                        <telerik:gridboundcolumn datafield="EventCategory" headertext="EventCategory" uniquename="EventCategory" />
                        <telerik:gridboundcolumn datafield="EventTimeStamp" headertext="EventTimeStamp" uniquename="EventTimeStamp" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="EventMessage" headertext="EventMessage" uniquename="EventMessage" itemstyle-cssclass="log-message" />
                        <telerik:gridboundcolumn datafield="UserName" headertext="UserName" uniquename="UserName" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="UserAddress" headertext="UserAddress" uniquename="UserAddress" itemstyle-horizontalalign="center" />
                    </columns>
                </mastertableview>
                <clientsettings allowcolumnsreorder="false" allowdragtogroup="false"
                    allowcolumnhide="false"
                    selecting-allowrowselect="true" scrolling-allowscroll="False"
                    scrolling-usestaticheaders="true">
                </clientsettings>
                <pagerstyle mode="NextPrevAndNumeric"></pagerstyle>
                <exportsettings exportonlydata="True" filename="LogsAudit" ignorepaging="True" openinnewwindow="True" />
            </telerik:radgrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <telerik:radgrid id="printgrid" runat="server"
                autogeneratecolumns="false"
                datasourceid="" allowsorting="false"
                gridlines="None" allowpaging="False" enableviewstate="False">
                <mastertableview>
                    <expandcollapsecolumn visible="False">
                        <headerstyle />
                    </expandcollapsecolumn>
                    <rowindicatorcolumn visible="False">
                        <headerstyle />
                    </rowindicatorcolumn>
                    <columns>
                        <telerik:gridboundcolumn datafield="Id" headertext="Id" uniquename="Id">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="EventCategory" headertext="EventCategory" uniquename="EventCategory">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="EventTimeStamp" headertext="EventTimeStamp" uniquename="EventTimeStamp">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="EventMessage" headertext="EventMessage" uniquename="EventMessage">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="UserName" headertext="UserName" uniquename="UserName">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="EventCode" headertext="EventCode" uniquename="EventCode">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="EventType" headertext="EventType" uniquename="EventType">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="Url" headertext="Url" uniquename="Url">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="UserAddress" headertext="UserAddress" uniquename="UserAddress">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                        <telerik:gridboundcolumn datafield="UserAuthType" headertext="UserAuthType" uniquename="UserAuthType">
                            <itemstyle horizontalalign="Center" />
                            <headerstyle horizontalalign="Center" />
                        </telerik:gridboundcolumn>
                    </columns>
                </mastertableview>
                <clientsettings allowcolumnsreorder="True">
                    <selecting allowrowselect="True" />
                    <scrolling allowscroll="True" usestaticheaders="True" />
                </clientsettings>
                <exportsettings exportonlydata="True" filename="LogsAudit" ignorepaging="False" openinnewwindow="True" />
            </telerik:radgrid>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>
    </div>
    <wff:windowmanager id="EditWindow" runat="server">
        <windows>
            <telerik:radwindow id="EditDialog" runat="server" height="340px" width="450px" reloadonshow="true" modal="true" />
        </windows>
    </wff:windowmanager>
</asp:Content>
