<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Menus.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Menus1" %>

<%@ Register Assembly="System.Web.DataVisualization, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35" Namespace="System.Web.UI.DataVisualization.Charting" TagPrefix="asp" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="cc1" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
	<script type="text/javascript">
		function postBackHiddenField(hiddenFieldID) {
			var hiddenField = $get(hiddenFieldID);
			if (hiddenField) {
				hiddenField.value = (new Date()).getTime();
				__doPostBack(hiddenFieldID, '');
			}
		}
	</script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
	<div class="fields">
		<div>
			<asp:Label ID="lbldatefrom" runat="server" />
			<cc1:DatePicker ID="datefrom" Width="115px" DisableLowerValuesFor="dateto" runat="server" />
			
		</div>
        <div>
			<asp:Label ID="lbldateto" runat="server" />
			<cc1:DatePicker ID="dateto" Width="115px" runat="server" />
        </div>
	</div>
	<asp:Button ID="btnbuscar" runat="server" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
	<ul class="list-of-actions">
		<li>
			<asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
		<li>
			<asp:LinkButton ID="lnkExport" runat="server" CssClass="export" /></li>
	</ul>
	<script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
	<asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
	<div>
		<asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
			<ProgressTemplate>
				<div class="up-loading"></div>
			</ProgressTemplate>
		</asp:UpdateProgress>
		<asp:UpdatePanel ID="updateform" runat="server">
			<ContentTemplate>
				<center>
					<telerik:RadHtmlChart ID="chtAccess" Visible="False" runat="server" RenderMode="Auto" Height="500" Width="800">
						<ChartTitle>
							<Appearance Position="Top" />
						</ChartTitle>
						<Legend>
							<Appearance Visible="False" Position="Top"/>
						</Legend>
						<PlotArea>
							<Series>
								<telerik:ColumnSeries DataFieldY="HITCOUNT" VisibleInLegend="false">
								<LabelsAppearance Visible="false"/>
								<Appearance>
									<FillStyle BackgroundColor="#12364A" />
								</Appearance>
								<TooltipsAppearance Color="White"/>
								</telerik:ColumnSeries>                                
							</Series>

							<XAxis DataLabelsField="TRK_C_MENUPATH"> 
								<MinorGridLines Visible="false" />
								<MajorGridLines Visible="false" />
							</XAxis>
							
							<YAxis>
								<MinorGridLines Visible="false" />
							</YAxis>
						</PlotArea>
					</telerik:RadHtmlChart>
				</center>
				<br>
				<telerik:RadGrid ID="grdLog" runat="server" AutoGenerateColumns="False" GridLines="None">
					<ExportSettings ExportOnlyData="True" FileName="Logs" IgnorePaging="True" OpenInNewWindow="True" />
					<MasterTableView>
						<Columns>
							<telerik:GridBoundColumn ItemStyle-Width="50%" ItemStyle-HorizontalAlign="Center" DataField="TRK_C_MENUPATH" UniqueName="ItemName" />
							<telerik:GridBoundColumn ItemStyle-Width="50%" ItemStyle-HorizontalAlign="Center" DataField="HITCOUNT" UniqueName="HitCount" />
						</Columns>
					</MasterTableView>
					<ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
						AllowColumnHide="false"
						Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false"
						Scrolling-UseStaticHeaders="true">
					</ClientSettings>
				</telerik:RadGrid>
			</ContentTemplate>
			<Triggers>
				<asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
				<asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
			</Triggers>
		</asp:UpdatePanel>
	</div>
</asp:Content>
