<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Users.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Users" %>

<%@ Register Src="../../WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = 0;
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = 0;
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" />
        </li>
        <li>
            <asp:HyperLink ID="lnkedit" runat="server" CssClass="edit" />
        </li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" />
        </li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" />
        </li>
        <li>
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" />
        </li>
        <li>
            <asp:HyperLink ID="lnkClone" runat="server" CssClass="copy" />
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <asp:PlaceHolder ID="phportal" runat="server">
            <uc1:wfpagepicker id="portalpicker" runat="server" addselect="false" adminmode="true" class="filterfield"
                autoselectlast="true" showarea="false" showpage="false" nolabels="false" />
        </asp:PlaceHolder>
        <div>
            <asp:Label ID="lblname" runat="server" />
            <asp:TextBox ID="txtusername" runat="server" ValidationGroup="SEARCH" />
        </div>
        <div>
            <asp:Label ID="lblgroup" runat="server" />
            <wff:rolepicker id="rolepicker" runat="server" />
        </div>
        <div>
            <asp:Label ID="lblprofile" runat="server" />
            <wff:rolegrouppicker id="rolegrouppicker" runat="server" />
        </div>
        <div>
            <asp:Label ID="lblStatus" runat="server" />
            <asp:DropDownList ID="ddlStatus" runat="server" />
        </div>
    </div>
    <asp:Button ID="btnbuscar" runat="server" ValidationGroup="SEARCH" CssClass="search" />
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="UserODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.User"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex">
        <SelectParameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$portalpicker" Name="PortalId" PropertyName="CurrentPortal" Type="Int32" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$txtusername" Name="UserName" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$rolepicker" Name="UserRole" PropertyName="SelectedValue" Type="Int32" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$rolegrouppicker" Name="UserRoleGroup" PropertyName="SelectedValue" Type="Int32" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$ddlStatus" Name="UserStatus" PropertyName="SelectedValue" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <div class="posLoading">
        <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
            <ProgressTemplate>
                <div class="up-loading"></div>
            </ProgressTemplate>
        </asp:UpdateProgress>
    </div>
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:radgrid id="grdUser" runat="server" autogeneratecolumns="false" allowsorting="True" gridlines="None" allowpaging="True" pagesize="15">
                <mastertableview>
                    <columns>
                        <telerik:gridboundcolumn datafield="Id" headertext="Id" uniquename="Id" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="Guid" headertext="Guid" uniquename="Guid" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="FullName" headertext="FullName" uniquename="FullName" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="Email" headertext="Email" uniquename="Email" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="Login" headertext="Login" uniquename="Login" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="WinLogon" headertext="WinLogon" uniquename="WinLogon" itemstyle-horizontalalign="center" />
                    </columns>
                </mastertableview>
                <clientsettings allowcolumnsreorder="false" allowdragtogroup="false"
                    allowcolumnhide="false"
                    selecting-allowrowselect="true" scrolling-allowscroll="false"
                    scrolling-usestaticheaders="true">
                </clientsettings>
                <exportsettings exportonlydata="True" filename="Users" ignorepaging="True" openinnewwindow="True" />
            </telerik:radgrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <asp:HiddenField ID="SelectedPortalId" runat="server"></asp:HiddenField>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>
    <wff:windowmanager id="EditWindow" runat="server">
        <windows>
            <telerik:radwindow id="EditDialog" runat="server" height="760px" width="900px" reloadonshow="true" modal="true" />
        </windows>
    </wff:windowmanager>
</asp:Content>

