<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="UserEdit.aspx.vb" Inherits="WebFoundations.WFPortal.UI.UserEdit" %>

<%@ Register Src="../../WFControls/WFAccessList.ascx" TagName="AccessList" TagPrefix="uc1" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="cc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<asp:Content runat="server" ContentPlaceHolderID="TagHead">
    <style type="text/css">
        label.subportal {
            margin-bottom: .5em;
        }

        label.photo div {
            display: inline-block;
        }

        label.photo input {
            display: block;
        }

        img.photo {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: solid 1px #AAA !important;
            margin-right: 1em;
        }
    </style>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <h1><%=Page.Title%></h1>
    <telerik:radtabstrip id="tabusers" runat="server" multipageid="userpages" selectedindex="0">
        <tabs>
            <telerik:radtab id="tbcadastro" runat="server" pageviewid="userinfo" text="Cadastro" />
            <telerik:radtab id="tbmember" runat="server" pageviewid="usermembership" text="Membership" enabled="false" />
            <telerik:radtab id="tbprofile" runat="server" pageviewid="userprofile" text="Profile" enabled="false" visible="false" />
        </tabs>
    </telerik:radtabstrip>
    <telerik:radmultipage id="userpages" runat="server" selectedindex="0">
        <telerik:radpageview id="userinfo" runat="server">
            <div class="fields">
                <label class="subportal">
                    <asp:Label ID="lblportaltitle" runat="server" style="display: inline-block; width: auto;" />
                    :
                    <asp:Label ID="lblportal" runat="server" style="display: inline-block; width: auto;" />
                </label>
                <label class="photo">
                    <asp:Label ID="lblimage1" runat="server" />
                    <asp:Image runat="server" ID="imgPhoto" CssClass="photo" Visible="false" />
                    <div>
                        <cc1:imageupload id="ImageUpload1" runat="server" maxfilesize="15000" />
                        <asp:ImageButton ID="btnRemoveImage1" Visible="false" ImageUrl="/wfresources/common/images/icons/delete.png" runat="server" />
                    </div>
                </label>
                <label>
                    <asp:Label ID="lblname" runat="server" />
                    <asp:TextBox ID="txtname" runat="server" MaxLength="200" />
                    <asp:RequiredFieldValidator ID="reqname" Display="Dynamic" runat="server" ControlToValidate="txtname" />
                </label>
                <label>
                    <asp:Label ID="lblemail" runat="server" />
                    <asp:TextBox ID="txtemail" runat="server" MaxLength="250" />
                    <asp:RequiredFieldValidator ID="reqemail" Display="Dynamic" runat="server" ControlToValidate="txtemail" />
                    <asp:RegularExpressionValidator ID="vlemail" runat="server" ControlToValidate="txtemail"
                        Display="Dynamic" ValidationExpression="^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" />
                </label>
                <label>
                    <asp:Label ID="lbllogin" runat="server" />
                    <asp:TextBox ID="txtlogin" runat="server" MaxLength="120" />
                    <asp:RegularExpressionValidator ID="vlLogin" runat="server" ControlToValidate="txtlogin"
                        Display="Dynamic" ValidationExpression="^[A-Za-z0-9\\\@\._-]{3,}$" />
                </label>
                <label>
                    <asp:Label ID="lblwinlogon" runat="server" />
                    <asp:TextBox ID="txtwinlogon" runat="server" MaxLength="120" />
                    <asp:RegularExpressionValidator ID="vlwinlogon" runat="server" ControlToValidate="txtwinlogon"
                        Display="Dynamic" ValidationExpression="^[A-Za-z0-9\\\@\._-]{7,}$" />
                </label>
                <asp:UpdatePanel ID="pnlPassword" runat="server">
                    <contenttemplate>
                        <label>
                            <asp:CheckBox ID="chkPWD" runat="server" AutoPostBack="true" CssClass="checkbox" />
                        </label>
                        <asp:PlaceHolder ID="phPWD" runat="server">
                            <label>
                                <asp:Label ID="lblpwd" runat="server" />
                                <asp:TextBox ID="txtpwd" runat="server" MaxLength="120" TextMode="Password" />
                                <asp:CompareValidator ID="vlpwdconf2" runat="server" ControlToCompare="txtpwdconf"
                                    ControlToValidate="txtpwd" Display="Dynamic" />
                            </label>
                            <label>
                                <asp:Label ID="lblpwdconf" runat="server" />
                                <asp:TextBox ID="txtpwdconf" runat="server" MaxLength="120" TextMode="Password" />
                                <asp:CompareValidator ID="vlpwdconf" runat="server" ControlToValidate="txtpwdconf"
                                    Display="Dynamic" ControlToCompare="txtpwd" />
                            </label>
                        </asp:PlaceHolder>
                    </contenttemplate>
                </asp:UpdatePanel>
                <label>
                    <asp:Label ID="lblbirthdate" runat="server" />
                    <cc1:datepicker id="txtbirthdate" onerrorreturnblank="false" runat="server" maxtoday="True" />
                </label>
                <label>
                    <asp:Label ID="lblcompany" runat="server" />
                    <asp:TextBox ID="txtcompany" runat="server" MaxLength="80" />
                </label>
                <label>
                    <asp:Label ID="lbllocation" runat="server" />
                    <asp:DropDownList ID="lstlocation" runat="server" />
                </label>
                <label id="image2area" runat="server" visible="false">
                    <asp:Label ID="lblimage2" runat="server" />
                    <asp:HyperLink ID="lnkimage2" Visible="false" runat="server" Target="_blank" />
                    <cc1:imageupload id="ImageUpload2" runat="server" destinationpath="" maxfilesize="15000" thumbpath="" />
                    <asp:ImageButton ID="btnRemoveImage2" Visible="false" ImageUrl="/wfresources/common/images/icons/delete.png" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblaccess" runat="server" />
                    <uc1:accesslist id="useraccess" enableuser="false" allowcustom="false" disableitems="-7;-6;-5;-4;-3;-2" runat="server" />
                </label>
            </div>
        </telerik:radpageview>
        <telerik:radpageview id="usermembership" runat="server">
            <div class="fields">
                <label>
                    <asp:CheckBox ID="chkapproved" Enabled="false" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:CheckBox ID="chklocked" Enabled="false" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:CheckBox ID="chkonline" Enabled="false" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:Label ID="lblcreatedtit" runat="server" />
                    <asp:Label ID="lblcreated" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lbllastlogintit" runat="server" />
                    <asp:Label ID="lbllastlogin" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lbllastactivitytit" runat="server" />
                    <asp:Label ID="lbllastactivity" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lbllastlockedouttit" runat="server" />
                    <asp:Label ID="lbllastlockedout" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lbllastpwdchangetit" runat="server" />
                    <asp:Label ID="lbllastpwdchange" runat="server" />
                </label>
                <label>
                    <asp:Button ID="btnunlock" runat="server" CssClass="button" />
                    <asp:Button ID="btnapprove" runat="server" CssClass="button" />
                </label>
            </div>
            <div id="k" runat="server"></div>
        </telerik:radpageview>
        <telerik:radpageview id="userprofile" runat="server" width="100%" visible="false">
            <asp:PlaceHolder ID="phprofile" runat="server"></asp:PlaceHolder>
        </telerik:radpageview>
    </telerik:radmultipage>
    <section class="actions">
        <asp:Button ID="btnok" runat="server" CssClass="button" />
    </section>
</asp:Content>
