<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="RoleGroups.aspx.vb" Inherits="WebFoundations.WFPortal.UI.RoleGroups"
    Title="Untitled Page" %>

<%@ Register Src="../../WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" />
        </li>
        <li>
            <asp:HyperLink ID="lnkedit" runat="server" CssClass="edit" />
        </li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" />
        </li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" />
        </li>
        <li>
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" />
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <div>
            <asp:Label ID="lblname" runat="server" />
            <asp:TextBox ID="txtname" runat="server" ValidationGroup="SEARCH" />
        </div>
        <uc1:WFPagePicker ID="portalpicker" runat="server" AddSelect="false" AdminMode="true" AutoSelectLast="true" ShowArea="false" ShowPage="false" />
    </div>
    <asp:Button ID="btnbuscar" runat="server" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="RoleGroupODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.RoleGroup"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex">
        <SelectParameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$txtname" Name="Name" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$portalpicker" Name="PortalId" PropertyName="CurrentPortal" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
        <ProgressTemplate>
            <div class="up-loading"></div>
        </ProgressTemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:RadGrid ID="grdRoleGroup" runat="server" AutoGenerateColumns="false"
                DataSourceID="RolegroupODS" AllowSorting="True" GridLines="None" AllowPaging="True" PageSize="15">
                <MasterTableView DataSourceID="RoleGroupODS">
                    <Columns>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Guid" HeaderText="Nome" UniqueName="Guid" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Name" HeaderText="Nome" UniqueName="Name" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Enabled" HeaderText="Folder" UniqueName="Enabled" ItemStyle-HorizontalAlign="center" />
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
                    AllowColumnHide="false"
                    Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="RoleGroups" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <asp:HiddenField ID="SelectedPortalId" runat="server"></asp:HiddenField>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>
    <wff:WindowManager ID="EditWindow" runat="server">
        <Windows>
            <telerik:RadWindow ID="EditDialog" runat="server" Height="600px" Width="450px" ReloadOnShow="true" Modal="true" />
        </Windows>
    </wff:WindowManager>
</asp:Content>

