<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Locations.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Location" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';
        function ShowNewForm() {
            window.radopen("LocationEdit.aspx", "EditDialog");
        }
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" /></li>
        <li>
            <asp:HyperLink ID="lnkedit" runat="server" CssClass="edit" /></li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" /></li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
        <li>
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" /></li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="LocationODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.Location"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex"></asp:ObjectDataSource>

    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
        <ProgressTemplate>

            <div class="up-loading"></div>

        </ProgressTemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server" UpdateMode="Always">
        <ContentTemplate>
            <telerik:RadGrid ID="grdLocation" runat="server"
                AutoGenerateColumns="false" DataSourceID="LocationODS" AllowSorting="True"
                GridLines="None" AllowPaging="True" PageSize="15">
                <MasterTableView DataSourceID="LocationODS">
                    <Columns>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Name" HeaderText="Nome" UniqueName="Name" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="TimeZone" HeaderText="TimeZone" UniqueName="TimeZone" ItemStyle-HorizontalAlign="center" />
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
                    AllowColumnHide="false"
                    Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Locations" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
        </ContentTemplate>
    </asp:UpdatePanel>
    <wff:WindowManager ID="EditWindow" runat="server">
        <Windows>
            <telerik:RadWindow ID="EditDialog" runat="server" Height="300px" Width="450px" ReloadOnShow="true" Modal="true" />
        </Windows>
    </wff:WindowManager>
</asp:Content>

