<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Areas.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Areas"
    Title="Untitled Page" %>

<%@ Register Src="../../WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" />
        </li>
        <li>
            <asp:HyperLink ID="lnkedit" runat="server" CssClass="edit" />
        </li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" />
        </li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" />
        </li>
        <li>
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" />
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:wfpagepicker id="portalpicker" runat="server" addselect="false" adminmode="true" autoselectlast="true" showarea="false" showpage="false" />
    </div>
    <asp:Button ID="btnbuscar" runat="server" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="AreaODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.Area"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex">
        <selectparameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$portalpicker" Name="PortalId" PropertyName="CurrentPortal" Type="Int32" />
        </selectparameters>
    </asp:ObjectDataSource>
    <script language="javascript">
        var MySelectedItem = '';
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
    <asp:UpdateProgress runat="server" AssociatedUpdatePanelID="updateform">
        <progresstemplate>
            <div class="up-loading"></div>
        </progresstemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server">
        <contenttemplate>
            <telerik:radgrid id="grdArea" runat="server"
                autogeneratecolumns="false"
                datasourceid="AreaODS" allowsorting="True"
                gridlines="None" allowpaging="True"
                pagesize="15">
                <mastertableview datasourceid="AreaODS">
                    <columns>
                        <telerik:gridboundcolumn datafield="Id" headertext="Id" uniquename="Id" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="Name" headertext="Nome" uniquename="Name" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="Folder" headertext="Folder" uniquename="Folder" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="templateFile" headertext="templateFile" uniquename="templateFile" itemstyle-horizontalalign="center" />
                    </columns>
                </mastertableview>
                <clientsettings allowcolumnsreorder="false" allowdragtogroup="false"
                    allowcolumnhide="false"
                    selecting-allowrowselect="true" scrolling-allowscroll="false"
                    scrolling-usestaticheaders="true">
                </clientsettings>
                <exportsettings exportonlydata="True" filename="Areas" ignorepaging="True" openinnewwindow="True" />
            </telerik:radgrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <asp:HiddenField ID="SelectedPortalId" runat="server"></asp:HiddenField>
        </contenttemplate>
        <triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </triggers>
    </asp:UpdatePanel>
    <wff:windowmanager id="EditWindow" runat="server">
        <windows>
            <telerik:radwindow id="EditDialog" runat="server" height="420px" width="900px" reloadonshow="true" modal="true" />
        </windows>
    </wff:windowmanager>
</asp:Content>

