﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="ThemeSettings.aspx.vb" Inherits="WebFoundations.WFPortal.UI.ThemeSettings" Title="Configuração de Tema" MaintainScrollPositionOnPostback="true" ValidateRequest="false" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="WFF" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style>
        .logo ul {
            display: flex;
            flex-wrap: wrap;
            padding: 0;
            margin: 8px -8px;
            list-style: none;
        }

        .logo ul li {
            position: relative;
            margin: 8px;
            width: calc(100% / 6);
        }

        .logo ul li div {
            padding: 8px 24px;
            border: 1px solid #eee;
            border-radius: 4px;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100%;
            justify-content: space-between;
        }

        .logo ul li div span {
            color: #286C83;
            font-size: 16px;
            text-align: center;
            white-space: nowrap;
            max-width: 100%;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .logo li img {
            max-height: 50px;
            background-color: transparent !important;
            margin: 8px 0;
            display: block;
        }

        .logo label div {
            border: solid 2px #ccc;
        }

        .logo li label {
            cursor: pointer;
        }

        .logo li input[type=radio] {
            display: none;
        }

        .logo li input:checked + div {
            border-color: #00abf8;
        }

        .logo li > a.delete {
            position: absolute;
            top: 8px;
            right: 8px;
        }

        .logo li > a.delete svg {
            width: 16px;
            height: 16px;
            stroke: #286C83;
        }

        .logo li a.delete[class$=delete] {
            display: none;
        }

        .wfcustom-editor textarea {
            width: 100%;
            height: 20em;
        }

        section.config {
            -moz-column-gap: 2em;
            -webkit-column-gap: 2em;
            column-gap: 2em;
            -moz-column-width: 35em;
            -webkit-column-width: 35em;
            column-width: 35em;
            -moz-column-rule: dashed 1px #ccc;
            -webkit-column-rule: dashed 1px #ccc;
            column-rule: dashed 1px #ccc;
            margin: 0 0 1em 0;
        }

        .success, .error {
            padding: .2em .5em;
            color: #fff;
            margin: .5em 0;
            display: block;
        }

        .success {
            background-color: olivedrab;
        }

        .error {
            background-color: firebrick;
        }
    </style>

    <style type="text/css">
        .theme-settings {
            position: relative;
        }

        menu.tabs {
            white-space: nowrap;
            padding: 0;
        }

        menu.tabs li {
            display: inline-block;
            list-style: none;
        }

        menu.tabs li > input {
            display: none;
        }

        menu.tabs li > section {
            position: absolute;
        }

        menu.tabs li > input:checked + label {
            color: #fff;
            background-color: #12364a;
        }

        .config-area {
            min-height: calc(100vh - 300px);
        }
    </style>

    <script type="text/javascript">
        $(document).ready(function () {
            function selectTheme(selector) {
                try {
                    if (selector && selector.options) {
                        var o = selector.options[selector.selectedIndex];
                        if (o) {
                            showColorPicker(o);
                            $(selector).attr("style", previewColor(o));
                        }
                    }
                } catch (error) { }
            }


            function showColorPicker(o) {
                var cp = $(".custom-theme-picker");
                if (o.value.indexOf("custom") === 0) {
                    cp.show();
                } else {
                    cp.hide();
                }
            }

            var setMobileStyle = function (mobstyle) {
                var styles = document.getElementById("mobile-style");
                if (!styles) {
                    styles = document.createElement("style");
                    styles.id = "mobile-style";
                    document.body.appendChild(styles);
                }
                styles.innerHTML = mobstyle;
            }

            $(".theme-selector select").change(function () { selectTheme(this); });
            selectTheme($(".theme-selector select")[0]);

            try {
                if (window.addEventListener && __doPostBack) {
                    window.addEventListener("keydown", function (ev) {
                        var k = ev.keyCode
                        if (ev.ctrlKey && k == 83 && ev.target instanceof HTMLTextAreaElement) {
                            //Ctrl + S para salvar as configurações se estiver com foco no editor CSS.
                            try {
                                ev.stopPropagation();
                                ev.preventDefault();
                                ev.stopImmediatePropagation();
                            } catch (e2) { }
                            __doPostBack('<%=btnok.UniqueID%>', '');
                            return false;
                        }
                    }, true);
                }
            } catch (error) { }
        });

        function previewColor(o) {
            var p = o.parentElement;
            o = $(o);
            var s = o.attr("style");
            try {
                $(".logo.zuri-logo li img").attr("style", s);
                if (p) { $(p).attr("style", s); }
            } catch (error2) { }
            return s;
        }

        function customPicker(sender) {
            var o = $('.theme-selector select option[value^="custom"]')[0]
            sender.add_colorChange(function (sender) {
                var selected = sender.get_selectedColor();
                o.style.backgroundColor = selected;
                previewColor(o);
            })
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <telerik:RadTabStrip runat="server" ID="tsTabs" MultiPageID="mpPages" SelectedIndex="0">
        <Tabs>
            <telerik:RadTab runat="server" id="tabModel" PageViewID="pvModel" Text="Modelo" />
            <telerik:RadTab runat="server" id="tabCSS" PageViewID="pvCSS" Text="CSS" />
        </Tabs>
    </telerik:RadTabStrip>
    <telerik:RadMultiPage runat="server" ID="mpPages" CssClass="config-area" SelectedIndex="0">
        <telerik:RadPageView runat="server" ID="pvModel" Selected="true">
            <fieldset class="config">
                <legend>
                    <asp:Literal runat="server" ID="litModel" Text="Modelo" /></legend>
                <label class="config">
                    <asp:Label ID="lblsitetitle" runat="server" Text="Título do site" />
                    <asp:TextBox ID="txttitle" runat="server" />
                </label>

                <label class="config">
                    <asp:Label ID="lblcontainer" runat="server" Text="Container Padrão" />
                    <asp:DropDownList ID="lstcontainer" runat="server" />
                </label>

                <label class="config">
                    <asp:Label ID="lbltemplate" runat="server" Text="Modelo Padrão" />
                    <asp:DropDownList ID="lsttemplates" runat="server" />
                </label>

                <label class="config theme-selector">
                    <asp:Label runat="server" ID="lblTheme" Text="Tema" />
                    <asp:DropDownList ID="lstthemes" runat="server" />
                    <WFF:ColorPicker ID="cpkcustomtheme" CssClass="custom-theme-picker" OnClientLoad="customPicker" Style="display: none" runat="server" />
                    <p>
                        <asp:Literal runat="server" ID="litThemeDesc">As seleções de Tema e Logo feitas nesta página só funcionam se o template de página utilizado estiver usando a folha de estilo "<strong>/theme/styles</strong>".</asp:Literal>
                    </p>
                </label>
            </fieldset>

            <fieldset class="config logo zuri-logo">
                <legend>
                    <asp:Literal runat="server" ID="litLogo" Text="Logo" /></legend>
                <div class="stylized-file-input">
                    <asp:FileUpload runat="server" ID="upLogo" />
                </div>
                <asp:Button runat="server" ID="btAddLogo" CssClass="btnEnviar3 mt-2" Text="Adicionar" />
                <asp:Repeater ID="rptLogos" runat="server">
                    <HeaderTemplate>
                        <ul>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li>
                            <label title="Selecionar">
                                <input type="radio" name="selected-logo" <%#Eval("checked") %> value="<%#Eval("value")%>" />
                                <div>
                                    <span>
                                        <%#Eval("name")%>
                                    </span>
                                    <img src="<%#Eval("path")%>" />
                                    <span>
                                        <%#Eval("size")%>
                                    </span>
                                </div>
                            </label>
                            <asp:LinkButton runat="server" ToolTip="Delete" CssClass='<%# String.Format("delete {0}", Eval("value")).Trim()%>' CommandArgument='<%# String.Format("delete:{0}", Eval("value")).Trim()%>' Text="delete">
                                <i data-feather="trash-2"></i>
                            </asp:LinkButton> 
                        </li>
                    </ItemTemplate>
                    <FooterTemplate></ul></FooterTemplate>
                </asp:Repeater>

            </fieldset>
        </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="pvCSS">
            <fieldset class="config wfcustom-editor">
                <legend>
                    <asp:Literal runat="server" ID="litCustomCss" Text="Personalização de CSS" /></legend>
                <p>
                    <asp:Literal runat="server" ID="litCustomCssDesc" Text="As definições personalizadas de CSS só funcionam se o template de página utilizado estiver usando uma dessas folha de estilos: '<strong>/WFResources/WFCustom/styles/WFCustom.css</strong>' ou '<strong>/theme/styles</strong>'." />
                </p>
                <asp:TextBox runat="server" ID="txtCustom" TextMode="MultiLine" CssClass="wfcustom" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" />
            </fieldset>
        </telerik:RadPageView>
    </telerik:RadMultiPage>
    <asp:Label ID="msg" runat="server" />
    <section class="actions">
        <asp:Button ID="btnok" runat="server" Text="Ok" />
    </section>
</asp:Content>
