<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Pages.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Pages"
    Title="Untitled Page" %>

<%@ Register Src="../../WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';
        var MySelectedURL = '';
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHP(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'HP' + MySelectedItem;
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>

    <style type="text/css">
        span.home, span.not-home, span.published, span.not-published {
            display: inline-block;
            white-space: nowrap;
            text-indent: 200%;
            overflow: hidden;
            width: 20px;
            height: 20px;
            background-position: center center;
            background-repeat: no-repeat;
        }

        span.home {
            background-image: url(/WFResources/Common/Images/Icons/home-on.png);
        }

        span.not-home {
            background-image: url(/WFResources/Common/Images/Icons/home-off.png);
        }

        span.published {
            background-image: url(/WFResources/Common/Images/Icons/published-on.png);
        }

        span.not-published {
            background-image: url(/WFResources/Common/Images/Icons/published-off.png);
        }
    </style>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" /></li>
        <li>
            <asp:HyperLink ID="lnkconfig" runat="server" CssClass="edit" /></li>
        <li>
            <asp:HyperLink ID="lnkpreview" runat="server" CssClass="preview" /></li>
        <li>
            <asp:HyperLink ID="lnkhome" runat="server" CssClass="home" /></li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" /></li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
        <li>
            <asp:HyperLink ID="lnkdownload" runat="server" CssClass="download" /></li>
        <li>
            <asp:HyperLink ID="lnkupload" runat="server" CssClass="upload" /></li>
        <li>
            <asp:HyperLink ID="lnkcopy" runat="server" CssClass="copy" /></li>
        <li>
            <asp:HyperLink ID="lnkTheme" runat="server" CssClass="theme" /></li>
        <li>
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" Visible="false" /></li>

    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:WFPagePicker ID="portalpicker" runat="server" AddSelect="false" AdminMode="true" ForceCheckEvenForSiteAdmin="true" AutoSelectLast="true" ShowArea="true" ShowPage="false" NoLabels="false" />
        <div>
            <asp:Label ID="lblstatus" runat="server" />
            <asp:DropDownList ID="lststatus" runat="server" />
        </div>
        <div>
            <asp:Label ID="lblname" runat="server" />
            <asp:TextBox ID="txtalias" runat="server" />
        </div>
    </div>
    <asp:Button ID="btnbuscar" runat="server" ValidationGroup="SEARCH" CssClass="search" />
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <asp:ObjectDataSource ID="PageODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.Page"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex">
        <SelectParameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$portalpicker" Name="AreaId" PropertyName="CurrentArea" Type="Int32" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$lststatus" Name="Status" PropertyName="SelectedValue" Type="Int32" />
            <asp:ControlParameter ControlID="ctl00$FilterContent$txtalias" Name="PageAlias" PropertyName="text" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
        <ProgressTemplate>
            <div class="up-loading"></div>
        </ProgressTemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:RadGrid ID="grdPage" runat="server"
                AutoGenerateColumns="false" DataSourceID="PageODS" AllowSorting="True"
                GridLines="None" AllowPaging="True" PageSize="15">
                <MasterTableView DataSourceID="PageODS">
                    <Columns>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="left" />
                        <telerik:GridTemplateColumn HeaderText="" UniqueName="Home" ItemStyle-HorizontalAlign="center">
                            <ItemTemplate>
                                <asp:Label ID="lblHome" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn HeaderText="" UniqueName="Published" ItemStyle-HorizontalAlign="center">
                            <ItemTemplate>
                                <asp:Label ID="lblPublished" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="Alias" HeaderText="Alias" UniqueName="Alias" Visible="False" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="left" />
                        <telerik:GridBoundColumn DataField="Title" HeaderText="Title" UniqueName="Title" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="left" />
                        <telerik:GridBoundColumn DataField="StatusStr" HeaderText="StatusStr" UniqueName="StatusStr" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="left" />
                        <telerik:GridBoundColumn DataField="LastPublish" HeaderText="LastPublish" UniqueName="LastPublish" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="left" />
                        <telerik:GridBoundColumn DataField="LastPublisher" HeaderText="LastPublisher" UniqueName="LastPublisher" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="left" />
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
                    AllowColumnHide="false"
                    Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Pages" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <asp:HiddenField ID="SelectedAreaId" runat="server"></asp:HiddenField>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>
    <wff:WindowManager ID="EditWindow" runat="server">
        <Windows>
            <telerik:RadWindow ID="EditDialog" runat="server" Height="650px" Width="900px" ReloadOnShow="true" Modal="true" />
            <telerik:RadWindow ID="ImportDialog" runat="server" Height="650px" Width="900px" ReloadOnShow="true" Modal="true" />
        </Windows>
    </wff:WindowManager>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="FooterContent" runat="server">
</asp:Content>
