<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="PageImport.aspx.vb" Inherits="WebFoundations.WFPortal.UI.PageImport" %>

<%@ Register Src="../../WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="wf" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="cc1" %>
<%@ Register Src="../../WFControls/AccessList.ascx" TagName="AccessList" TagPrefix="uc1" %>
<%@ Register Src="../../WFControls/WFAccessList.ascx" TagName="WFAccessList" TagPrefix="uc2" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:Panel ID="pnlUpload" runat="server">
        <div class="fields no-columns">
            <label>
                <asp:Label ID="lblArea" runat="server" />
                <wf:WFPagePicker ID="portalPicker" runat="server" AddSelect="false" AdminMode="true" ForceCheckEvenForSiteAdmin="true" AutoSelectLast="true" ShowArea="true" ShowPage="false" NoLabels="true" />
            </label>
            <label>
                <asp:Label ID="lblUpload" runat="server" />
                <telerik:RadAsyncUpload ID="fuArquivo" UploadedFilesRendering="BelowFileInput" MaxFileInputsCount="1" PersistConfiguration="True" runat="server" />
            </label>
            <section class="actions">
                <asp:Button ID="btnOk" runat="server" CssClass="button" Text="Ok" />
                <input id="btnCancelUpload" type="button" class="button" value="button" runat="server" />
            </section>
        </div>
    </asp:Panel>
    <asp:Panel ID="pnlUpdate" runat="server" CssClass="fields no-columns" Visible="false">
        <div class="fields">
            <label>
                <asp:Label ID="lblUpdate" runat="server" />
                <asp:DropDownList ID="lstPages" runat="server" />
            </label>
            <section class="actions">
                <asp:Button ID="btnOkUpdate" runat="server" CssClass="button" Text="Ok" />
                <input id="btnCancelUpdate" type="button" class="button" value="button" runat="server" />
            </section>
        </div>
    </asp:Panel>
    <asp:Panel ID="pnlImport" runat="server" Visible="false">
        <div class="fields">
            <label>
                <asp:Label ID="lblAlias" runat="server" />
                <asp:TextBox ID="txtAlias" runat="server" MaxLength="80" />
                <asp:RequiredFieldValidator ID="reqAlias" Display="Dynamic" runat="server" ControlToValidate="txtAlias" />
                <asp:RegularExpressionValidator ID="vlAlias" Display="Dynamic" runat="server" ControlToValidate="txtAlias" ValidationExpression="[a-z|A-Z][a-z|A-Z|0-9]*" />
            </label>
            <label>
                <asp:Label ID="lblTitle" runat="server" />
                <asp:TextBox ID="txTtitle" runat="server" MaxLength="120" />
                <asp:RequiredFieldValidator ID="reqTitle" Display="Dynamic" runat="server" ControlToValidate="txtTitle" />
            </label>
            <label>
                <asp:Label ID="lblKeywords" runat="server" />
                <cc1:TextArea ID="txtKeywords" runat="server" MaxLength="1000" />
            </label>
            <label>
                <asp:Label ID="lblMetatags" runat="server" />
                <cc1:TextArea ID="txtMetatags" runat="server" MaxLength="1000" />
            </label>
            <label>
                <asp:Label ID="lblReaders" runat="server" />
                <uc2:WFAccessList ID="Readers" AnonymousValue="-6" runat="server" />
            </label>
            <label>
                <asp:Label ID="lblEditors" runat="server" />
                <uc1:AccessList ID="Editors" AdmMode="true" runat="server" />
            </label>
            <label>
                <asp:CheckBox ID="chkLocal" runat="server" CssClass="checkbox" />
            </label>
            <section class="actions">
                <asp:Button ID="btnImport" runat="server" CssClass="button" />
                <input id="btnCancel" type="button" class="button" value="button" runat="server" />
            </section>
        </div>
    </asp:Panel>
</asp:Content>

