<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="HeaderFooter.aspx.vb" Inherits="WebFoundations.WFPortal.UI.HeaderFooter" %>

<%@ Register Src="../../WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = 0;
        var MySelectedURL = '';
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = 0;
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:wfpagepicker id="portalpicker" runat="server" addselect="false" adminmode="true" autoselectlast="true" showarea="false" showpage="false" />
    </div>
    <asp:Button ID="btnbuscar" runat="server" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" />
        </li>
        <li>
            <asp:HyperLink ID="lnkedit" runat="server" CssClass="edit" />
        </li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" />
        </li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" />
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="HFODS" runat="server" SelectMethod="GetItems"
        TypeName="WebFoundations.WFPortal.Management.ObjectDataSources.HeaderFooter"
        EnablePaging="True" SortParameterName="column" SelectCountMethod="CountItems"
        MaximumRowsParameterName="MaximumRows" StartRowIndexParameterName="StartRowIndex">
        <selectparameters>
            <asp:ControlParameter ControlID="ctl00$FilterContent$portalpicker" Name="PortalId" PropertyName="CurrentPortal" Type="Int32" />
        </selectparameters>
    </asp:ObjectDataSource>
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
        <progresstemplate>
            <div class="up-loading"></div>
        </progresstemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server">
        <contenttemplate>
            <telerik:radgrid id="grdHF" runat="server"
                autogeneratecolumns="false" datasourceid="HFODS" allowsorting="True"
                gridlines="None" allowpaging="True" pagesize="15">
                <mastertableview datasourceid="HFODS">
                    <columns>
                        <telerik:gridboundcolumn datafield="Id" headertext="Id" uniquename="Id" itemstyle-horizontalalign="center" />
                        <telerik:gridboundcolumn datafield="Alias" headertext="Alias" uniquename="Alias" itemstyle-horizontalalign="center" />
                    </columns>
                </mastertableview>
                <clientsettings allowcolumnsreorder="false" allowdragtogroup="false"
                    allowcolumnhide="false"
                    selecting-allowrowselect="true" scrolling-allowscroll="false"
                    scrolling-usestaticheaders="true">
                </clientsettings>
                <exportsettings exportonlydata="True" filename="HeaderFooter" ignorepaging="True" openinnewwindow="True" />
            </telerik:radgrid>
            <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <asp:HiddenField ID="SelectedPortalId" runat="server"></asp:HiddenField>
        </contenttemplate>
        <triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </triggers>
    </asp:UpdatePanel>
    <wff:windowmanager id="EditWindow" runat="server">
        <windows>
            <telerik:radwindow id="EditDialog" runat="server" height="350px" width="450px" reloadonshow="true" modal="true" />
        </windows>
    </wff:windowmanager>
</asp:Content>

