﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="NinkiSettings.ascx.vb" Inherits="WF.Ninki.UI.NinkiSettings" %>
<script type="text/javascript">
    function suggestAlias(objTitulo) {
        var objApelido = document.getElementById('<%=txtapelido.ClientID%>');
        if (!objApelido.value) {
            var arrRegex = [/[ÃÁÀÂÄ]/g, /[ÉÈÊË]/g, /[ÍÌÎÏ]/g, /[ÕÓÒÔÖ]/g, /[ÚÙÛÜ]/g, /ÝŸ/g, /Ñ/g, /Ç/g];
            var arrNewValue = ['A', 'E', 'I', 'O', 'U', 'Y', 'N', 'C'];
            var valor = objTitulo.value.toUpperCase();
            for (var i = 0; i < arrRegex.length; i++) {
                valor = valor.replace(arrRegex[i], arrNewValue[i]);
            }
            valor = valor.replace(/[^A-Z0-9_]|\b[DN]{0,1}[AEO]S{0,1}\b/g, '');
            if (valor.length > 80) valor = valor.substr(0, 80);
            objApelido.value = valor;
        }
        if (window.onTitleChange) {
            window.onTitleChange(objTitulo.value);
        }
    }
</script>

<fieldset>
    <legend><asp:Literal runat="server" Text="Formulário" ID="litTitle" /></legend>

    <label>
        <asp:Label ID="lbltitulo" runat="server" Text="Titulo" />
        <asp:TextBox ID="txttitulo" runat="server" MaxLength="30" CssClass="form-info-title" onBlur="suggestAlias(this);" />
        <asp:RequiredFieldValidator ID="obrtitulo" ValidationGroup="forminfo" runat="server" ControlToValidate="txttitulo" Display="Dynamic" />
    </label>

    <label>
        <asp:Label ID="lblapelido" runat="server" Text="Apelido" />
        <asp:TextBox ID="txtapelido" runat="server" MaxLength="15" />
        <asp:RequiredFieldValidator ID="obrapelido" runat="server" ValidationGroup="forminfo" ControlToValidate="txtapelido" Display="Dynamic" />
        <asp:RegularExpressionValidator ID="vlapelido" runat="server" ValidationGroup="forminfo" ControlToValidate="txtapelido" Display="Dynamic" ValidationExpression="^[a-zA-Z][a-zA-Z0-9_]{2,14}$" />
    </label>

    <asp:PlaceHolder id="phTemplateFile" runat="server">
        <label>
            <asp:Label ID="lblTemplateFile" runat="server" Text="Template file" />
            <asp:DropDownList runat="server" ID="ddlTemplateFile" />
            <asp:RequiredFieldValidator ID="reqTemplate" runat="server" ValidationGroup="forminfo" ControlToValidate="ddlTemplateFile" Display="Dynamic" />
        </label>
    </asp:PlaceHolder>
    <label>
        <asp:CheckBox ID="chkCompatible" CssClass="checkbox" runat="server" />
    </label>
    <asp:Button ID="btnok" CssClass="form-save" ValidationGroup="forminfo" runat="server" Text="OK" />
</fieldset>
