﻿<%@ Page Language="vb" ValidateRequest="false" AutoEventWireup="false" CodeBehind="NinkiMobileEdit.aspx.vb" Inherits="WF.Ninki.UI.NinkiMobileEdit" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/WFAdmin/TagHeadAdmin.ascx" TagPrefix="wf" TagName="TagHeadAdmin" %>
<%@ Register Src="~/WFAdmin/Ninki/NinkiSettings.ascx" TagPrefix="wf" TagName="NinkiSettings" %>
<%@ Register Src="~/WFAdmin/Ninki/fieldsEditor.ascx" TagPrefix="wf" TagName="fieldsEditor" %>
<%@ Register Src="~/WFAdmin/Ninki/fieldsConfig.ascx" TagPrefix="wf" TagName="fieldsConfig" %>
<%@ Register Src="~/WFAdmin/Ninki/NinkiData.ascx" TagPrefix="wf" TagName="NinkiData" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>
<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
	<script src="../../WFResources/Themes/js/jquery.js" type="text/javascript"></script>
    <wf:TagHeadAdmin runat="server" id="TagHeadAdmin" />
    <script type="text/javascript">
        var formId = '';

        $(window).on('unload', function () {
            if (formId) {
                try {
                    $.ajax({
                        url: '../../api/ninki/forms/' + formId + '/unlock/',
                        contentType: 'text/xml; charset=utf-8',
                        type: 'POST',
                        async: false
                    });
                } catch (error) { }
            }
            if (window.opener && window.opener.refreshGrid) {
                try {
                    window.opener.refreshGrid();
                } catch (error) { }
            }
        });
       

        function UpdateDataPanel() {
            __doPostBack('updDataPanel', 'UpdateDataPanel');
        }

        (function($){
            
            $(document).ready(function (){
                $("a.form-config").click(function(){
                    var isopen = $("div.form-config").is(":visible");
                    if(!isopen){
                        $("div.form-config").css({display:"inline-block"});
                        $("aside.sidebar").addClass("active");
                    }else{
                        $("div.form-config .form-save").click();
                    }
                    return false;
                });
                window.focus();

                if (!formId) {
                    $(document.body).addClass("start");
                }
            });

            window.onFormSaved = function(){
                if (window) {
                    var o = window.opener;
                    if (o && o.refreshGrid) {
                        try { o.refreshGrid();} catch (error) { }
                    }
                    try {
                        $(document.body).removeClass("start");
                        $("aside.sidebar").removeClass("active");
                        $("div.form-config").hide();
                    } catch (error) { }
                }
            };

            window.onTitleChange = function(value){
                $("h2#form-title").text(value||"");
            }

        })($)
    </script>

</head>
<body class="wf-designer forms-designer forms-designer-mobile">
    <form runat="server">
        <asp:ScriptManager runat="server" />
        <header>
            <div class="logo-container">
                <svg xmlns="http://www.w3.org/2000/svg" width="53" height="48" viewBox="0 0 53 48" fill="none">
                    <path d="M9.5 0.5H49.5L50.5 8.5H3L9.5 0.5Z" fill="#00ABF8" />
                    <path d="M40.7687 8.31458L50.5001 8.5005L26.9858 36.989L17.7666 36.8128L40.7687 8.31458Z" fill="#00ABF8" />
                    <path d="M52 5C51.3937 7.42536 50.5 9.5 48.5 9.5C46.8431 9.5 46 6.433 46 4.5C46 2.567 47.8431 0.5 49.5 0.5C51.1569 0.5 52.5 3 52 5Z" fill="#00ABF8" />
                    <path d="M50.5 39H1.90524L3 47H44L50.5 39Z" fill="white" />
                    <path d="M25.0021 10.6837L34.7335 10.8696L11.2192 39.3581L2.00003 39.182L25.0021 10.6837Z" fill="white" />
                    <path d="M0.443981 42.5632C0.994062 40.1316 2.5 38.4996 3.72558 38.0262C5.19703 37.4579 6.13989 41.0664 6.16152 42.9993C6.18316 44.9321 4.45164 47.0187 2.87433 47.0363C1.29702 47.054 -0.00962732 44.5685 0.443981 42.5632Z" fill="white" />
                </svg>
                <h1><asp:Literal ID="ltTitle" runat="server" /></h1>
            </div>
            <h2 id="form-title"><asp:Literal ID="ltName" runat="server" /></h2>
            <menu type="toolbar" id="toolbar">
                <li class="controls">
                    <input type="radio" name="toolgroup" id="toolgroup-formula" checked="checked" />
                    <label for="toolgroup-formula"><asp:Literal ID="ltControls" runat="server" Text="Controles" /></label>
                    <div class="content">
                        <asp:ImageButton runat="server" ID="addTextBox" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/textbox.png" />
                        <asp:ImageButton runat="server" ID="addLabel" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/label.png" />
                        <asp:ImageButton runat="server" ID="addSelection" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/selection.png" />
                        <asp:ImageButton runat="server" ID="addCheckBox" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/checkbox.png" />
                        <asp:ImageButton runat="server" ID="addDataTime" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/datetime.png" />
                        <asp:ImageButton runat="server" ID="addScale" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/rating.png" />
                        <asp:ImageButton runat="server" ID="addLocation" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/location.png" />
                        <asp:ImageButton runat="server" ID="addMap" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/maps.png" />
                        <asp:ImageButton runat="server" ID="addQRCode" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/qrcode.png" />
                        <asp:ImageButton runat="server" ID="addDelimeter" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/delimeter.png" />
                        <asp:ImageButton runat="server" ID="addAttachment" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/attachment.png" />
                        <asp:ImageButton runat="server" ID="addAction" OnCommand="AddControl" ImageUrl="../../WFResources/FormsMobile/Images/Editor/action.png" />
                    </div>
                </li>
                <li class="data">
                    <input type="radio" name="toolgroup" id="toolgroup-data" />
                    <label for="toolgroup-data">
                        <asp:Literal ID="ltData" runat="server" Text="Dados" /></label>
                    <div class="content">
                        <asp:HyperLink ID="lnkInsertData" CssClass="add" runat="server" Text="Adicionar" />
                        <asp:UpdatePanel ID="updDataPanel" class="data-sources" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <wf:NinkiData runat="server" id="NinkiData" />
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </div>
                </li>
            </menu>
        </header>
        <main>
            <asp:UpdatePanel ID="updFormFields" class="data-sources" runat="server" UpdateMode="Conditional">
                <Triggers>
                    <asp:AsyncPostBackTrigger ControlID="addTextBox" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addLabel" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addSelection" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addCheckBox" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addDataTime" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addScale" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addLocation" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addMap" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addQRCode" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addDelimeter" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addAttachment" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="addAction" EventName="Click" />
                </Triggers>
                <ContentTemplate>
                    <wf:fieldsEditor runat="server" id="fieldsEditor" visible="false" />
                </ContentTemplate>
            </asp:UpdatePanel>
        </main>
        <aside class="sidepanel props">
            <asp:UpdatePanel ID="updConfigs" runat="server" UpdateMode="Conditional">
                <ContentTemplate>
                    <wf:fieldsConfig runat="server" id="fieldsConfig" />
                </ContentTemplate>
            </asp:UpdatePanel>
        </aside>
        <aside class="sidebar form-info">
            <menu>
                <li class="activate">
                    <asp:LinkButton ID="lnkGenerate" runat="server" />
                </li>
                <li class="test">
                    <asp:HyperLink ID="lnkTest" runat="server" />
                </li>
                <li class="config">
                    <asp:LinkButton ID="lnkSettings" CssClass="form-config" runat="server" />
                </li>
            </menu>
            <asp:UpdatePanel runat="server" class="fields form-config" ID="uppFormInfo">
                <ContentTemplate>
                    <wf:NinkiSettings runat="server" id="NinkiSettings" />
                </ContentTemplate>
            </asp:UpdatePanel>
        </aside>
        <wff:WindowManager ID="EditWindow" runat="server">
            <Windows>
                <telerik:RadWindow ID="EditDialog" runat="server" Behaviors="Close,Move,Reload,Resize" Height="450px" VisibleStatusbar="false" Width="700px" ReloadOnShow="true" Modal="true" />
            </Windows>
        </wff:WindowManager>
    </form>
</body>
</html>
