﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="NinkiMobile.aspx.vb" Inherits="WF.Ninki.UI.NinkiMobile" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Src="~/WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackExport(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'EXPORT' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:WFPagePicker ID="portalpicker" runat="server" AddSelect="false" ForceCheckEvenForSiteAdmin="true"
            AdminMode="true" AutoSelectLast="true" ShowArea="true" ShowPage="false" NoLabels="false" />
    </div>
    <asp:Button ID="btnbuscar" runat="server" ValidationGroup="SEARCH" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" /></li>
        <li>
            <asp:HyperLink ID="lnkpreview" runat="server" CssClass="edit" /></li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" /></li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
        <li>
            <asp:HyperLink ID="lnkdownload" runat="server" CssClass="download" /></li>
        <li>
            <asp:HyperLink ID="lnkupload" runat="server" CssClass="upload" /></li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updateform">
        <ProgressTemplate>
            <div class="up-loading"></div>
        </ProgressTemplate>
    </asp:UpdateProgress>
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:RadGrid ID="grdFormulario" runat="server" AutoGenerateColumns="false" AllowSorting="True" GridLines="None" AllowPaging="True" PageSize="15">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn HeaderText="" UniqueName="PUBLISHED" HeaderStyle-Width="40px" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle">
                            <ItemTemplate>
                                <div style="float: left;">
                                    <asp:Image ID="imgPublished" runat="server" /></div>
                                <div style="float: left; padding-left: 4px;">
                                    <asp:Image ID="imgEdicao" ImageUrl="~/WFResources/Common/images/icons/edit.png" runat="server" /></div>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="ID" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="Title" HeaderText="Title" UniqueName="NAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="TableName" HeaderText="TableName" UniqueName="TABLENAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="PublishDate" HeaderText="PublishDate" UniqueName="PUBLISHDATE" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridTemplateColumn HeaderText="Publisher" UniqueName="PUBLISHER" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle">
                            <ItemTemplate>
                                <asp:Label ID="lbluser" runat="server" Text="Label"></asp:Label>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
                    AllowColumnHide="false" Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Pages" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid><asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
            <asp:HiddenField ID="SelectedAreaId" runat="server" />
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>
    <wff:WindowManager ID="EditWindow" runat="server">
        <windows>
            <telerik:RadWindow ID="ImportDialog" runat="server" Height="350px" Width="450px" ReloadOnShow="true" Modal="true" />
            <telerik:RadWindow ID="ExportDialog" runat="server" Height="150px" Width="450px" ReloadOnShow="true" Modal="true" />
        </windows>
    </wff:WindowManager>
</asp:Content>
