﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="DataSourceConfig.aspx.vb" Inherits="WF.Ninki.UI.DataSourceConfig" %>

<%@ Register Src="~/WFAdmin/Ninki/DataSourceProcedure.ascx" TagPrefix="uc1" TagName="DataSourceProcedure" %>
<%@ Register Src="~/WFAdmin/Ninki/DataSourceWebService.ascx" TagPrefix="uc1" TagName="DataSourceWebService" %>
<%@ Register Src="~/WFAdmin/Ninki/DataSourceXML.ascx" TagPrefix="uc1" TagName="DataSourceXML" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        function CloseAndRebind(formula) {
            try {
                var w = GetRadWindow();
                if (w) {
                    w.Close();
                    w.BrowserWindow.UpdateDataPanel(formula);
                }
            } catch (error) { }
        }
        function Close() {
            try {
                var w = GetRadWindow();
                if (w) { w.Close(); }
            } catch (error) { }
        }
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <div class="fields no-columns">
        <div>
            <asp:Label runat="server" ID="lblTitle" />
            <asp:TextBox runat="server" ID="txtTitle" />
        </div>
        <div>
            <asp:Label runat="server" ID="lblDataSourceType" />
            <asp:DropDownList ID="ddlDataSourceType" runat="server" AutoPostBack="True" />
        </div>
        <!-- CONTROLES PARA CONFIGURAÇÃO -->
        <uc1:DataSourceProcedure runat="server" ID="DataSourceProcedure" Visible="false" />
        <uc1:DataSourceWebService runat="server" ID="DataSourceWebService" Visible="false" />
        <uc1:DataSourceXML runat="server" ID="DataSourceXML" Visible="false" />
    </div>

    <!-- PAINEL PARA CONFIGURAÇÃO DOS PARÂMETROS DE ENTRADA -->
    <asp:Panel runat="server" ID="pnlParams" CssClass="fields no-columns" Visible="false">
        <div>
            <asp:Label runat="server" ID="lblParams" />
        </div>
        <asp:Repeater runat="server" ID="rptParams">
            <HeaderTemplate>
                <table border="0" cellpadding="2" cellspacing="2" width="100%">
                    <tr>
                        <td>
                            <asp:Label runat="server" CssClass="tabletitle" ID="lblHParamName" Text="Nome" /></td>
                        <td>
                            <asp:Label runat="server" CssClass="tabletitle" ID="lblHParamType" Text="Tipo" /></td>
                        <td>
                            <asp:Label runat="server" CssClass="tabletitle" ID="lblHParamExec" Text="Valor de execução" /></td>
                        <td>
                            <asp:Label runat="server" CssClass="tabletitle" ID="lblHParamTest" Text="Valor de teste" /></td>
                    </tr>
            </HeaderTemplate>
            <FooterTemplate>
                </table>
            </FooterTemplate>
            <ItemTemplate>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="lblParamName" /></td>
                    <td>
                        <asp:Label runat="server" ID="lblParamType" /></td>
                    <td>
                        <telerik:RadComboBox ID="ddlParamExec" width="200px" runat="server" OnItemsRequested="LoadContextItems"
                            MarkFirstMatch="false" EnableLoadOnDemand="true" />
                    </td>
                    <td>
                        <asp:TextBox runat="server" ID="txtParamTest" /></td>
                </tr>
            </ItemTemplate>
        </asp:Repeater>
        <div>
            <asp:Label runat="server" ID="lblNoParams" Visible="false" />
        </div>
    </asp:Panel>

    <div>
        <asp:Button runat="server" ID="btnTest" Visible="false" />
    </div>

    <!-- PAINEL PARA VISUALIZAÇÃO DOS OBJETOS DE SAÍDA -->
    <asp:Panel runat="server" ID="pnlResults" Visible="false">
        <div>
            <asp:Label runat="server" ID="lblResults" />
        </div>
        <asp:Repeater runat="server" ID="rptResults">
            <HeaderTemplate>
                <table>
                    <tr>
                        <td><asp:Label runat="server" ID="lblHOutPropName" /></td>
                        <td><asp:Label runat="server" ID="lblHOutPropType" /></td>
                    </tr>
            </HeaderTemplate>
            <FooterTemplate>
                </table>
            </FooterTemplate>
            <ItemTemplate>
                <tr>
                    <td><asp:Label runat="server" ID="lblOutPropName" /></td>
                    <td><asp:Label runat="server" ID="lblOutPropType" /></td>
                    <td><asp:Label runat="server" ID="lblOutPropXPath" /></td>
                </tr>
            </ItemTemplate>
        </asp:Repeater>
        <div>
            <asp:Label runat="server" ID="lblNoResults" Visible="false" />
        </div>
    </asp:Panel>

    <section class="actions">
        <asp:Button runat="server" ID="btnOk" Enabled="false" />
        <asp:Button runat="server" ID="btnCancel" OnClientClick="return Close();" />
    </section>
</asp:Content>
