﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="GalleryEdit.aspx.vb" Inherits="WebFoundations.WFPortal.BaseModules.UI.GalleryEdit" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content runat="server" ContentPlaceHolderID="TagHead">
    <style type="text/css">
        .add-new {
            margin-bottom: .5em;
        }
    </style>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:Label ID="lblAvisosGerais" CssClass="contPadrao2" runat="server" />
    <asp:ValidationSummary ID="vsuGeral" CssClass="contPadrao2" runat="server" ValidationGroup="Galeria" />
    <telerik:RadTabStrip ID="PainelTabs" MultiPageID="Tabs" runat="server" AutoPostBack="True" CausesValidation="False">
        <Tabs>
            <telerik:RadTab ID="Galeria" PageViewID="TabGaleria" runat="server" />
            <telerik:RadTab ID="Imagem" PageViewID="TabImagem" runat="server" />
        </Tabs>
    </telerik:RadTabStrip>
    <telerik:RadMultiPage ID="Tabs" runat="server">
        <telerik:RadPageView ID="TabGaleria" runat="server">
            <div class="fields">
                <label>
                    <asp:Label ID="lblGaleria" runat="server" />
                    <asp:TextBox ID="txtGaleria" MaxLength="200" runat="server" />
                    <asp:RequiredFieldValidator ID="obrTituloGaleria" runat="server" ControlToValidate="txtGaleria"
                        Text="*" Display="Dynamic" ValidationGroup="Galeria" />
                </label>
                <label>
                    <asp:Label ID="lblGalleryPath" runat="server" />
                    <asp:TextBox ID="txtGalleryPath" MaxLength="200" runat="server" />
                    <asp:RequiredFieldValidator ID="obrGalleryPath" runat="server" ControlToValidate="txtGalleryPath"
                        Text="*" Display="Dynamic" ValidationGroup="Galeria" />
                </label>
            </div>
        </telerik:RadPageView>
        <telerik:RadPageView ID="TabImagem" runat="server">
            <asp:Button ID="btnNewItem" runat="server" CausesValidation="false" CssClass="add-new" />

            <asp:Panel ID="pnlEditItem" runat="server" CssClass="fields" Visible="false">
                <label>
                    <asp:Label ID="lblOrdem" runat="server" />
                    <asp:TextBox ID="txtOrdem" runat="server" Width="40px" MaxLength="4" />
                    <asp:RequiredFieldValidator ID="obrOrdem" runat="server" ControlToValidate="txtOrdem"
                        Text="*" Display="Dynamic" ValidationGroup="Item" />
                    <asp:RegularExpressionValidator ID="vlOrdem" runat="server" ControlToValidate="txtOrdem"
                        Display="Dynamic" ValidationExpression="\d*"></asp:RegularExpressionValidator>
                </label>
                <label>
                    <asp:Label ID="lblTitulo" runat="server" />
                    <asp:TextBox ID="txtTitulo" MaxLength="100" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblDescricao" runat="server" />
                    <asp:TextBox ID="txtDescricao" MaxLength="200" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblItem" runat="server" />
                    <asp:FileUpload ID="uplGalleryItem" runat="server" />
                    <asp:RequiredFieldValidator ID="obrItem" runat="server" ControlToValidate="uplGalleryItem"
                        Text="*" Display="Dynamic" ValidationGroup="Item" />
                    <asp:CustomValidator ID="valFileFormat" EnableClientScript="true" runat="server" ControlToValidate="uplGalleryItem" Text="*" Display="Dynamic" ValidationGroup="Item" OnServerValidate="valFileFormat_Validate" />
                </label>
                <section class="actions">
                    <asp:Button ID="btnAdicionarItem" runat="server" ValidationGroup="Item" />
                    <asp:Button ID="btnCancelarEdicaoItem" runat="server" />
                </section>
            </asp:Panel>

            <telerik:RadGrid ID="gridImagem" runat="server" AutoGenerateColumns="False" OnEditCommand="gridImagem_ItemCommandID">
                <MasterTableView DataKeyNames="Id">
                    <RowIndicatorColumn Visible="False" />
                    <ExpandCollapseColumn Resizable="False" Visible="False" />
                    <Columns>
                        <telerik:GridBoundColumn DataField="Id" UniqueName="Id" Visible="false" />
                        <telerik:GridTemplateColumn HeaderStyle-Width="25px" UniqueName="Delete">
                            <ItemTemplate>
                                <asp:ImageButton ID="btndelete" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn HeaderStyle-Width="25px" UniqueName="Delete">
                            <ItemTemplate>
                                <asp:ImageButton ID="btnedit" ImageUrl="~/WFResources/Common/Images/Icons/edit.png" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="Order" UniqueName="Order" />
                        <telerik:GridTemplateColumn UniqueName="Title">
                            <ItemTemplate>
                                <asp:HyperLink ID="hypImagem" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
            </telerik:RadGrid>
        </telerik:RadPageView>
    </telerik:RadMultiPage>

    <section class="actions">
        <asp:Button ID="btnNextStepImagem" runat="server" ValidationGroup="Galeria" />
        <asp:Button ID="btnBackStepGaleria" runat="server" />
        <asp:Button ID="btnConcluir" runat="server" />
        <asp:Button ID="btnConfirmar" runat="server" />
        <asp:Button ID="btnCancelar" runat="server" />
    </section>
</asp:Content>
