﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="MenuEdit.aspx.vb" Inherits="WebFoundations.WFPortal.UI.MenuEdit" ValidateRequest="false" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Src="../../WFControls/URLPicker.ascx" TagName="URLPicker" TagPrefix="uc2" %>
<%@ Register Src="../../WFControls/ImagePicker.ascx" TagName="ImagePicker" TagPrefix="uc3" %>
<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="WFF" %>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <telerik:radtabstrip id="menutab" runat="server" multipageid="menupages" selectedindex="0">
        <tabs>
            <telerik:radtab runat="server" pageviewid="MnuConfig" text="Configuracao" />
            <telerik:radtab runat="server" pageviewid="MnuItems" text="&#205;tens" enabled="false" />
        </tabs>
    </telerik:radtabstrip>
    <telerik:radmultipage id="menupages" runat="server" selectedindex="0">
        <telerik:radpageview id="MnuConfig" runat="server">
            <div class="fields">
                <label>
                    <asp:Label ID="lblportaltit" runat="server" />
                    <asp:Label ID="lblportal" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblalias" runat="server" />
                    <asp:TextBox ID="txtalias" runat="server" MaxLength="50" />
                    <asp:RequiredFieldValidator ID="reqalias" Display="Dynamic" runat="server" ControlToValidate="txtalias" />
                    <asp:RegularExpressionValidator ID="vlalias" runat="server" ControlToValidate="txtalias" ValidationExpression="[a-z|A-Z][a-z|A-Z|0-9]*" />
                </label>
                <label>
                    <asp:Label ID="lbleditors" runat="server" />
                    <wff:accesslist id="lsteditors" admmode="true" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblreaders" runat="server" />
                    <wff:accesslist id="lstreaders" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lbllanguages" runat="server" />
                    <asp:TextBox ID="txtlanguages" runat="server" MaxLength="50" />
                </label>
            </div>
            <section class="actions">
                <asp:Button ID="btnok" runat="server" CssClass="button" />
                <input id="btncancel" type="button" class="button" value="button" runat="server" />
            </section>
        </telerik:radpageview>
        <telerik:radpageview id="MnuItems" runat="server">
            <table class="unstyled" cellspacing="2" cellpadding="2" width="100%" border="0">
                <tr>
                    <td valign="top">
                        <asp:ImageButton ID="btnaddroot" OnClick="btnaddroot_Click" runat="server" ImageUrl="~/WFResources/Content/TreeView/addroot.gif"></asp:ImageButton>
                        <asp:Label ID="lblroot" runat="server" Text="Label"></asp:Label>
                        <telerik:radtreeview id="menutree" runat="server" runat="server" enabledraganddrop="True"
                            multipleselect="false" enabledraganddropbetweennodes="true"
                            datatextfield="Text" datavaluefield="Id" datasourceid="DSMenuItems">
                        </telerik:radtreeview>
                        <wff:menudatasource id="DSMenuItems" runat="server" adminview="False"></wff:menudatasource>
                    </td>
                    <td id="ItemEdit" valign="top" runat="server" visible="false">
                        <div class="fields">
                            <label>
                                <asp:Label ID="lbltitle" runat="server" />
                                <asp:TextBox ID="txttitle" runat="server" MaxLength="100" />
                            </label>
                            <div class="menupatternsection">
                                <asp:Label Text="Padrão do menu:" ID="iconimagelabel" runat="server" />
                                <div>
                                    <div>
                                        <asp:RadioButton data-handler="empty" Checked="True" ID="simplesmenuitem" GroupName="menupattern" Text="Sem ícone" runat="server" />
                                    </div>
                                    <div>
                                        <asp:RadioButton data-handler="default" ID="patternicon" GroupName="menupattern" Text="Ícone padrão" runat="server" />
                                    </div>
                                    <div>
                                        <asp:RadioButton data-handler="custom" ID="customicon" GroupName="menupattern" Text="Ícone personalizado" runat="server" />
                                    </div>
                                </div>
                            </div>
                            <div id="imagepickercontainer" class="notVisible">
                                <asp:Label ID="lblimage" runat="server" />
                                <uc3:imagepicker id="ItemImage" runat="server" />
                            </div>
                            <div id="iconpickercontainer" class="notVisible">
                                <asp:Label Text="Ícone" ID="lblicone" runat="server" />
                                <asp:TextBox ID="iconinput" runat="server" />
                                <div class="list-of-icons" id="listoficons"></div>
                            </div>
                            <label>
                                <asp:Label ID="lbldescription" runat="server" />
                                <asp:TextBox ID="txtdescription" runat="server" MaxLength="150" />
                            </label>
                            <label>
                                <asp:Label ID="lblopen" runat="server" />
                                <asp:DropDownList ID="cmbopen" runat="server" />
                            </label>
                            <label>
                                <asp:Label ID="lblitreaders" runat="server" />
                                <wff:accesslist id="Readers" anonymousvalue="-6" runat="server" />
                            </label>
                            <label>
                                <asp:Label ID="lblurl" runat="server" />
                                <uc2:urlpicker id="ItemURL" runat="server" />
                            </label>
                            <label>
                                <asp:Label ID="lbllanguage" runat="server" />
                                <asp:TextBox ID="txtlanguage" runat="server" MaxLength="5" />
                            </label>
                            <label>
                                <asp:Label ID="lbllocal" runat="server" />
                                <asp:CheckBox ID="chklocal" runat="server" CssClass="checkbox" />
                            </label>
                            <label>
                                <asp:Label ID="lblnamekey" runat="server" />
                                <asp:TextBox ID="txtnamekey" runat="server" MaxLength="50" />
                            </label>
                        </div>
                        <section class="actions">
                            <asp:Button ID="btnokitem" runat="server" />
                            &nbsp;&nbsp;
                            <asp:Button ID="btncancelitem" runat="server" />
                        </section>
                    </td>
                </tr>
            </table>
        </telerik:radpageview>
    </telerik:radmultipage>

    <script>
        const handles = {
            empty: function () {
                document.getElementById('imagepickercontainer').classList.add('notVisible');
                document.getElementById('iconpickercontainer').classList.add('notVisible');
            },
            default: function () {
                document.getElementById('imagepickercontainer').classList.add('notVisible');
                document.getElementById('iconpickercontainer').classList.remove('notVisible');
            },
            custom: function () {
                document.getElementById('imagepickercontainer').classList.remove('notVisible');
                document.getElementById('iconpickercontainer').classList.add('notVisible');
            },
        }

        function initPage() {
            const iconInput = document.querySelector('#iconpickercontainer input');
            if (iconInput) {
                iconPicker.init(iconInput.getAttribute('id'), 'listoficons');

                const patternRadios = document.querySelectorAll('.menupatternsection input[type=radio]');
                patternRadios.forEach(pRadio => {
                    const handler = handles[pRadio.parentElement.getAttribute('data-handler')];
                    pRadio.addEventListener('click', handler);
                    if (pRadio.checked) handler();
                })
            }
        }

        document.addEventListener("DOMContentLoaded", function (event) {
            initPage();
        });
    </script>

</asp:Content>
