﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="Login.aspx.vb" Inherits="WebFoundations.WFPortal.UI.Login" %>

<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>
<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="WFF" %>

<!DOCTYPE html>
<html>
<head id="Head1" runat="server">
    <title>Login</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <script src="/%%PORTAL%%WFResources/THemes/js/html5.min.js" type="text/javascript"></script>
    <link href="/%%PORTAL%%theme/styles" rel="stylesheet" type="text/css" />
    <script src="/%%PORTAL%%theme/scripts"></script>
    <script src="https://www.google.com/recaptcha/api.js?render=6Le8MboiAAAAABbjn2sAS317OITvVBGRN5AD_D9G"></script>
</head>
<body class="root-page login facelift">    
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <header>
            <a href="/" class="logo">
                <h1><%:WebFoundations.WFPortal.Management.Settings.AppSettings.SiteTitle%></h1>
            </a>
            <nav>
                <wff:menu menualias="public" runat="server" />
            </nav>
            <aside>
                <wfc:headerfooter runat="server" alias="header" />
            </aside>
        </header>
        <!-- CONTEUDO -->

        <main class="message">
            <header>
                <a href="/" class="logo">
                    <h1><%:WebFoundations.WFPortal.Management.Settings.AppSettings.SiteTitle%></h1>
                </a>
            </header>
            <section class="login">
                <h2>Login</h2>
                <div>
                    <asp:Literal runat="server" ID="litChangeMessage" />
                </div>
                <label>
                    <asp:Label ID="lbllogin" runat="server" /><asp:TextBox
                        ID="txtlogin" runat="server" />
                    <asp:RequiredFieldValidator ID="reqLoginReset" runat="server" ControlToValidate="txtlogin" ValidationGroup="reset" Display="Dynamic" />
                </label>
                <div>
                    <asp:Label ID="lblpwd" runat="server" />
                    <div class="password-container">
                        <asp:TextBox
                            ID="txtpwd" runat="server" data-toggle="password1" TextMode="Password" />
                        <a href="#" class="toggle-password" data-for="password1">
                            <i data-feather="eye-off"></i>
                            <i data-feather="eye"></i>
                        </a>
                    </div>
                </div>
                <asp:PlaceHolder ID="phExpired" runat="server" Visible="false">
                    <label>
                        <asp:Label ID="lblNewPass" runat="server" /><asp:TextBox
                            ID="txtnewpwd" runat="server" TextMode="Password" />
                    </label>
                    <label>
                        <asp:Label ID="lblNewPass2" runat="server" /><asp:TextBox
                            ID="txtnewpwd2" runat="server" TextMode="Password" />
                    </label>
                </asp:PlaceHolder>
                <div class="no-label">
                    <asp:CheckBox ID="chkremember" CssClass="checkbox" runat="server" />
                </div>
                <asp:PlaceHolder ID="phReset" runat="server" Visible="false">
                    <div class="no-label login-reset">
                        <asp:LinkButton ID="lnkResetPwd" runat="server" ValidationGroup="reset" />
                    </div>
                </asp:PlaceHolder>               
                <asp:Button ID="btnok" CssClass="ok" runat="server" OnClientClick="return reCAPTCHA(event);"/>
            </section>

        </main>

        <footer>
            <wfc:headerfooter runat="server" alias="footer" />
        </footer>

        <script>
            const togglePassword = {
                init: () => {
                    const buttons = document.querySelectorAll('.toggle-password');
                    for (i = 0; i < buttons.length; i++) {
                        buttons[i].addEventListener('click', e => {
                            e.preventDefault();
                            const input = document.querySelector(`input[data-toggle=${e.currentTarget.getAttribute('data-for')}]`);
                            if (input) {
                                input.setAttribute('type', (input.getAttribute('type') == 'password') ? 'text' : 'password');
                            }
                        })
                    }
                }
            }
            document.addEventListener("DOMContentLoaded", function (event) {
                feather.replace();
                togglePassword.init();
            });

            function reCAPTCHA(e) {
                e.preventDefault();
                grecaptcha.ready(function () {
                    grecaptcha.execute('6Le8MboiAAAAABbjn2sAS317OITvVBGRN5AD_D9G', { action: 'submit' }).then(function (token) {
                        $.get(`Recaptcha.aspx?token=${token}`).done(function (result) {
                            if (result.success === false) {
                                alert("Ocorreu um erro ao validar o reCAPTCHA");
                            }
                            else {
                                __doPostBack('btnok', '')
                            }
                        });
                    })
                });
            }
        </script>
    </form>
    <div class="powered-by-container">
        <a target="_blank" rel="noopener" href="https://gozuri.com/">
            <span>Powered by</span>
            <svg width="33px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 172.92 68.96">
                <defs>
                    <style>
                        .cls-1 {
                            fill: #3fa9f5;
                        }

                        .cls-2 {
                            fill: #476c81;
                        }
                    </style>
                </defs>
                <g id="Layer_2" data-name="Layer 2">
                    <g id="Layer_1-2" data-name="Layer 1">
                        <circle class="cls-1" cx="167.17" cy="5.75" r="5.75" />
                        <path class="cls-1" d="M57.61,18.58a3.79,3.79,0,0,0-3.45-2.7H10.08L3.14,24.75H45.35L19.6,56.65H30L56.86,23.39A5.06,5.06,0,0,0,57.61,18.58Z" />
                        <path class="cls-2" d="M38.84,27.46H28.44L1.05,60.7A5.06,5.06,0,0,0,.3,65.51a3.79,3.79,0,0,0,3.45,2.7H48.83L56,59.34H12.56Z" />
                        <path class="cls-2" d="M100.34,27V56.8a3,3,0,0,1-3,3H72.55a3,3,0,0,1-3-3V15.88l-.1.1-8.9,11V59.8a9,9,0,0,0,9,9h30.79a9,9,0,0,0,9-9V15.89Z" />
                        <path class="cls-2" d="M158.87,15.88h-33.4a9,9,0,0,0-9,9V68.8l9-11.12V27.88a3,3,0,0,1,3-3H151.6Z" />
                        <polygon class="cls-2" points="171.67 57.93 171.67 15.88 162.67 15.88 162.67 68.96 162.77 68.96 171.67 57.93" />
                    </g>
                </g>
            </svg>
        </a>
    </div>
</body>
</html>