﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="ZuriFormContainer.aspx.vb" Inherits="Zuri.Forms.UI.ZuriFormContainer" %>

<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>
<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="WFF" %>
<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>


<!DOCTYPE html>
<html lang="<%= GetRegionalization() %>">
<head runat="server">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">

    <link href="/%%PORTAL%%theme/styles" rel="stylesheet" type="text/css" />
    <link rel="manifest" href="/manifest.webmanifest" crossorigin="use-credentials">

    <link rel="shortcut icon" href="/favicon.ico?v=2" type="image/x-icon" />
    <script src="/%%PORTAL%%theme/scripts"></script>
</head>
<style>
    ::-webkit-scrollbar {
        width: 5px;
        height: 13px;
    }
    /* Track */
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 4px;
    }
    /* Handle */
    ::-webkit-scrollbar-thumb {
        background: #adadad;
        border-radius: 4px;
    }
        /* Handle on hover */
        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
</style>
<script type="text/javascript">
    function GetRadWindow() {
        var oWindow = null;
        try {
            if (window.radWindow) oWindow = window.radWindow; //Will work in Moz in all cases, including clasic dialog
            else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;//IE (and Moz az well)
        } catch (error) { }
        return oWindow;
    }
    function CloseContainerWindow() {
        try {
            var w = GetRadWindow();
            if (w) {
                w.Close();
            } else {
                w = window;
                if (w && w.close) { w.close(); }
            }
        } catch (error) { }
    }
    $(document).ready(function () {
        $("body").removeClass("loading");
    });
</script>
<body id="collapsable-page" class="new-template">
    <form runat="server">
        <asp:ScriptManager runat="server" />
        <WFC:PageBanner ID="WFPageBanner" runat="server" />
        <header>
            <div class="collapsable">
                <button onclick="menuclick(event)">
                    <i data-feather="menu"></i>
                </button>
                <a href="/" title="Home">
                    <img id="imagelogo" alt="Logo" runat="server" />
                </a>
            </div>
            <div>
                <div>
                    <button onclick="menuclick(event)">
                        <i data-feather="menu"></i>
                    </button>
                    <a href="/" title="Home">
                        <img id="imagelogo2" alt="Logo" runat="server" />
                    </a>
                    <h2>
                        <asp:Literal ID="litTitle1" runat="server" /></h2>
                </div>
            </div>
        </header>
        <section class="main">
            <aside class="nav collapsable">
                <header class="mobile-menu-header">
                    <a href="/" title="Home" class="logo">
                        <h1>
                            <asp:Literal ID="litTitle2" runat="server" />
                        </h1>
                    </a>
                    <button onclick="menuclick(event)">
                        <i data-feather="x"></i>
                    </button>
                </header>
                <nav>
                    <WFF:Menu MenuAlias="anonymous" runat="server" NoSurroundingDiv="true" />
                </nav>
                <footer>
                    <a target="_blank" rel="noopener" href="https://gozuri.com/">
                        <span>Powered by</span>
                        <svg width="33px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 172.92 68.96">
                            <defs>
                                <style>
                                    .cls-1 {
                                        fill: #3fa9f5;
                                    }

                                    .cls-2 {
                                        fill: #476c81;
                                    }
                                </style>
                            </defs>
                            <g id="Layer_2" data-name="Layer 2">
                                <g id="Layer_1-2" data-name="Layer 1">
                                    <circle class="cls-1" cx="167.17" cy="5.75" r="5.75" />
                                    <path class="cls-1" d="M57.61,18.58a3.79,3.79,0,0,0-3.45-2.7H10.08L3.14,24.75H45.35L19.6,56.65H30L56.86,23.39A5.06,5.06,0,0,0,57.61,18.58Z" />
                                    <path class="cls-2" d="M38.84,27.46H28.44L1.05,60.7A5.06,5.06,0,0,0,.3,65.51a3.79,3.79,0,0,0,3.45,2.7H48.83L56,59.34H12.56Z" />
                                    <path class="cls-2" d="M100.34,27V56.8a3,3,0,0,1-3,3H72.55a3,3,0,0,1-3-3V15.88l-.1.1-8.9,11V59.8a9,9,0,0,0,9,9h30.79a9,9,0,0,0,9-9V15.89Z" />
                                    <path class="cls-2" d="M158.87,15.88h-33.4a9,9,0,0,0-9,9V68.8l9-11.12V27.88a3,3,0,0,1,3-3H151.6Z" />
                                    <polygon class="cls-2" points="171.67 57.93 171.67 15.88 162.67 15.88 162.67 68.96 162.77 68.96 171.67 57.93" />
                                </g>
                            </g>
                        </svg>
                    </a>
                </footer>
            </aside>
            <main>
                <div class="wfrepo">
                    <fff:FormLoader ID="ZuriFormContainer" runat="server" />
                    <asp:Literal ID="litCloseMessage" runat="server" />
                </div>
            </main>
        </section>
        <script src="/WFResources/Templates/js/templatescript.js"></script>
        <script>
            function retractMenu() {
                const page = getPage();
                closeMenu(page);
            }
        </script>
    </form>
</body>
</html>
