﻿function GetKeyCode(ev) {
    return ev.keyCode || ev.which;
}

//*--------------------------- Formatação de CPF ----------------------------------------*
function GetKeyCode(ev) {
    return ev.keyCode || ev.which;
}

function MaskCPF(src, intKeyCode) {
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            return false
        }
        else {
            var mascara = '###.###.###-##';
            var campo = src.value.length;
            var saida = mascara.substring(0, 1);
            var texto = mascara.substring(campo);
            if (texto.substring(0, 1) != saida) {
                src.value += texto.substring(0, 1);
            }
        }
    }
    else {
        return true
    }
}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de CNPJ ---------------------------------------*
function MaskCNPJ(src, intKeyCode) {
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            return false
        }
        else {
            var mascara = '##.###.###/####-##';
            var campo = src.value.length;
            var saida = mascara.substring(0, 1);
            var texto = mascara.substring(campo);
            if (texto.substring(0, 1) != saida) {
                src.value += texto.substring(0, 1);
            }
        }
    }
    else {
        return true
    }
}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de Datas --------------------------------------*
function MaskDate(objCampo, intKeyCode) {
    var isKeyCodeOk = false;
    var valor = objCampo.value;
    valor = valor.replace("/", "").replace("/", "");
    var intLengthValor = valor.length;
    if (parseInt(intKeyCode) == 13 ||
        parseInt(intKeyCode) == 8 || // Backspace
        parseInt(intKeyCode) == 9 || // Tab
        parseInt(intKeyCode) == 46 || // Delete
        parseInt(intKeyCode) == 37 || // Seta esquerda
        parseInt(intKeyCode) == 38 || // Seta para cima
        parseInt(intKeyCode) == 39 || // Seta direita
        parseInt(intKeyCode) == 40) // Seta para baixo
        return true;
    if ((parseInt(intKeyCode) >= 48) && (parseInt(intKeyCode) <= 57)) isKeyCodeOk = true;
    if (isKeyCodeOk) {
        if (intLengthValor > 4) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4);
        if (intLengthValor == 4) valor = valor.substring(0, 2) + "/" + valor.substring(2) + "/";
        if (intLengthValor == 3) valor = valor.substring(0, 2) + "/" + valor.substring(2);
        if (intLengthValor == 2) valor = valor + "/";
        objCampo.value = valor;
        if (intLengthValor == 8) return false;
        return true;
    }
    return false;
}

function MaskDateTime(objCampo, intKeyCode) {
    var isKeyCodeOk = false;
    var valor = objCampo.value;
    valor = valor.replace("/", "").replace("/", "").replace(" ", "").replace(":", "");
    var intLengthValor = valor.length;
    if (parseInt(intKeyCode) == 13 ||
        parseInt(intKeyCode) == 8 || // Backspace
        parseInt(intKeyCode) == 9 || // Tab
        parseInt(intKeyCode) == 46 || // Delete
        parseInt(intKeyCode) == 37 || // Seta esquerda
        parseInt(intKeyCode) == 38 || // Seta para cima
        parseInt(intKeyCode) == 39 || // Seta direita
        parseInt(intKeyCode) == 40) // Seta para baixo
        return true;
    if ((parseInt(intKeyCode) >= 48) && (parseInt(intKeyCode) <= 57)) isKeyCodeOk = true;
    if (isKeyCodeOk) {
        if (intLengthValor > 10) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4, 8) + " " + valor.substring(8, 10) + ":" + valor.substring(10);
        if (intLengthValor == 10) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4, 8) + " " + valor.substring(8) + ":";
        if (intLengthValor == 9) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4, 8) + " " + valor.substring(8);
        if (intLengthValor == 8) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4) + " ";
        if (intLengthValor > 4 && intLengthValor < 8) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4);
        if (intLengthValor == 4) valor = valor.substring(0, 2) + "/" + valor.substring(2) + "/";
        if (intLengthValor == 3) valor = valor.substring(0, 2) + "/" + valor.substring(2);
        if (intLengthValor == 2) valor = valor + "/";
        objCampo.value = valor;
        if (intLengthValor == 12) return false;
        return true;
    }
    return false;
}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de Números ------------------------------------*
function MaskNumber(objCampo, intKeyCode) {
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            return false
        }
        else {
            return true
        }
    }
    else {
        return true
    }
}
//*--------------------------------------------------------------------------------------*

documentall = document.all;

//*--------------------------- Formatação de Monetários R$ ---------------------------------*
function MaskCurrency(obj, e, p) {
    if (p == undefined) p = 2;
    var boolret = true;
    var intKeyCode = e.keyCode || e.which;
   
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            boolret = false;
        }
    }

    if (boolret == true) {
        var whichCode = intKeyCode;        
        /*
        Executa a formatação após o backspace nos navegadores !document.all
        */
        if (whichCode == 8) {
            /*
            Previne a ação padrão nos navegadores
            */
            if (e.preventDefault) { //standart browsers
                e.preventDefault();
            } else { // internet explorer
                e.returnValue = false;
            }
            var valor = obj.value;
            var x = valor.substring(0, valor.length - 1);
            obj.value = demaskvalue(x, true, p).formatCurrency(p);
            return false;
        }
        /*
        Executa o Formata Reais e faz o format currency novamente após o backspace
        */
        FormataReais(obj, '.', ',', e, p);
    }
    else {
        return false;
    }
} // end MaskCurrency

function formatamoney(c) {
    var t = this;
    if (c == undefined) c = 2;
    var p, d = (t = t.split("."))[1].substr(0, c);
    for (p = (t = t[0]).length; (p -= 3) >= 1;) {
        t = t.substr(0, p) + "." + t.substr(p);
    }
    return t + "," + d + Array(c + 1 - d.length).join(0);
}

String.prototype.formatCurrency = formatamoney

function demaskvalue(valor, currency, p) {
    /*
    * Se currency é false, retorna o valor sem apenas com os números. Se é true, os dois últimos caracteres são considerados as 
    * casas decimais
    */
    var val2 = '';
    var strCheck = '0123456789';
    var len = valor.length;
    var returnprefix = '0.';
    //returnprefix += p.join(0);

    if (len == 0) { return returnprefix + '0'.repeat(p); }

    if (currency == true) {
        /* Elimina os zeros à esquerda 
        * a variável  <i> passa a ser a localização do primeiro caractere após os zeros e 
        * val2 contém os caracteres (descontando os zeros à esquerda)
        */

        for (var i = 0; i < len; i++)
            if ((valor.charAt(i) != '0') && (valor.charAt(i) != ',')) break;

        for (; i < len; i++) {
            if (strCheck.indexOf(valor.charAt(i)) != -1) val2 += valor.charAt(i);
        }
        len = val2.length;
        if (len == 0) { return returnprefix + '0'.repeat(p); }

        if (len <= p) {
            return returnprefix + '0'.repeat(p - len) + val2;
        }

        var parte1 = val2.substring(0, val2.length - p);
        var parte2 = val2.substring(val2.length - p);
        var returnvalue = parte1 + "." + parte2;
        return returnvalue;

    }
    else {
        /* currency é false: retornamos os valores COM os zeros à esquerda, 
        * sem considerar os últimos 2 algarismos como casas decimais 
        */
        val3 = "";
        for (var k = 0; k < len; k++) {
            if (strCheck.indexOf(valor.charAt(k)) != -1) val3 += valor.charAt(k);
        }
        return val3;
    }
}

function backspace(obj, event) {
    /*
    Essa função basicamente altera o  backspace nos input com máscara reais para os navegadores IE e opera.
    O IE não detecta o keycode 8 no evento keypress, por isso, tratamos no keydown.
    Como o opera suporta o infame document.all, tratamos dele na mesma parte do código.
    */

    var whichCode = (window.Event) ? event.which : event.keyCode;
    if (whichCode == 8 && documentall) {
        var valor = obj.value;
        var x = valor.substring(0, valor.length - 1);
        var y = demaskvalue(x, true, 2).formatCurrency(2);

        obj.value = ""; //necessário para o opera
        obj.value += y;

        if (event.preventDefault) { //standart browsers
            event.preventDefault();
        } else { // internet explorer
            event.returnValue = false;
        }
        return false;

    } // end if		
} // end backspace

function FormataReais(fld, milSep, decSep, e, p) {
    var sep = 0;
    var key = '';
    var i = j = 0;
    var len = len2 = 0;
    var strCheck = '0123456789';
    var aux = aux2 = '';
    var whichCode = e.which || e.keyCode;
    
    if (whichCode == 0) return true;
    if (whichCode == 9) return true; //tecla tab
    if (whichCode == 13) return true; //tecla enter
    if (whichCode == 16) return true; //shift internet explorer
    if (whichCode == 17) return true; //control no internet explorer
    if (whichCode == 27) return true; //tecla esc
    if (whichCode == 34) return true; //tecla end
    if (whichCode == 35) return true; //tecla end
    if (whichCode == 36) return true; //tecla home
    if (whichCode == 8) return true; // Backspace
    if (whichCode == 46) return true; // Delete

    /*
    O trecho abaixo previne a ação padrão nos navegadores. Não estamos inserindo o caractere normalmente, mas via script
    */

    if (e.preventDefault) { //standart browsers
        e.preventDefault()
    } else { // internet explorer
        e.returnValue = false
    }

    var key = String.fromCharCode(whichCode);  // Valor para o código da Chave
    if (strCheck.indexOf(key) == -1) return false;  // Chave inválida

    /*
    Concatenamos ao value o keycode de key, se esse for um número
    */
    fld.value += key;

    var len = fld.value.length;
    var bodeaux = demaskvalue(fld.value, true, p).formatCurrency(p);
    fld.value = bodeaux;

    /*
    Essa parte da função tão somente move o cursor para o final no opera. Atualmente não existe como movê-lo no konqueror.
    */
    if (fld.createTextRange) {
        var range = fld.createTextRange();
        range.collapse(false);
        range.select();
    }
    else if (fld.setSelectionRange) {
        fld.focus();
        var length = fld.value.length;
        fld.setSelectionRange(length, length);
    }
    return false;

}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de Monetários US$ ---------------------------------*

function MaskCurrencyEN(obj, e, p) {
    if (p == undefined) p = 2;
    var boolret = true;
    var intKeyCode = e.keyCode || e.which;
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            boolret = false;
        }
    }

    if (boolret == true) {
        var whichCode = intKeyCode;
        /*
        Executa a formatação após o backspace nos navegadores !document.all
        */
        if (whichCode == 8) {
            /*
            Previne a ação padrão nos navegadores
            */
            if (e.preventDefault) { //standart browsers
                e.preventDefault();
            } else { // internet explorer
                e.returnValue = false;
            }
            var valor = obj.value;
            var x = valor.substring(0, valor.length - 1);
            obj.value = demaskvalueEN(x, true, p).formatCurrencyEN(p);
            return false;
        }
        FormataDolar(obj, '.', ',', e, p);
    }
    else {
        return false;
    }
} // end MaskCurrencyEN

function formatamoneyEN(c) {
    var t = this;
    if (c == undefined) c = 2;
    var p, d = (t = t.split(","))[1].substr(0, c);
    for (p = (t = t[0]).length; (p -= 3) >= 1;) {
        t = t.substr(0, p) + "," + t.substr(p);
    }
    return t + "." + d + Array(c + 1 - d.length).join(0);
}

String.prototype.formatCurrencyEN = formatamoneyEN

function demaskvalueEN(valor, currency, p) {
    /*
    * Se currency é false, retorna o valor sem apenas com os números. Se é true, os dois últimos caracteres são considerados as 
    * casas decimais
    */
    var val2 = '';
    var strCheck = '0123456789';
    var len = valor.length;
    var returnprefix = '0.';

    if (len == 0) { return returnprefix + '0'.repeat(p); }

    if (currency == true) {
        /* Elimina os zeros à esquerda 
        * a variável  <i> passa a ser a localização do primeiro caractere após os zeros e 
        * val2 contém os caracteres (descontando os zeros à esquerda)
        */

        for (var i = 0; i < len; i++)
            if ((valor.charAt(i) != '0') && (valor.charAt(i) != ',')) break;

        for (; i < len; i++) {
            if (strCheck.indexOf(valor.charAt(i)) != -1) val2 += valor.charAt(i);
        }

        len = val2.length;
        if (len == 0) { return returnprefix + '0'.repeat(p); }

        if (len <= p) {
            return returnprefix + '0'.repeat(p - len) + val2;
        }
        var parte1 = val2.substring(0, val2.length - p);
        var parte2 = val2.substring(val2.length - p);
        var returnvalue = parte1 + "," + parte2;
        return returnvalue;
    }
    else {
        /* currency é false: retornamos os valores COM os zeros à esquerda, 
        * sem considerar os últimos 2 algarismos como casas decimais 
        */
        val3 = "";
        for (var k = 0; k < len; k++) {
            if (strCheck.indexOf(valor.charAt(k)) != -1) val3 += valor.charAt(k);
        }
        return val3;
    }
}

function FormataDolar(fld, milSep, decSep, e, p) {
    var sep = 0;
    var key = '';
    var i = j = 0;
    var len = len2 = 0;
    var strCheck = '0123456789';
    var aux = aux2 = '';
    var whichCode = e.keyCode || e.which;

    if (whichCode == 0) return true;
    if (whichCode == 9) return true; //tecla tab
    if (whichCode == 13) return true; //tecla enter
    if (whichCode == 16) return true; //shift internet explorer
    if (whichCode == 17) return true; //control no internet explorer
    if (whichCode == 27) return true; //tecla esc
    if (whichCode == 34) return true; //tecla end
    if (whichCode == 35) return true; //tecla end
    if (whichCode == 36) return true; //tecla home
    if (whichCode == 8) return true; // Backspace
    if (whichCode == 46) return true; // Delete

    /*
    O trecho abaixo previne a ação padrão nos navegadores. Não estamos inserindo o caractere normalmente, mas via script
    */

    if (e.preventDefault) { //standart browsers
        e.preventDefault()
    } else { // internet explorer
        e.returnValue = false
    }

    var key = String.fromCharCode(whichCode);  // Valor para o código da Chave
    if (strCheck.indexOf(key) == -1) return false;  // Chave inválida

    /*
    Concatenamos ao value o keycode de key, se esse for um número
    */
    fld.value += key;

    var len = fld.value.length;
    var bodeaux = demaskvalueEN(fld.value, true, p).formatCurrencyEN(p);
    fld.value = bodeaux;

    /*
    Essa parte da função tão somente move o cursor para o final no opera. Atualmente não existe como movê-lo no konqueror.
    */
    if (fld.createTextRange) {
        var range = fld.createTextRange();
        range.collapse(false);
        range.select();
    }
    else if (fld.setSelectionRange) {
        fld.focus();
        var length = fld.value.length;
        fld.setSelectionRange(length, length);
    }
    return false;

}
function CheckValidation(vGroup) {
    var val = Page_ClientValidate(vGroup);

    for (var i = 0; i < Page_Validators.length; i++) {
        var valctrl = $("#" + Page_Validators[i].controltovalidate)
        if (valctrl.attr('vlControlName')) valctrl = $("#" + valctrl.attr('vlControlName'))
        valctrl.removeClass('controlValidationNOK');
    }
    if (!val) {
        for (var i = 0; i < Page_Validators.length; i++) {
            if (!Page_Validators[i].isvalid) {
                var valctrl = $("#" + Page_Validators[i].controltovalidate)
                if (valctrl.attr('vlControlName')) valctrl = $("#" + valctrl.attr('vlControlName'))
                valctrl.addClass('controlValidationNOK');
            }
        }
    }
    return val;
}
function CharacterLimit(checkcontrol, textmaxlength) {
    if (checkcontrol.value.length >= (textmaxlength - 1)) {
        checkcontrol.value = checkcontrol.value.substring(0, textmaxlength);
    }
}

function SetDateRange(checkcontrol, mincontrol, maxcontrol) {
    if (mincontrol != '') {
        var basedate = document.querySelector("[fieldname = '" + mincontrol + "']").value;
        if (basedate != '') checkcontrol.setAttribute('min', basedate);
    }
    if (maxcontrol != '') {
        var basedate = document.querySelector("[fieldname = '" + maxcontrol + "']").value;
        if (basedate != '') checkcontrol.setAttribute('max', basedate);
    }
}
function SetMask(controlAlias, controlMask) {
    $('[fieldname=' + controlAlias + ']').mask(controlMask);
}

var winRefreshControlName = '';
function OpenPopUp(popupaddress, pagetitle, width, height, controlname) {
    var ow = window.radopen(popupaddress, 'ChildDialog');
    ow.set_title(pagetitle);
    ow.setSize(width, height);
    winRefreshControlName = controlname;
    return false;
}

function UpdateChildList(sender, eventArgs) {
    __doPostBack(winRefreshControlName, '')
}

function gridRowDblClick(sender, eventArgs) {
    sender.get_masterTableView().editItem(eventArgs.get_itemIndexHierarchical());
}

function checkFileUploaded(fileCtrl, labelControl, emptyMessage, linkId) {
    if (fileCtrl.files.length > 0) {
        setTimeout(__doPostBack(linkId, ''));
    } else {
        $("#" + labelControl).text(emptyMessage);
    }
}

function CustomValidatorChanged(sender, eventArgs) {
    var item = eventArgs.get_item();
    document.querySelector("[vlControlSelector='" + sender._uniqueId + "']").value = item.get_value();
}

function UploadValidatorAdded(sender, eventArgs) {
    var ctrlName = sender._clientStateFieldID.replace('asyncUpload_ClientState', 'pnlcontrol')
    document.querySelector("[vlControlName='" + ctrlName + "']").value = eventArgs.get_fileName();
}

function UploadValidatorRemoved(sender, eventArgs) {
    var ctrlName = sender._clientStateFieldID.replace('asyncUpload_ClientState', 'pnlcontrol')
    document.querySelector("[vlControlName='" + ctrlName + "']").value = null;
}

function UpdateCBLValidator(sender) {
    var valCtrl = document.querySelector("[vlControlSelector='" + sender.id + "']")
    valCtrl.value = '';
    var options = sender.getElementsByTagName('input');
    for (var i = 0; i < options.length; i++) {
        if (options[i].checked) {
            valCtrl.value += options[i].value;
        }
    }
}
function ZFDDLLoadOnDemand(sender, eventArgs) {
    if (sender.get_items().get_count() == 0) {
        return;
    } else {
        sender.requestItems(sender.get_text(), true);
    }
}
function ZFACCLSelected(sender, eventArgs) {
    var valCtrl = document.querySelector("[vlControlSelector='" + sender._clientID + "']")
    valCtrl.value = '';
    if (eventArgs.get_sourceListBox()._clientID.endsWith('_selLeft')) {
        valCtrl.value = eventArgs.get_destinationListBox().get_items().get_count() + 1;
    } else {
        if (eventArgs.get_sourceListBox().get_items().get_count() > 1)
            valCtrl.value = eventArgs.get_sourceListBox().get_items().get_count() - 1;
    }
}
function SortGridColumns() {
    $('.sortable').each(function () {
        var $this = $(this);
        $this.append($this.find('.grid-module').get().sort(function (a, b) {
            return $(a).data('index') - $(b).data('index');
        }));
    });
}

//*--------------------------------------------------------------------------------------*
//*                       AUTO COMPLETE DROP DOWN LIST WIDGET                            *
$.widget("custom.acddl", {
    options: {
        updCtrl: ''
    },
    _create: function () {
        this.wrapper = $("<span>")
            .addClass("ac-ddl")
            .insertAfter(this.element);

        this.element.hide();
        this._createAutocomplete(this.options.updCtrl);
        this._createShowAllButton();
    },

    _createAutocomplete: function (ctrlUpdate) {
        var selected = this.element.children(":selected"),
            value = selected.val() ? selected.text() : "";
        var chgExec = '';
        if (ctrlUpdate) chgExec = "javascript:setTimeout('__doPostBack(\\'" + ctrlUpdate + "\\',\\'\\')', 0)"
        this.input = $("<input>")
            .appendTo(this.wrapper)
            .val(value)
            .attr("title", "")
            .attr("onblur", chgExec)
            .addClass("ac-ddl-input ui-widget ui-widget-content ui-state-default ui-corner-left")
            .autocomplete({
                delay: 0,
                minLength: 0,
                source: this._source.bind(this)
            })
            .tooltip({
                classes: {
                    "ui-tooltip": "ui-state-highlight"
                }
            });

        this._on(this.input, {
            autocompleteselect: function (event, ui) {
                ui.item.option.selected = true;
                this._trigger("select", event, {
                    item: ui.item.option
                });
            },

            autocompletechange: "_removeIfInvalid"
        });
    },

    _createShowAllButton: function () {
        var input = this.input,
            wasOpen = false;

        $("<a>")
            .attr("tabIndex", -1)
            .attr("title", "Show All Items")
            .tooltip()
            .appendTo(this.wrapper)
            .button({
                icons: {
                    primary: "ui-icon-triangle-1-s"
                },
                text: false
            })
            .removeClass("ui-corner-all")
            .addClass("ac-ddl-toggle ui-corner-right")
            .on("mousedown", function () {
                wasOpen = input.autocomplete("widget").is(":visible");
            })
            .on("click", function () {
                input.trigger("focus");

                // Close if already visible
                if (wasOpen) {
                    return;
                }

                // Pass empty string as value to search for, displaying all results
                input.autocomplete("search", "");
            });
    },

    _source: function (request, response) {
        var matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
        response(this.element.children("option").map(function () {
            var text = $(this).text();
            if (this.value && (!request.term || matcher.test(text)))
                return {
                    label: text,
                    value: text,
                    option: this
                };
        }));
    },

    _removeIfInvalid: function (event, ui) {

        // Selected an item, nothing to do
        if (ui.item) {
            return;
        }

        // Search for a match (case-insensitive)
        var value = this.input.val(),
            valueLowerCase = value.toLowerCase(),
            valid = false;
        this.element.children("option").each(function () {
            if ($(this).text().toLowerCase() === valueLowerCase) {
                this.selected = valid = true;
                return false;
            }
        });

        // Found a match, nothing to do
        if (valid) {
            return;
        }

        // Remove invalid value
        this.input
            .val("")
            .attr("title", value + " didn't match any item")
            .tooltip("open");
        this.element.val("");
        this._delay(function () {
            this.input.tooltip("close").attr("title", "");
        }, 2500);
        this.input.autocomplete("instance").term = "";
    },

    _destroy: function () {
        this.wrapper.remove();
        this.element.show();
    }
});
//*--------------------------------------------------------------------------------------*


