﻿var myEditor;
var currentControl;


OnClientLoad = function (editor) {
    myEditor = editor;
    updateDIVEvents(editor);
}

function turnDivControlsSelectable(content) {
    try {
        content.addEventListener("click", e => {
            const el = e.target;
            console.log(el);
            if (el.getAttribute("tipo") === "DIV") {
                const bounds = el.getBoundingClientRect();
                console.log(bounds);
                console.log(e.offsetX);
                console.log("limite a esquerda:", bounds.right - 40);
                console.log("limite a direita:", bounds.right);
                console.log(e.offsetY);
                console.log("limite abaixo:", bounds.y + 22);
                if ((e.offsetX >= (bounds.right - 40)) && (e.offsetY <= (bounds.y + 22)) && (e.offsetX <= bounds.right)) {
                    console.log("reconheça o click");

                    e.preventDefault();
                    e.stopImmediatePropagation();
                    select(el.outerHTML);

                }
            }
        });
    } catch (e) {
        console.log("ERROR: ", e);
    }
}
function updateDIVEvents(editor) {
    turnDivControlsSelectable(editor.get_contentArea());
}
function select(contrHtml) {
    if (contrHtml != '') {
        var idd, aId, fId, objName, mItemId, a, t;
        idd = ''; aId = ''; fId = '';
        objName = contrHtml.substring(contrHtml.indexOf(' id=') + 4);
        objName = objName.substring(0, objName.indexOf(' '));
        objName = objName.replace('"', '').replace('"', '');
        mItemId = contrHtml.substring(contrHtml.indexOf(' moditemid="') + 12);
        mItemId = mItemId.substring(0, mItemId.indexOf('"'));
        if (mItemId == '' || contrHtml.indexOf(' moditemid="') === -1) {
            return false;
        }
        t = contrHtml.substring(contrHtml.indexOf(' tipo="') + 7);
        t = t.substring(0, t.indexOf('"'));
        var queries = window.location.search.split(/[\?&]+/);
        if (queries != null && queries.length > 0) {
            for (var i = 0; i < queries.length; i++) {
                if (queries[i].substring(0, 2) == 'Id') { idd = queries[i].substring(3); }
                if (queries[i].substring(0, 6) == 'AREAID') { aId = queries[i].substring(7); }
                if (queries[i].substring(0, 6) == 'FormId') { fId = queries[i].substring(7); }
            }
        }
        myEditor.get_document().execCommand("Unselect", null, true);
        currentControl = objName;
        RefreshFieldConfig("OBJECTNAME=" + objName + "&MODITEMID=" + mItemId);
    }
    return false;
}
function OnClientSelectionChange(editor) {
    var selCtt = editor.getSelectionHtml();
    if (selCtt != '') {
        if (currentControl != GetSelectedControlId(selCtt)) {
            currentControl = GetSelectedControlId(selCtt);
            var identifier = GetSelectedIdentifier(selCtt);
            if (identifier != '') RefreshFieldConfig(identifier);
        }
    } else {
        currentControl = null;
    }
}

function OnClientPasteHtml(sender, args) {
    var commandName = args.get_commandName();
    var value = args.get_value();
    if (commandName == "InsertTable") {
        var div = document.createElement("DIV");
        Telerik.Web.UI.Editor.Utils.setElementInnerHtml(div, value);
        var table = div.firstChild;
        table.classList.add('unstyled');
        table.classList.add('form-table');
        args.set_value(div.innerHTML);
    }
}

function OnClientModeChange(editor, args) {
}
function AddHTMLBlock(EditorControl, HTMLBlock) {
    EditorControl.pasteHtml(HTMLBlock);
    currentControl = GetSelectedControlId(HTMLBlock);
    var identifier = GetSelectedIdentifier(HTMLBlock);
    if (identifier != '') RefreshFieldConfig(identifier);
}

function GetSelectedIdentifier(htmTag) {
    var ctrlId = GetSelectedControlId(htmTag);
    var modId = GetSelectedModuleId(htmTag);
    if (ctrlId != '' || modId != '') {
        return "OBJECTNAME=" + GetSelectedControlId(htmTag) + "&MODITEMID=" + GetSelectedModuleId(htmTag);
    } else {
        return '';
    }
}
function GetSelectedControlId(htmTag) {
    if (htmTag.startsWith("<img")) {
        var startPos = htmTag.indexOf(" id=\"");
        if (startPos > 0) {
            startPos = startPos + 5;
            var endPos = htmTag.indexOf("\"", startPos + 1);
            return htmTag.substring(startPos, endPos);
        }
    }
    return '';
}

function GetSelectedModuleId(htmTag) {
    if (htmTag.startsWith("<img")) {
        var startPos = htmTag.indexOf(" moditemid=\"");
        if (startPos > 0) {
            startPos = startPos + 12;
            var endPos = htmTag.indexOf("\"", startPos + 1);
            return htmTag.substring(startPos, endPos);
        }
    }
    return '';
}

function GetNewControlId(ControlName) {
    var intControlId = 0;
    var myHTML = myEditor.get_html();
    if (myHTML != '') {
        var strControls = new Array();
        strControls = myHTML.split('id="' + ControlName);
        for (var i = 1; i < strControls.length; i++) {
            var strUltimoControleId = strControls[i].split(" ")[0].split("p")[1];
            if (parseInt(intControlId) < parseInt(strUltimoControleId)) {
                intControlId = strUltimoControleId;
            }
        }
    }
    intControlId = parseInt(intControlId) + 1;
    return ControlName + '1p' + intControlId;
}

function RefreshFieldConfig(identifier) {
    postContentData('layoutUpdate', 'content', myEditor.get_html(), currentControl).then(
        function (data, status, jqXHR) {
            jqXHR.responseText = jqXHR.responseText.replaceAll('"', '');
            if (jqXHR.responseText != 'OK') {
                alert(jqXHR.responseText);
            } else {
                var idCtrl = document.getElementById("txtHidden");
                idCtrl.value = identifier;
                __doPostBack('btnRefreshFieldConfigs', '');
            };
        });
}
function OnContextTextChange(sender, eventArgs) {
    var identifier = document.getElementById("txtHidden").value.split('&')[0].split('=')[1];
    var fieldname = sender._uniqueId.split('$')[1].substring(3);
    postContentData('fieldUpdate', fieldname, sender.get_text(), identifier).then(
        function (data, status, jqXHR) {
            jqXHR.responseText = jqXHR.responseText.replaceAll('"', '');
            if (jqXHR.responseText != 'OK') {
                alert(jqXHR.responseText);
                document.getElementById(controlName).value = '';
                document.getElementById(controlName).focus();
            };
        });
}
function OnContextSelectionChange(sender, eventArgs) {
    var identifier = document.getElementById("txtHidden").value.split('&')[0].split('=')[1];
    var fieldname = sender._uniqueId.split('$')[1].substring(3);
    var item = eventArgs.get_item();
    postContentData('fieldUpdate', fieldname, item.get_value(), identifier).then(
        function (data, status, jqXHR) {
            jqXHR.responseText = jqXHR.responseText.replaceAll('"', '');
            if (jqXHR.responseText != 'OK') {
                alert(jqXHR.responseText);
                document.getElementById(controlName).value = '';
                document.getElementById(controlName).focus();
            };
        });
}
function UpdateFieldValue(updcontrol, fieldname, controlName, identifier) {
    postContentData('fieldUpdate', fieldname, updcontrol.value, identifier).then(
        function (data, status, jqXHR) {
            jqXHR.responseText = jqXHR.responseText.replaceAll('"', '');
            if (jqXHR.responseText != 'OK') {
                alert(jqXHR.responseText);
                document.getElementById(controlName).value = '';
                document.getElementById(controlName).focus();
            };
        });
}
function CheckNewAlias(updcontrol, fieldname, controlName, identifier, confirmMsg, postBackContext, currentAlias) {
    if (confirm(confirmMsg)) {
        postContentData('checkAlias', fieldname, updcontrol.value, identifier).then(
            function (data, status, jqXHR) {
                jqXHR.responseText = jqXHR.responseText.replaceAll('"', '');
                if (jqXHR.responseText != 'OK') {
                    alert(jqXHR.responseText);
                    document.getElementById(controlName).value = currentAlias;
                    document.getElementById(controlName).focus();
                } else {
                    setTimeout('__doPostBack(\' ' + postBackContext + '\',\'\')', 0);
                };
            });
    } else {
        document.getElementById(controlName).value = currentAlias;
    }
}

function postContentData(action, paramName, paramValue, controlName) {
    var frmIdCtrl = document.getElementById("hidFormId");
    var params = {};
    params['action'] = action;
    params['formId'] = frmIdCtrl.value;
    params['paramName'] = paramName;
    params['paramValue'] = paramValue;
    params['controlName'] = controlName;
    return $.ajax({
        type: "POST",
        url: "/api/formconfig/updateconfig/",
        data: JSON.stringify(params),
        contentType: "application/json; charset=utf-8",
        crossDomain: true,
        dataType: "json"
    });
}
function RefreshConfiguration() {
    __doPostBack('btnRefreshFieldConfigs', '');
}

function RefreshDSPanel(isFormula) {
    if (isFormula) {
        __doPostBack('btnRefreshFormulas', '');
    } else {
        __doPostBack('btnRefreshDataSources', '');
    }
}
function ToggleConfig() {
    var isopen = $("div.form-config").is(":visible");
    if (!isopen) {
        $("div.form-config").css({ display: "inline-block" });
        $("aside.sidebar").addClass("active");
    } else {
        $("div.form-config").css({ display: "none" });
    }
    return false;
}

function RefreshPage() {
    __doPostBack('lnkRefresh', '');
}

function RefreshToolbar() {
    __doPostBack('btnRefreshToolbar', '');
}

function OpenEditDataSource(formid, dsidentifier, pagetitle) {
    var ow = window.radopen('./Popups/DSConfiguration.aspx?FormId=' + formid + '&datasource=' + dsidentifier, 'EditDialog');
    ow.set_title(pagetitle);
    return false;
}
function OpenPopUp(popupaddress, pagetitle) {
    RefreshFieldConfig('');
    var ow = window.radopen(popupaddress, 'EditDialog');
    ow.set_title(pagetitle);
    return false;
}
