﻿<%@ WebService Language="vb" Class="WFFormsFormulas" %>
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.ComponentModel

<System.Web.Services.WebService(Namespace:="http://tempuri.org/")>
<System.Web.Services.WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)>
Public Class WFFormsFormulas
    Inherits System.Web.Services.WebService

    <WebMethod>
    Public Function Media(valor1 As String, valor2 As String, valor3 As String, valor4 As String, valor5 As String, valor6 As String) As String
        If (String.IsNullOrWhiteSpace(valor1) AndAlso String.IsNullOrWhiteSpace(valor2) AndAlso String.IsNullOrWhiteSpace(valor3) AndAlso
                        String.IsNullOrWhiteSpace(valor4) AndAlso String.IsNullOrWhiteSpace(valor5) AndAlso String.IsNullOrWhiteSpace(valor6)) Then Return String.Empty
        Dim d = 0.0
        Dim auxDbl = 0.0
        Dim divisor = 0
        If (Double.TryParse(valor1, auxDbl)) Then
            d += auxDbl
            divisor += 1
        End If
        If (Double.TryParse(valor2, auxDbl)) Then
            d += auxDbl
            divisor += 1
        End If
        If (Double.TryParse(valor3, auxDbl)) Then
            d += auxDbl
            divisor += 1
        End If
        If (Double.TryParse(valor4, auxDbl)) Then
            d += auxDbl
            divisor += 1
        End If
        If (Double.TryParse(valor5, auxDbl)) Then
            d += auxDbl
            divisor += 1
        End If
        If (Double.TryParse(valor6, auxDbl)) Then
            d += auxDbl
            divisor += 1
        End If
        If (divisor > 0) Then d /= divisor
        Return d.ToString()
    End Function

    <WebMethod>
    Public Function Somar(valor1 As String, valor2 As String, valor3 As String, valor4 As String, valor5 As String, valor6 As String) As String
        If (String.IsNullOrWhiteSpace(valor1) AndAlso String.IsNullOrWhiteSpace(valor2) AndAlso String.IsNullOrWhiteSpace(valor3) AndAlso
                        String.IsNullOrWhiteSpace(valor4) AndAlso String.IsNullOrWhiteSpace(valor5) AndAlso String.IsNullOrWhiteSpace(valor6)) Then Return String.Empty
        Dim d = 0.0
        Dim auxDbl = 0.0
        If (Double.TryParse(valor1, auxDbl)) Then d += auxDbl
        If (Double.TryParse(valor2, auxDbl)) Then d += auxDbl
        If (Double.TryParse(valor3, auxDbl)) Then d += auxDbl
        If (Double.TryParse(valor4, auxDbl)) Then d += auxDbl
        If (Double.TryParse(valor5, auxDbl)) Then d += auxDbl
        If (Double.TryParse(valor6, auxDbl)) Then d += auxDbl
        Return d.ToString()
    End Function

    <WebMethod>
    Public Function Subtrair(valor1 As String, valor2 As String, valor3 As String, valor4 As String, valor5 As String, valor6 As String) As String
        If (String.IsNullOrWhiteSpace(valor1) AndAlso String.IsNullOrWhiteSpace(valor2) AndAlso String.IsNullOrWhiteSpace(valor3) AndAlso
                        String.IsNullOrWhiteSpace(valor4) AndAlso String.IsNullOrWhiteSpace(valor5) AndAlso String.IsNullOrWhiteSpace(valor6)) Then Return String.Empty
        Dim d = 0.0
        Dim auxDbl = 0.0
        If (Double.TryParse(valor1, auxDbl)) Then d += auxDbl
        If (Double.TryParse(valor2, auxDbl)) Then d -= auxDbl
        If (Double.TryParse(valor3, auxDbl)) Then d -= auxDbl
        If (Double.TryParse(valor4, auxDbl)) Then d -= auxDbl
        If (Double.TryParse(valor5, auxDbl)) Then d -= auxDbl
        If (Double.TryParse(valor6, auxDbl)) Then d -= auxDbl
        Return d.ToString()
    End Function

    <WebMethod>
    Public Function Multiplicar(valor1 As String, valor2 As String, valor3 As String, valor4 As String, valor5 As String, valor6 As String) As String
        If (String.IsNullOrWhiteSpace(valor1) AndAlso String.IsNullOrWhiteSpace(valor2) AndAlso String.IsNullOrWhiteSpace(valor3) AndAlso
                        String.IsNullOrWhiteSpace(valor4) AndAlso String.IsNullOrWhiteSpace(valor5) AndAlso String.IsNullOrWhiteSpace(valor6)) Then Return String.Empty
        Dim d = 0.0
        Dim auxDbl = 0.0
        Dim foundValue = False
        Dim pularValor = "1"
        If (Double.TryParse(valor1, auxDbl)) Then
            foundValue = True
            d = auxDbl
        End If
        If (Double.TryParse(valor2, auxDbl)) Then
            If (foundValue) Then
                d *= auxDbl
            Else
                d = auxDbl
                foundValue = True
            End If
        End If
        If (Double.TryParse(valor3, auxDbl)) Then
            If (foundValue) Then
                d *= auxDbl
            Else
                d = auxDbl
                foundValue = True
            End If
        End If
        If (Double.TryParse(valor4, auxDbl)) Then
            If (foundValue) Then
                d *= auxDbl
            Else
                d = auxDbl
                foundValue = True
            End If
        End If
        If (Double.TryParse(valor5, auxDbl)) Then
            If (foundValue) Then
                d *= auxDbl
            Else
                d = auxDbl
                foundValue = True
            End If
        End If
        If (Double.TryParse(valor6, auxDbl)) Then
            If (foundValue) Then
                d *= auxDbl
            Else
                d = auxDbl
                foundValue = True
            End If
        End If
        Return d.ToString()
    End Function

    <WebMethod>
    Public Function Dividir(valor1 As String, valor2 As String) As String
        Dim d = 0.0
        Dim auxDbl = 0.0
        If (Double.TryParse(valor1, auxDbl)) Then d = auxDbl
        auxDbl = 0.0
        If (Double.TryParse(valor2, auxDbl) AndAlso auxDbl <> 0.0) Then
            d /= auxDbl
        Else
            Return String.Empty
        End If
        Return d.ToString("#,##0.00")
    End Function

    <WebMethod>
    Public Function CalcularDiasCorridos(dataInicial As DateTime, dataFinal As DateTime) As String
        If (dataInicial = DateTime.MinValue OrElse dataFinal = DateTime.MinValue) Then Return String.Empty
        Dim a = dataFinal - dataInicial
        Return Math.Floor(a.TotalDays).ToString()
    End Function

    <WebMethod>
    Public Function AdicionarHorasCorridas(dataInicial As DateTime, quantidadeHoras As String) As String
        If (dataInicial = DateTime.MinValue OrElse String.IsNullOrWhiteSpace(quantidadeHoras)) Then Return String.Empty
        Dim d = dataInicial
        Dim auxInt = 0
        Integer.TryParse(quantidadeHoras, auxInt)
        If (auxInt <> 0) Then d = d.AddHours(auxInt)
        Return d.ToString()
    End Function

    <WebMethod>
    Public Function AdicionarDiasCorridos(dataInicial As DateTime, quantidadeDias As String) As String
        If (dataInicial = DateTime.MinValue OrElse String.IsNullOrWhiteSpace(quantidadeDias)) Then Return String.Empty
        Dim d = dataInicial
        Dim auxInt = 0
        Integer.TryParse(quantidadeDias, auxInt)
        If (auxInt <> 0) Then d = d.AddDays(auxInt)
        Return d.ToString()
    End Function

    <WebMethod>
    Public Function CalcularDiasUteis(dataInicial As DateTime, dataFinal As DateTime, processoId As Integer) As String
        If (dataInicial = DateTime.MinValue OrElse dataInicial = New DateTime() OrElse dataFinal = DateTime.MinValue OrElse dataFinal = New DateTime()) Then Return String.Empty
        Dim auxD As DateTime
        Dim auxTotalDays = 0
        If (dataFinal.Date = dataInicial.Date) Then
            Return 0
        ElseIf (dataFinal.Date > dataInicial.Date) Then
            auxD = dataInicial.Date
            While (auxD.Date < dataFinal.Date)
                auxD = AddDiasUteis(auxD, 1, processoId)
                auxTotalDays += 1
            End While
        Else
            auxD = dataInicial.Date
            While (auxD.Date > dataFinal.Date)
                auxD = AddDiasUteis(auxD, -1, processoId)
                auxTotalDays -= 1
            End While
        End If
        Return auxTotalDays
    End Function

    <WebMethod>
    Public Function AdicionarHorasUteis(dataInicial As DateTime, quantidadeHoras As String, etapaItemId As Integer) As String
        If (dataInicial = DateTime.MinValue OrElse String.IsNullOrWhiteSpace(quantidadeHoras)) Then Return String.Empty
        Dim d = WebFoundations.WFWorkflow.Services.ItemProcesso.AddTimeSpan(etapaItemId, dataInicial, quantidadeHoras)
        If (d = DateTime.MinValue) Then Return dataInicial
        Return d
    End Function

    <WebMethod>
    Public Function AdicionarHorasUteisProcesso(dataInicial As DateTime, quantidadeHoras As String, processoId As Integer) As String
        If (dataInicial = DateTime.MinValue OrElse String.IsNullOrWhiteSpace(quantidadeHoras)) Then Return String.Empty
        Dim d = WebFoundations.WFWorkflow.Services.ItemProcesso.AddProcessTimeSpan(processoId, dataInicial, quantidadeHoras)
        If (d = DateTime.MinValue) Then Return dataInicial
        Return d
    End Function

    <WebMethod>
    Public Function AdicionarDiasUteis(dataInicial As DateTime, quantidadeDias As String, processoId As Integer) As String
        If (dataInicial = DateTime.MinValue OrElse String.IsNullOrWhiteSpace(quantidadeDias)) Then Return String.Empty
        Dim d = AddDiasUteis(dataInicial, quantidadeDias, processoId)
        Return d.ToString()
    End Function

    Private Function AddDiasUteis(dataInicial As DateTime, quantidadeDias As String, processoId As Integer) As Date
        Dim d = dataInicial
        Dim auxInt = 0
        Integer.TryParse(quantidadeDias, auxInt)
        If (auxInt <> 0) Then
            Dim dataCalc As New WebFoundations.WFWorkflow.Domain.CalcPrazo(processoId, 0, 1)
            dataCalc.BaseDate = d
            dataCalc.AddDays(auxInt)
            d = dataCalc.BaseDate
        End If
        Return d
    End Function

    <WebMethod>
    Public Function PorcentagemAte100(valorTotal As String, valorParcial As String) As String
        If (String.IsNullOrWhiteSpace(valorParcial) OrElse String.IsNullOrWhiteSpace(valorTotal)) Then Return String.Empty
        Dim p = 0.0
        Dim valorT = 0.0
        Double.TryParse(valorTotal, valorT)
        Dim valorP = 0.0
        Double.TryParse(valorParcial, valorP)
        If (valorT <> 0) Then p = (valorP / valorT) * 100
        Return p.ToString()
    End Function

    <WebMethod>
    Public Function PercentualAte100(valor As String, porcentagemAte100 As String) As String
        If (String.IsNullOrWhiteSpace(valor) OrElse String.IsNullOrWhiteSpace(porcentagemAte100)) Then Return String.Empty
        Dim v = 0.0
        Dim p = 0.0
        Dim auxDbl = 0.0
        Double.TryParse(valor, auxDbl)
        v = auxDbl
        auxDbl = 0.0
        Double.TryParse(porcentagemAte100, auxDbl)
        p = auxDbl / 100
        Return (v * p).ToString()
    End Function

    <WebMethod>
    Public Function ValorMaximo(valor1 As String, valor2 As String, valor3 As String, valor4 As String, valor5 As String, valor6 As String) As String
        If (String.IsNullOrWhiteSpace(valor1) AndAlso String.IsNullOrWhiteSpace(valor2) AndAlso String.IsNullOrWhiteSpace(valor3) AndAlso
                    String.IsNullOrWhiteSpace(valor4) AndAlso String.IsNullOrWhiteSpace(valor5) AndAlso String.IsNullOrWhiteSpace(valor6)) Then Return String.Empty
        Dim auxDouble = Double.MinValue
        Dim lstDouble = New List(Of Double)()
        If (Double.TryParse(valor1, auxDouble)) Then lstDouble.Add(auxDouble)
        If (Double.TryParse(valor2, auxDouble)) Then lstDouble.Add(auxDouble)
        If (Double.TryParse(valor3, auxDouble)) Then lstDouble.Add(auxDouble)
        If (Double.TryParse(valor4, auxDouble)) Then lstDouble.Add(auxDouble)
        If (Double.TryParse(valor5, auxDouble)) Then lstDouble.Add(auxDouble)
        If (Double.TryParse(valor6, auxDouble)) Then lstDouble.Add(auxDouble)
        If (Not lstDouble.Any()) Then Return 0D
        Return lstDouble.OrderByDescending(Function(x) x).FirstOrDefault().ToString()
    End Function
    <WebMethod>
    Public Function ReplicaValorText(valor As String) As String
        Return valor.Replace("þ", "; ")
    End Function
    <WebMethod>
    Public Function Concatenar(valor1 As String, valor2 As String, valor3 As String, valor4 As String, valor5 As String, valor6 As String) As String
        valor1 = If(String.IsNullOrWhiteSpace(valor1), valor1, valor1.Replace(";", ","))
        valor2 = If(String.IsNullOrWhiteSpace(valor2), valor2, valor2.Replace(";", ","))
        valor3 = If(String.IsNullOrWhiteSpace(valor3), valor3, valor3.Replace(";", ","))
        valor4 = If(String.IsNullOrWhiteSpace(valor4), valor4, valor4.Replace(";", ","))
        valor5 = If(String.IsNullOrWhiteSpace(valor5), valor5, valor5.Replace(";", ","))
        valor6 = If(String.IsNullOrWhiteSpace(valor6), valor6, valor6.Replace(";", ","))
        Return String.Concat(valor1, valor2, valor3, valor4, valor5, valor6)
    End Function
End Class
