﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="ZuriReport.ascx.vb" Inherits="Zuri.Forms.UI.ZuriReport" %>
<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<fff:FormDataController ID="fdcDataControl" runat="server" />

<asp:Panel ID="pnlTitle" runat="server">
    <h1 class="mb-2">
        <b>
            <asp:Literal ID="litTitle" runat="server" />
        </b>
    </h1>
</asp:Panel>
<asp:PlaceHolder ID="phReportScript" runat="server">
    <script src="/WFResources/FormsWeb/Scripts/ZuriReports.Scripts.js"></script>
    <link href="/WFResources/FormsWeb/Styles/ZuriReports.css" rel="stylesheet" />
</asp:PlaceHolder>

<asp:Panel ID="pnlFilters" runat="server">
    <div>
        <asp:PlaceHolder ID="phFilters" runat="server" />
        <div style="text-align: center;">
            <asp:Button ID="btnsearch" Style="min-width: 186px;" runat="server" />
        </div>
    </div>
</asp:Panel>
<asp:Panel ID="pnlCharts" CssClass="reportsDashboard" runat="server">
    <asp:PlaceHolder ID="phCharts" runat="server" />
</asp:Panel>
<telerik:RadWindowManager ID="PopUpWindows" runat="server">
    <Windows>
        <telerik:RadWindow ID="ReportDialog" runat="server" Behaviors="Close,Move,Reload,Resize,Maximize" VisibleStatusbar="false"
            Width="1024px" OnClientClose="UpdateReportList" Height="768px" ReloadOnShow="true" Modal="true" />
    </Windows>
</telerik:RadWindowManager>

<asp:Panel ID="pnlGrid" runat="server">
    <asp:Panel ID="pnlAdd" Visible="false" runat="server">
        <div style="text-align: center;">
            <section class="wfreport-actions">
                <asp:Button ID="btnAdd" CssClass="wfreport-action add" runat="server" />
            </section>
        </div>
    </asp:Panel>
    <asp:Panel ID="pnlFormEdit" Visible="false" runat="server">
        <fff:FormLoader ID="flFormEdit" Visible="false" runat="server" />
    </asp:Panel>
    <telerik:RadGrid runat="server" ID="grdItems" AutoGenerateColumns="false" AllowMultiRowSelection="true">
        <MasterTableView>
            <Columns>
                <telerik:GridTemplateColumn ItemStyle-Width="40px" UniqueName="VIEWCTRL">
                    <ItemTemplate>
                        <asp:HyperLink ID="lnkView" runat="server" ImageUrl="~/WFResources/Common/Images/Icons/view.png" />
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn ItemStyle-Width="40px" UniqueName="EDTCTRL">
                    <ItemTemplate>
                        <asp:ImageButton ID="btnEdit" ImageUrl="~/WFResources/Common/Images/Icons/edit.png" runat="server" />
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn ItemStyle-Width="40px" UniqueName="DELCTRL">
                    <ItemTemplate>
                        <asp:ImageButton ID="btnDel" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" />
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>
        </MasterTableView>
        <ClientSettings AllowRowsDragDrop="false" AllowColumnsReorder="false" ReorderColumnsOnClient="false">
            <Selecting AllowRowSelect="True" EnableDragToSelectRows="false" />
            <Scrolling AllowScroll="false" UseStaticHeaders="true" />
        </ClientSettings>
    </telerik:RadGrid>
    <asp:LinkButton ID="lnkRefresh" Style="display: none" runat="server" />
    <section class="wfreport-actions actions">
        <asp:Button CausesValidation="false" CssClass="wfreport-action csv" ID="btnExportCSV" runat="server" />
        <asp:Button CausesValidation="false" CssClass="wfreport-action xls" ID="btnExportXLS" runat="server" />
    </section>
</asp:Panel>
