﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="ZuriReportChart.ascx.vb" Inherits="Zuri.Forms.UI.ZuriReportChart" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Repeater ID="rptCards" Visible="false" runat="server">
    <ItemTemplate>
        <asp:Panel ID="pnlCard" CssClass="reportChart" runat="server">
            <div style="display: table-cell; vertical-align: middle;">
                <div>
                    <asp:Label ID="lblTitle" CssClass="cardTitle" runat="server" />
                </div>
                <div>
                    <asp:Label ID="lblGroupName" CssClass="cardGroupName" runat="server" />
                </div>
                <div>
                    <asp:Label ID="lblValue" CssClass="cardValue" runat="server" />
                </div>
            </div>
        </asp:Panel>
    </ItemTemplate>
</asp:Repeater>
<asp:Panel ID="pnlTable" CssClass="reportChart" Visible="false" runat="server">
    <asp:Repeater ID="rptTable" runat="server">
        <HeaderTemplate>
            <table>
                <tr>
                    <td colspan="2">
                        <asp:Label ID="lblTitle" CssClass="tableTitle" runat="server" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="lblName" CssClass="tableSubTitle" runat="server" /></td>
                    <td>
                        <asp:Label ID="lblValue" CssClass="tableSubTitle" runat="server" /></td>
                </tr>
        </HeaderTemplate>
        <FooterTemplate>
            </table>
        </FooterTemplate>
        <ItemTemplate>
            <tr>
                <td>
                    <asp:Label ID="lblGroupName" CssClass="tableGroupName" runat="server" /></td>
                <td>
                    <asp:Label ID="lblValue" CssClass="tableValue" runat="server" /></td>
            </tr>
        </ItemTemplate>
    </asp:Repeater>
</asp:Panel>
<asp:Panel ID="pnlChart" CssClass="reportChart" Visible="false" runat="server">
    <telerik:RadHtmlChart runat="server" ID="chtReport" Visible="true">
        <ChartTitle>
            <Appearance Position="Top" />
        </ChartTitle>
        <PlotArea>
            <XAxis>
                <MinorGridLines Visible="false" />
                <MajorGridLines Visible="false" />
            </XAxis>
            <YAxis>
                <MinorGridLines Visible="false" />
            </YAxis>
        </PlotArea>
    </telerik:RadHtmlChart>
</asp:Panel>
