﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="FormTest.aspx.vb" Inherits="Zuri.Forms.UI.FormTest" %>

<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>
<%@ Register Src="~/WFAdmin/ZuriForms/Tests/FormTestConfig.ascx" TagPrefix="uc1" TagName="FormTestConfig" %>

<!DOCTYPE html>
<html lang="<%= GetRegionalization() %>">
<head runat="server">
    <title></title>
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <meta http-equiv="pragma" content="no-cache">
    <base target="_self">
    <link href="/theme/styles" rel="stylesheet" type="text/css" />
    <link rel="manifest" href="/manifest.webmanifest" crossorigin="use-credentials">
    <link rel="shortcut icon" href="/favicon.ico?v=2" type="image/x-icon" />
    <script src="/theme/scripts"></script>
    <script type="text/javascript">
        function GetRadWindow() {
            var oWindow = null;
            try {
                if (window.radWindow) oWindow = window.radWindow; //Will work in Moz in all cases, including clasic dialog
                else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;//IE (and Moz az well)
            } catch (error) { }
            return oWindow;
        }
        function CancelEdit() {
            try {
                var w = GetRadWindow();
                if (w) {
                    w.Close();
                } else {
                    w = window;
                    if (w && w.close) { w.close(); }
                }
            } catch (error) { }
        }
        $(document).ready(function () {
            $("body").removeClass("loading");
        });
    </script>
    <style>
        .puberror {
            color: red;
        }

        .pubsuccess {
            color: darkgreen;
        }

        .pubwarning {
            color: orange;
        }

        .pubmessage {
            color: darkblue;
        }

        .pubconfirm {
            color: orange;
            text-decoration: underline;
        }
    </style>
</head>
<body id="collapsable-page" class="new-template loading">
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server" AsyncPostBackTimeout="1200" />
        <div style="padding: 1em 24px;">
            <uc1:FormTestConfig runat="server" ID="FormTestConfig" />
            <asp:PlaceHolder ID="phPendencies" runat="server">
                <h3>
                    <asp:Literal ID="lblTitle" runat="server" /></h3>
                <div class="CompileActions">
                    <h4>
                        <asp:Literal ID="lblActions" runat="server" /></h4>
                    <asp:Repeater ID="rptActions" runat="server">
                        <HeaderTemplate>
                            <ul>
                        </HeaderTemplate>
                        <FooterTemplate></ul></FooterTemplate>
                        <ItemTemplate>
                            <li>
                                <asp:Label ID="lblActionItem" runat="server" /></li>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
            </asp:PlaceHolder>
            <fff:FormLoader ID="TestForm" runat="server" />
            <asp:PlaceHolder ID="phresult" runat="server">
                <h3>
                    <asp:Literal ID="resulttitle" runat="server" /></h3>
                <fieldset>
                    <legend>
                        <asp:Literal ID="lblTableName" runat="server" /></legend>
                    <pre><asp:Literal ID="litContent" runat="server" /></pre>
                </fieldset>
                <section class="actions">
                    <asp:Button ID="btnAgain" Width="200px" runat="server" />
                    &nbsp; &nbsp;
                    <asp:Button ID="btnClose" Width="200px" runat="server" />
                </section>
            </asp:PlaceHolder>
        </div>
    </form>
</body>
</html>
