﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Formularios.aspx.vb" Inherits="Zuri.Forms.UI.Formularios" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';


        var selectedArea = function () { return document.getElementById('<%=SelectedAreaId.ClientID%>').value; };
        var postbackHidden = '<%=PostBackHidden.ClientID%>';
        var msgSelectAForm = '<%=SelectAFormMessage%>'
        var msgConfirmDelete = '<%=ConfirmDeleteMessage%>';

        function postBackSelection(actionName) {
            var hiddenField = $get(postbackHidden);
            if (hiddenField) {
                hiddenField.value = actionName + '-' + MySelectedItem;
                __doPostBack(postbackHidden, '');
            }

        }
        function editForm() {
            if (MySelectedItem) {
                openEditor(MySelectedItem);
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }

        function openTest() {
            var url = "Tests/FormTest.aspx?AreaId=" + selectedArea();
            if (MySelectedItem) url = "Tests/FormTest.aspx?VIEWCURRENT=true&FormId=" + MySelectedItem;
            var ww = 800, wh = 600;
            var m = 10;
            if (screen) {
                ww = Math.floor(Math.min(1600, Math.max(ww, screen.availWidth * .9)));
                wh = Math.floor(Math.min(wh, screen.availHeight * .9));
                m = Math.floor(Math.max(m, Math.min(screen.availHeight, screen.availWidth) * .05));
                console.log(ww, wh, m);
            }
            var w;
            try {
                var features = 'resizable=1,directories=0,toolbar=0,scrollbars,status,menubar=0,location,personalbar=0,dependent,top=' + m + ',left=' + m + ',width=' + ww + ',height=' + wh;
                console.log(features);
                w = window.open(url, "formstest", features)
            } catch (error) {
                console.log("openPreview", error);
            } finally {
                if (w && w.focus) {
                    w.focus();
                } else {
                    alert("Não foi possível abrir a janela de teste do formulário. Verifique se o browser está bloqueando popups.");
                }
            }
            return false;
        }


        function openEditor(item, useTab) {
            var ww = 800; var wh = 600; if (screen) { ww = screen.availWidth; wh = screen.availHeight; }
            var url = "?AREAID=" + selectedArea();
            if (item) {
                url = "Editor/MainEditor.aspx" + url + "&Id=" + item + "&FormId=" + item;
            } else {
                url = "FormEdit.aspx" + url;
            }
            if (useTab == true) {
                window.open(url, '_blank').focus();
            } else {
                var w;
                try {
                    w = window.open(url, 'formsdesigner', 'resizable=1,directories=0,toolbar=0,scrollbars=1,status=0,menubar=0,location=0,top=0,left=0,width=' + ww + ',height=' + wh);
                } catch (error) {
                    console.log("openEditor", error);
                } finally {
                    if (w && w.focus) {
                        w.focus();
                        w.moveTo(0, 0);
                        w.resizeTo(ww, wh);
                    } else {
                        alert("Não foi possível abrir a janela de edição de formulários. Verifique se o browser está bloqueando popups.")
                    }
                }
            }
        }

        function checkDelete() {
            if (MySelectedItem) {
                if (confirm(msgConfirmDelete)) {
                    postBackSelection('DELETE')
                };
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }

        function refreshGrid() {
            postBackSelection('REFRESH');
            return false;
        }

        function showExportForm() {
            if (MySelectedItem) {
                postBackSelection('EXPORT');
            } else {
                alert(msgSelectAForm);
            }
            return false;
        }

        function showImportForm() {
            window.radopen("FormImport.aspx?AREAID=" + selectedArea(), "ImportDialog");
            return false;
        }

        function downloadForm(url) {
            document.getElementById('downloadFrame').src = url;
        };
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <a href="#" class="add" onclick="return openEditor();">
                <asp:Literal ID="lnkadd" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="edit" onclick="return editForm();">
                <asp:Literal ID="lnkconfig" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="test" onclick="return openTest();">
                <asp:Literal ID="lnktest" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="delete" onclick="return checkDelete();">
                <asp:Literal ID="lnkdelete" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="refresh" onclick="return refreshGrid();">
                <asp:Literal ID="lnkrefresh" runat="server" />
            </a>
        </li>
        <li style="display: none;">
            <asp:LinkButton ID="lnkexport" CssClass="export" runat="server" />
        </li>
        <li>
            <a href="#" class="download" onclick="return showExportForm();">
                <asp:Literal ID="lnkdownload" runat="server" />
            </a>
        </li>
        <li>
            <a href="#" class="upload" onclick="return showImportForm();">
                <asp:Literal ID="lnkupload" runat="server" />
            </a>
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
    <iframe id="downloadFrame" style="display: none;"></iframe>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:WFPagePicker ID="portalpicker" runat="server" width="199" AddSelect="false" ForceCheckEvenForSiteAdmin="true"
            AdminMode="true" AutoSelectLast="true" ShowArea="true" ShowPage="false" NoLabels="false" />
        <div>
            <asp:Label ID="lblName" runat="server" />
            <asp:TextBox ID="txtName" runat="server" />
        </div>
    </div>
    <asp:Button ID="btnbuscar" runat="server" ValidationGroup="SEARCH" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:RadGrid ID="grdFormulario" CssClass="wfforms-list" runat="server" AutoGenerateColumns="false" AllowSorting="True" GridLines="None" AllowPaging="True" PageSize="15">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn HeaderText="" UniqueName="PUBLISHED" HeaderStyle-Width="40px" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle">
                            <ItemTemplate>
                                <asp:Image ID="imgPublished" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Titulo" UniqueName="Titulo" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridBoundColumn DataField="Apelido" UniqueName="Apelido" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridTemplateColumn UniqueName="Editor" ItemStyle-HorizontalAlign="center">
                            <ItemTemplate>
                                <asp:Label ID="lblEditor" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="DataPublicacao" UniqueName="DataPublicacao" ItemStyle-HorizontalAlign="center" />
                        <telerik:GridTemplateColumn UniqueName="Publisher" ItemStyle-HorizontalAlign="center">
                            <ItemTemplate>
                                <asp:Label ID="lblPublisher" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn UniqueName="Version" ItemStyle-HorizontalAlign="center">
                            <ItemTemplate>
                                <asp:Label ID="lblVersion" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnHide="false" Selecting-AllowRowSelect="true"
                    Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Pages" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server" />
            <asp:HiddenField ID="SelectedAreaId" runat="server" />
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>

    <wff:WindowManager ID="EditWindow" runat="server">
        <windows>
            <telerik:RadWindow ID="ExportDialog" runat="server" Height="450px" Width="800px" ReloadOnShow="true" Modal="true" />
            <telerik:RadWindow ID="ImportDialog" runat="server" Height="450px" Width="800px" ReloadOnShow="true" Modal="true" />
        </windows>
    </wff:WindowManager>
</asp:Content>

