﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="FormImport.aspx.vb" Inherits="Zuri.Forms.UI.FormImport" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <script type="text/javascript">
        function GetRadWindow() {
            var oWindow = null;
            try {
                if (window.radWindow) oWindow = window.radWindow; //Will work in Moz in all cases, including clasic dialog
                else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;//IE (and Moz az well)
            } catch (error) { }
            return oWindow;
        }

        function ParentOpenEditor(formId, useTab) {
            try {
                var w = GetRadWindow();
                if (w) {
                    w.BrowserWindow.openEditor(formId, useTab);
                    w.Close();
                } else {
                    w = window;
                    if (w) {
                        var o = w.opener;
                        if (o && o.openEditor) {
                            try {
                                o.openEditor(formId, useTab);
                            } catch (error) { }
                        }
                        if (w && w.close) { w.close(); }
                    }
                }
            } catch (error) { }
        }
    </script>
    <style>
        .ContentLine {
            text-align: center;
            display: inline-flex !important;
            width: 100%;
        }

        .ContentTitle {
            font-weight: bold;
            width: 50% !important;
            text-align: right;
        }

        .ContentText {
            width: 50% !important;
            text-align: left;
            padding-left: 5px !important;
            padding-top: 3px !important;
        }
    </style>
    <asp:Panel ID="pnlselecao" runat="server" CssClass="fields no-columns">
        <label>
            <asp:Label ID="lbldestino" runat="server" />
            <asp:Label ID="lblarea" runat="server" />
        </label>
        <label>
            <asp:Label ID="lblcarregue" runat="server" />
            <telerik:RadAsyncUpload ID="asyncUpload" OnClientFileUploaded="FileUploadCompleted" UploadedFilesRendering="BelowFileInput"
                MaxFileInputsCount="1" PersistConfiguration="True" runat="server" />
            <asp:LinkButton ID="lnkUploaded" runat="server" />
        </label>
    </asp:Panel>
    <asp:Panel ID="pnlUpdate" Visible="false" runat="server" CssClass="fields no-columns">
        <div class="ContentLine">
            <asp:Label ID="lbldestUpd" CssClass="ContentTitle" runat="server" />
            <asp:Label ID="lblareaUpd" CssClass="ContentText" runat="server" />
        </div>
        <div class="ContentLine">
            <asp:Label ID="foundForm" CssClass="ContentTitle" runat="server" />
            <asp:Label ID="formName" CssClass="ContentText" runat="server" />
        </div>
        <div class="ContentLine">
            <asp:Label ID="foundAlias" CssClass="ContentTitle" runat="server" />
            <asp:Label ID="formAlias" CssClass="ContentText" runat="server" />
        </div>
        <div class="ContentLine">
            <asp:Label ID="lblupdate" Style="font-weight: bold" runat="server" />
        </div>
    </asp:Panel>
    <asp:Panel ID="pnlMapping" Visible="false" runat="server">
        <table cellspacing="0" cellpadding="0" width="100%" border="0" class="unstyled">
            <tr>
                <td>
                    <asp:Label ID="lblDestMapping" runat="server" /></td>
                <td>
                    <asp:Label ID="lblareaMapping" runat="server" /></td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblImpFile" runat="server" /></td>
                <td>
                    <asp:Label ID="lblFileName" runat="server" /></td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblFormTitle" runat="server" /></td>
                <td>
                    <asp:Label ID="lblimpFormName" runat="server" />
                    <asp:RequiredFieldValidator ID="reqFileName" runat="server" ControlToValidate="txtImpFormName" ErrorMessage="*" Display="Dynamic" />
                    <asp:TextBox ID="txtImpFormName" Width="100%" runat="server" />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblFormAlias" runat="server" /></td>
                <td>
                    <asp:Label ID="lblimpFormAlias" runat="server" />
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="txtImpFormAlias" ErrorMessage="*" Display="Dynamic" />
                    <asp:TextBox ID="txtImpFormAlias" Width="100%" runat="server" />
                    <asp:RegularExpressionValidator ID="valAlias" runat="server" ControlToValidate="txtImpFormAlias" Display="Dynamic"
                        ValidationExpression="^[a-zA-Z][a-zA-Z0-9_]{2,29}$">
                    </asp:RegularExpressionValidator>
                </td>
            </tr>
            <asp:PlaceHolder ID="phMapping" runat="server">
                <tr>
                    <td colspan="2" style="font-weight: bold; text-align: center">
                        <asp:Label ID="lblmapeamento" runat="server" /></td>
                </tr>
                <asp:Repeater ID="rptMapeamento" runat="server">
                    <ItemTemplate>
                        <tr>
                            <td>
                                <asp:Label ID="lblRoleName" runat="server" />:
                                <asp:HiddenField ID="hidRoleId" runat="server" />
                                <asp:HiddenField ID="hidRoleGUID" runat="server" />
                            </td>
                            <td>
                                <asp:DropDownList ID="ddlRoles" runat="server" />
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </asp:PlaceHolder>
        </table>
    </asp:Panel>
    <section class="actions">
        <asp:Button ID="btnUpdateYes" Visible="false" runat="server" CssClass="button" />
        <asp:Button ID="btnUpdateNo" Visible="false" runat="server" CssClass="button" />
        <asp:Button ID="btnImport" Visible="false" runat="server" CssClass="button" />
        <input id="btncancelimp" type="button" class="button" runat="server" />
    </section>
</asp:Content>
