﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="MainEditor.aspx.vb" Inherits="Zuri.Forms.UI.MainEditor" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<%@ Register Src="~/WFAdmin/TagHeadAdmin.ascx" TagPrefix="wf" TagName="TagHeadAdmin" %>
<%@ Register Src="~/WFAdmin/ZuriForms/Editor/Controls/ConfigFrame.ascx" TagPrefix="wf" TagName="ConfigFrame" %>
<%@ Register Src="~/WFAdmin/ZuriForms/Editor/Controls/DataFrame.ascx" TagPrefix="wf" TagName="DataFrame" %>
<%@ Register Src="~/WFAdmin/ZuriForms/Editor/Controls/FormSettings.ascx" TagPrefix="fs" TagName="FormSettings" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="format-detection" content="telephone=no" />
    <meta http-equiv="pragma" content="no-cache" />
    <base target="_self" />
    <wf:TagHeadAdmin runat="server" ID="TagHeadAdmin" />
    <script type="text/javascript" src="/WFResources/FormsWeb/Scripts/FormEditorScript.js"></script>
    <asp:PlaceHolder ID="phStyles" runat="server" />
    <style>
        div[moditemid] {
            position: relative;
            padding: 16px;
            border-radius: 4px;
            resize: both;
            overflow: auto;
            border:gray 1px dotted;
            min-height:25px;
            width:99%;

        }
        div[moditemid]:before {
             position: absolute;
             content: "\2148";
             right: 2px;
             top: 2px;
             width: 20px;
             height: 20px;
             font-size: 14px;
             color: white;
             background-color: #286c83;
             display: flex;
             align-items: center;
             justify-content: center;
             border-radius: 50%;
        }

    </style>
</head>
<body class="wf-designer forms-designer">
    <form runat="server">
        <asp:ScriptManager runat="server" />
        <div style="display: none">
            <asp:LinkButton ID="lnkRefresh" ClientIDMode="Static" runat="server">RefreshPage</asp:LinkButton>
        </div>
        <header>
            <div class="logo-container">
                <svg xmlns="http://www.w3.org/2000/svg" width="53" height="48" viewBox="0 0 53 48" fill="none">
                    <path d="M9.5 0.5H49.5L50.5 8.5H3L9.5 0.5Z" fill="#00ABF8" />
                    <path d="M40.7687 8.31458L50.5001 8.5005L26.9858 36.989L17.7666 36.8128L40.7687 8.31458Z" fill="#00ABF8" />
                    <path d="M52 5C51.3937 7.42536 50.5 9.5 48.5 9.5C46.8431 9.5 46 6.433 46 4.5C46 2.567 47.8431 0.5 49.5 0.5C51.1569 0.5 52.5 3 52 5Z" fill="#00ABF8" />
                    <path d="M50.5 39H1.90524L3 47H44L50.5 39Z" fill="white" />
                    <path d="M25.0021 10.6837L34.7335 10.8696L11.2192 39.3581L2.00003 39.182L25.0021 10.6837Z" fill="white" />
                    <path d="M0.443981 42.5632C0.994062 40.1316 2.5 38.4996 3.72558 38.0262C5.19703 37.4579 6.13989 41.0664 6.16152 42.9993C6.18316 44.9321 4.45164 47.0187 2.87433 47.0363C1.29702 47.054 -0.00962732 44.5685 0.443981 42.5632Z" fill="white" />
                </svg>
                <h1>
                    <asp:Literal ID="ltTitle" runat="server" />
                </h1>
            </div>
            <h2 id="form-title">
                <asp:Literal ID="ltName" runat="server" /></h2>
            <menu type="toolbar" id="toolbar">
                <li class="formulas">
                    <input type="radio" name="toolgroup" id="toolgroup-formula" checked="checked" />
                    <label for="toolgroup-formula">
                        <asp:Literal ID="ltFormulas" runat="server" Text="Fórmulas" /></label>
                    <div class="content">
                        <asp:HyperLink ID="lnkInsertFormula" CssClass="add" runat="server" Text="Adicionar" />
                        <asp:UpdatePanel ID="pnlFormulas" class="data-sources" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <wf:DataFrame ID="formulasFrame" runat="server" IsFormulaContent="true" />
                                <asp:Button ID="btnRefreshFormulas" runat="server" Style="display: none;" />
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </div>
                </li>
                <li class="data">
                    <input type="radio" name="toolgroup" id="toolgroup-data" />
                    <label for="toolgroup-data">
                        <asp:Literal ID="ltData" runat="server" Text="Dados" /></label>
                    <div class="content">
                        <asp:HyperLink ID="lnkInsertData" CssClass="add" runat="server" Text="Adicionar" />
                        <asp:UpdatePanel ID="pnlDataSources" class="data-sources" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <wf:DataFrame ID="dataSourcesFrame" runat="server" />
                                <asp:Button ID="btnRefreshDataSources" runat="server" Style="display: none;" />
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </div>
                </li>
            </menu>
        </header>
        <main>
            <div style="width: 97%; height: 99%">
                <telerik:RadEditor runat="server" CssClass="maineditor" ID="HTMLContent" Width="100%" Height="100%" />
            </div>
            <asp:HiddenField ID="hidFormId" ClientIDMode="Static" runat="server" />
            <asp:PlaceHolder ID="phEditorScripts" runat="server" />
        </main>
        <aside class="sidepanel props">
            <asp:UpdatePanel ID="pnlFieldConfigs" runat="server" UpdateMode="Conditional">
                <ContentTemplate>
                    <wf:ConfigFrame ClientIDMode="Static" name="cFrame" runat="server" ID="ConfigFrame" />
                    <asp:Button ID="btnRefreshFieldConfigs" runat="server" Style="display: none;" />
                </ContentTemplate>
            </asp:UpdatePanel>
        </aside>
        <asp:UpdatePanel runat="server" ID="pnlToolbar" UpdateMode="Conditional">
            <ContentTemplate>
                <aside class="sidebar form-info">
                    <menu>
                        <li class="activate">
                            <asp:LinkButton ID="lnkCompile" runat="server" />
                        </li>
                        <li class="view">
                            <asp:LinkButton ID="lnkView" runat="server" />
                        </li>
                        <li class="test">
                            <asp:LinkButton ID="lnkTest" runat="server" />
                        </li>
                        <li class="config">
                            <asp:HyperLink ID="lnkSettings" runat="server" />
                        </li>
                    </menu>
                    <div class="fields form-config no-columns scroll-y">
                        <fs:FormSettings runat="server" ID="FormSettings" />
                    </div>
                </aside>
                <asp:Button ID="btnRefreshToolbar" runat="server" Style="display: none;" />
            </ContentTemplate>
        </asp:UpdatePanel>
        <wff:WindowManager ID="EditWindow" runat="server">
            <windows>
                <telerik:RadWindow ID="EditDialog" runat="server" Behaviors="Close,Move,Reload,Resize,Maximize" Height="800px" VisibleStatusbar="false" Width="1050px" ReloadOnShow="true" Modal="true" />
            </windows>
        </wff:WindowManager>
    </form>
</body>
</html>
