﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SOAPServices.ascx.vb" Inherits="Zuri.Forms.UI.SOAPServices" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>
<style>
    .switch {
        position: relative;
        display: inline-block;
        width: 30px;
        height: 17px;
    }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        -webkit-transition: .4s;
        transition: .4s;
    }

        .slider:before {
            position: absolute;
            content: "";
            height: 13px;
            width: 13px;
            left: 2px;
            bottom: 2px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

    input:checked + .slider {
        background-color: #2196F3;
    }

    input:focus + .slider {
        box-shadow: 0 0 1px #2196F3;
    }

    input:checked + .slider:before {
        -webkit-transform: translateX(13px);
        -ms-transform: translateX(13px);
        transform: translateX(13px);
    }

    /* Rounded sliders */
    .slider.round {
        border-radius: 17px;
    }

        .slider.round:before {
            border-radius: 50%;
        }

    .no-border:read-only {
        border: none !important;
    }

    table:not(.reLayoutWrapper) tbody > tr:nth-child(2n) .no-border:read-only {
        background: #ededed;
    }
</style>

<div class="fields no-columns">
    <h4>
        <asp:Literal ID="lblTitle" runat="server" /></h4>
    <label>
        <asp:Label ID="lblDSName" runat="server" />
        <asp:TextBox ID="txtDSName" runat="server" />
        <asp:RegularExpressionValidator ID="vlAlias" runat="server" ControlToValidate="txtDSName" ValidationExpression="^[a-zA-Z][a-zA-Z0-9() _-]*$" />
    </label>
    <label>
        <asp:CheckBox ID="chkRunAfterSave" runat="server" />
    </label>
    <fieldset id="fldAutenticacao">
        <legend>
            <asp:Label ID="lblAuth" runat="server" />
        </legend>
        <label>
            <asp:RadioButtonList ID="rdlTipoAutenticacao" runat="server" RepeatDirection="Horizontal" AutoPostBack="true">
                <asp:ListItem Value="0" Selected="true"></asp:ListItem>
                <asp:ListItem Value="1"></asp:ListItem>
                <asp:ListItem Value="2"></asp:ListItem>
                <asp:ListItem Value="3"></asp:ListItem>
            </asp:RadioButtonList>
        </label>
        <asp:Panel ID="pnlAuthentication" runat="server" Visible="false">
            <asp:Label ID="lblAutenticacaoUsuario" runat="server" Style="float: left !important;" Width="60px" />
            <asp:RequiredFieldValidator ID="rfvUsuario" runat="server" Display="Dynamic" ControlToValidate="txtSOAPUSR" Text="*" />
            <asp:TextBox ID="txtSOAPUSR" runat="server" MaxLength="50" ClientIDMode="Static" AutoCompleteType="None" />
            <asp:Label ID="lblAutenticacaoSenha" runat="server" />
            <asp:RequiredFieldValidator ID="rfvSenha" runat="server" Display="Dynamic" ControlToValidate="txtSOAPPWD" Text="*" />
            <asp:TextBox ID="txtSOAPPWD" runat="server" MaxLength="20" ClientIDMode="Static" type="password" AutoCompleteType="None" />
        </asp:Panel>
    </fieldset>
    <div style="margin-top: 5px">
        <label class="switch" style="display: inline-block;">
            <asp:CheckBox ID="chkUserAgent" runat="server" AutoPostBack="true" />
            <span class="slider round"></span>
        </label>
        <asp:Label ID="lblConfigurarUserAgent" runat="server" />
        <asp:Panel ID="pnlUserAgent" runat="server" Visible="false">
            <asp:Label ID="lblUserAgent" runat="server" />
            <asp:TextBox ID="txtUserAgent" runat="server" MaxLength="100" />
        </asp:Panel>
    </div>
    <asp:Panel runat="server" ID="pnlToggleNivelXml">
        <label class="switch" style="display: inline-block;">
            <asp:CheckBox ID="chkNivelXml" runat="server" AutoPostBack="true" />
            <span class="slider round"></span>
        </label>
        <asp:Label ID="lblAlterarNivelXml" runat="server" />
        <asp:Panel ID="pnlNivelXml" runat="server" Visible="False">
            <asp:Label ID="lblNivelXml" runat="server" />
            <asp:TextBox ID="txtNivelXml" runat="server" MaxLength="50" Text="0" />
        </asp:Panel>
    </asp:Panel>
    <div>
        <asp:Label ID="lblUrlWeb" runat="server" />
        <div>
            <asp:TextBox ID="txtServiceURL" runat="server" Style="width: 80%; display: inline;" MaxLength="200" />
            <asp:Button ID="btnLoadService" Style="width: 16%; padding: 10px 15px; display: inline; margin-left: 5px;" runat="server" />
            <asp:Panel ID="pnlUpload" runat="server">
                <asp:Label ID="lblWSDL" runat="server" />
                <asp:ImageButton ID="btnExcluir" CssClass="deleteFile" Width="20px" ImageUrl="~/WFResources/FormsWeb/Images/deletefile.png" runat="server" />
                <div style="margin-top: 5px;">
                    <telerik:RadAsyncUpload ID="wsdlUpload" OnClientFileUploaded="" UploadedFilesRendering="BelowFileInput"
                        MaxFileInputsCount="1" PersistConfiguration="True" runat="server" />
                </div>
            </asp:Panel>
        </div>
    </div>
    <label>
        <asp:Label ID="lblMethodsWeb" runat="server" />
        <asp:DropDownList ID="ddlMethods" runat="server" AutoPostBack="True" />
    </label>
    <asp:PlaceHolder ID="phParams" Visible="false" runat="server">
        <div>
            <asp:Label runat="server" ID="lblParams" />
            <telerik:RadGrid runat="server" ID="grdParams" AutoGenerateColumns="false" AllowPaging="False">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ParamName">
                            <ItemTemplate>
                                <asp:Label ID="lblParamName" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ParamType">
                            <ItemTemplate>
                                <asp:Label ID="lblParamType" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ExecValue">
                            <ItemTemplate>
                                <fff:FormsFieldsPicker ID="fpkExecValue" AllowCustomText="true" IncludeContext="true" Width="90%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ISREQUIRED">
                            <ItemTemplate>
                                <asp:CheckBox ID="chkRequired" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="TestValue">
                            <ItemTemplate>
                                <asp:TextBox ID="txtTestValue" Width="90%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
            </telerik:RadGrid>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phResultConfig" runat="server" Visible="false">
        <fieldset>
            <legend>
                <asp:Literal ID="litReturn" runat="server" /></legend>
            <div style="display: grid; width: 100%">
                <asp:Label ID="lblResult" runat="server" /><br />
                <asp:TextBox runat="server" ID="txtResult" Height="15em" TextMode="MultiLine" />
            </div>
        </fieldset>
    </asp:PlaceHolder>
</div>
