﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="RESTServices.ascx.vb" Inherits="Zuri.Forms.UI.RESTServices" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>

<div class="fields no-columns">
    <div>
        <h4>
            <asp:Literal ID="lblTitle" runat="server" /></h4>
    </div>
    <label>
        <asp:Label ID="lblDSName" runat="server" />
        <asp:TextBox ID="txtDSName" runat="server" />
        <asp:RegularExpressionValidator ID="vlAlias" runat="server" ControlToValidate="txtDSName" ValidationExpression="^[a-zA-Z][a-zA-Z0-9() _-]*$" />
    </label>
    <label>
        <asp:CheckBox ID="chkRunAfterSave" runat="server" />
    </label>
    <fieldset>
        <legend>
            <asp:Literal ID="litMain" runat="server" /></legend>
        <label>
            <asp:Label ID="lblURL" runat="server" />
            <asp:RequiredFieldValidator ID="reqURL" runat="server" ControlToValidate="txtURL" Display="Dynamic" Text="*" />
            <asp:TextBox ID="txtURL" runat="server" />
        </label>
        <label>
            <asp:RadioButtonList ID="rdlTipoAutenticacao" runat="server" RepeatDirection="Horizontal" AutoPostBack="true">
                <asp:ListItem Value="0" Selected="true"></asp:ListItem>
                <asp:ListItem Value="1"></asp:ListItem>
                <asp:ListItem Value="2"></asp:ListItem>
            </asp:RadioButtonList>
        </label>
        <asp:Panel ID="pnlAuthentication" runat="server" Visible="false">
            <asp:Label ID="lblAutenticacaoUsuario" runat="server" Style="float: left !important;" Width="60px" />
            <asp:RequiredFieldValidator ID="rfvUsuario" runat="server" Display="Dynamic" ControlToValidate="txtSOAPUSR" Text="*" />
            <asp:TextBox ID="txtSOAPUSR" runat="server" MaxLength="50" ClientIDMode="Static" AutoCompleteType="None" />
            <asp:Label ID="lblAutenticacaoSenha" runat="server" />
            <asp:RequiredFieldValidator ID="rfvSenha" runat="server" Display="Dynamic" ControlToValidate="txtSOAPPWD" Text="*" />
            <asp:TextBox ID="txtSOAPPWD" runat="server" MaxLength="20" ClientIDMode="Static" type="password" AutoCompleteType="None" />
        </asp:Panel>
        <asp:Panel ID="pnlCertificate" runat="server" Visible="false">
            <asp:Label runat="server" ID="lblCertificate" />
            <asp:DropDownList runat="server" ID="ddlCertificates" />
            <asp:RequiredFieldValidator ID="rfvCertificate" runat="server" Display="Dynamic" ControlToValidate="ddlCertificates" Text="*" />
        </asp:Panel>
        <div>
            <asp:Label ID="lblMethod" runat="server" />
            <div style="width: 100%; display: block; height: 40px;">
                <div style="float: left; width: 40%">
                    <asp:DropDownList Width="100%" runat="server" ID="ddlMethod" AutoPostBack="true" />
                </div>
                <div style="float: left; width: 59%; padding-left: 5px">
                    <asp:TextBox ID="txtMethod" Width="100%" runat="server" Visible="false" />&nbsp;
                </div>
            </div>
        </div>
        <div style="display: grid; width: 100%">
            <asp:Label ID="lblContentType" runat="server" />
            <div style="width: 100%; display: block; height: 40px;">
                <div style="float: left; width: 40%">
                    <asp:DropDownList Width="100%" runat="server" ID="ddlContentType" AutoPostBack="true" />
                </div>
                <div style="float: left; width: 59%; padding-left: 5px">
                    <asp:TextBox Width="100%" ID="txtContentType" runat="server" Visible="false" />&nbsp;
                </div>
            </div>
        </div>
        <asp:PlaceHolder ID="phBody" runat="server">
            <div style="display: grid; width: 100%">
                <asp:Label ID="lblcontent" runat="server" />
                <asp:RequiredFieldValidator ID="reqContent" runat="server" ControlToValidate="txtContent" Display="Dynamic" Text="*" />
                <asp:TextBox runat="server" ID="txtContent" Height="15em" TextMode="MultiLine" />
            </div>
        </asp:PlaceHolder>
    </fieldset>
    <fieldset>
        <legend>
            <asp:Literal ID="litParams" runat="server" /></legend>
        <div style="display: grid; width: 100%">
            <div style="width: 100%; display: block; height: 40px;">
                <div style="float: left; width: 40%; font-size: .9em; color: darkgrey;">
                    <asp:Label ID="lblParams" runat="server" />
                </div>
                <div style="float: left; width: 59%; padding-left: 5px">
                    <asp:Button ID="btnAddParam" Style="padding: 10px 10px; display: inline; margin-left: 5px; width: 200px;" CausesValidation="false" runat="server" />
                </div>
            </div>
        </div>
        <div>
            <telerik:RadGrid runat="server" ID="grdParams" AutoGenerateColumns="false" AllowPaging="False">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ParamName">
                            <ItemTemplate>
                                <asp:TextBox ID="txtParamName" Width="100%" runat="server"></asp:TextBox>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ExecValue">
                            <ItemTemplate>
                                <fff:FormsFieldsPicker ID="fpkExecValue" AllowCustomText="true" IncludeContext="true" Width="95%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ISREQUIRED">
                            <ItemTemplate>
                                <asp:CheckBox ID="chkRequired" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="TestValue">
                            <ItemTemplate>
                                <asp:TextBox ID="txtTestValue" Width="95%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="DelParam">
                            <ItemTemplate>
                                <asp:ImageButton ID="btnDel" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" CausesValidation="false" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
            </telerik:RadGrid>
        </div>
    </fieldset>
    <fieldset>
        <legend>
            <asp:Literal ID="litHeaders" runat="server" /></legend>
        <div style="display: grid; width: 100%">
            <div style="width: 100%; display: block; height: 40px;">
                <div style="float: left; width: 40%">
                    <asp:DropDownList runat="server" Width="100%" ID="ddlHeaders">
                        <asp:ListItem Value="Accept-Language" Text="Accept-Language" />
                        <asp:ListItem Value="Authorization" Text="Authorization" title="Authentication credentials for HTTP authentication" />
                        <asp:ListItem Value="Cache-Control" Text="Cache-Control" title="Used to specify directives that MUST be obeyed by all caching mechanisms along the request/response chain" />
                        <asp:ListItem Value="From" Text="From" title="The email address of the user making the request" />
                        <asp:ListItem Value="Origin" Text="Origin" title="Initiates a request for cross-origin resource sharing (asks server for an 'Access-Control-Allow-Origin' response header) ." />
                        <asp:ListItem Value="Pragma" Text="Pragma" title="Implementation-specific headers that may have various effects anywhere along the request-response chain." />
                        <asp:ListItem Value="Proxy-Authorization" Text="Proxy-Authorization" title="Authorization credentials for connecting to a proxy." />
                        <asp:ListItem Value="Range" Text="Range" title="Request only part of an entity. Bytes are numbered from 0." />
                        <asp:ListItem Value="User-Agent" Text="User-Agent" title="The user agent string of the user agent" />
                        <asp:ListItem Value="X-HTTP-Method-Override" Text="X-HTTP-Method-Override" title="HTTP method override used by some web apis when the usage of the desired method is not allowed by the browser or proxies." />
                        <asp:ListItem Text="CUSTOM" Value="" title="Adds a custom header to the list" />
                    </asp:DropDownList>
                </div>
                <div style="float: left; width: 59%; padding-left: 5px">
                    <asp:Button ID="btnAddHeader" Style="padding: 10px 10px; display: inline; margin-left: 5px; margin-top: 4px; width: 200px;" CausesValidation="false" runat="server" />
                </div>
            </div>
        </div>
        <div>
            <telerik:RadGrid runat="server" ID="grdHeaders" AutoGenerateColumns="false" AllowPaging="False">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ParamName">
                            <ItemTemplate>
                                <asp:TextBox ID="txtParamName" runat="server"></asp:TextBox>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ExecValue">
                            <ItemTemplate>
                                <fff:FormsFieldsPicker ID="fpkExecValue" AllowCustomText="true" IncludeContext="true" Width="90%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ISREQUIRED">
                            <ItemTemplate>
                                <asp:CheckBox ID="chkRequired" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="TestValue">
                            <ItemTemplate>
                                <asp:TextBox ID="txtTestValue" Width="90%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="DelParam">
                            <ItemTemplate>
                                <asp:ImageButton ID="btnDel" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" CausesValidation="false" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
            </telerik:RadGrid>
        </div>
    </fieldset>
    <asp:PlaceHolder ID="phResultConfig" runat="server" Visible="false">
        <fieldset>
            <legend>
                <asp:Literal ID="litReturn" runat="server" /></legend>
            <label>
                <asp:CheckBox ID="chkResult" runat="server" AutoPostBack="true" />
            </label>
            <asp:PlaceHolder ID="phResult" runat="server" Visible="false">
                <div style="display: grid; width: 100%">
                    <asp:Label ID="lblResult" runat="server" /><br />
                    <asp:TextBox runat="server" ID="txtResult" Height="15em" TextMode="MultiLine" />
                </div>
            </asp:PlaceHolder>
        </fieldset>
    </asp:PlaceHolder>
</div>
