﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="Formulas.ascx.vb" Inherits="Zuri.Forms.UI.Formulas" %>
<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<div class="fields no-columns">
    <h4>
        <asp:Literal ID="lblTitle" runat="server" /></h4>
    <label>
        <asp:Label ID="lblDSName" runat="server" />
        <asp:TextBox ID="txtDSName" runat="server" />
        <asp:RegularExpressionValidator ID="vlAlias" runat="server" ControlToValidate="txtDSName" ValidationExpression="^[a-zA-Z][a-zA-Z0-9() _-]*$" />
    </label>
    <label>
        <asp:DropDownList runat="server" ID="ddlMethods" AutoPostBack="true" />
    </label>
    <asp:PlaceHolder ID="phSingleField" Visible="false" runat="server">
        <label>
            <asp:HiddenField ID="hidParamName" runat="server" />
            <fff:FormsFieldsPicker ID="fpkFields" AllowCustomText="false" IncludeContext="false" runat="server" />
        </label>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phParams" Visible="false" runat="server">
        <div>
            <asp:Label runat="server" ID="lblParams" />
            <telerik:RadGrid runat="server" ID="grdParams" AutoGenerateColumns="false" AllowPaging="False">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn HeaderText="Campo" ItemStyle-HorizontalAlign="Center" UniqueName="ParamName">
                            <ItemTemplate>
                                <asp:Label ID="lblParamName" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn HeaderText="Campo" ItemStyle-HorizontalAlign="Center" UniqueName="ParamType">
                            <ItemTemplate>
                                <asp:Label ID="lblParamType" runat="server" />
                                <asp:HiddenField ID="hidIsRequired" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn HeaderText="Valor" ItemStyle-HorizontalAlign="Center" UniqueName="ExecValue">
                            <ItemTemplate>
                                <fff:FormsFieldsPicker ID="fpkExecValue" AllowCustomText="true" IncludeContext="true" Width="90%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" UniqueName="ISREQUIRED">
                            <ItemTemplate>
                                <asp:CheckBox ID="chkRequired" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn HeaderText="Valor para teste" ItemStyle-HorizontalAlign="Center" UniqueName="TestValue">
                            <ItemTemplate>
                                <asp:TextBox ID="txtTestValue" Width="90%" runat="server" />
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </MasterTableView>
            </telerik:RadGrid>
        </div>
    </asp:PlaceHolder>
</div>
