﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="Expressions.ascx.vb" Inherits="Zuri.Forms.UI.Expressions" %>
<style>
    .expr-op {
        font-weight: bold;
        border: solid 1px #000;
        margin: 4px;
        border-radius: 4px;
        width: 22px;
        height: 22px;
        display: inline-block;
        text-align: center;
        vertical-align: middle;
    }

    .logical {
        width: 30px;
    }

    .expr-title {
        display: block;
    }
</style>
<main class="grid-formula">
    <div class="fields no-columns">
        <h1>
            <asp:Literal runat="server" ID="litTitle" Text="FormGrid Fórmula" /></h1>
        <label>
            <asp:Label ID="lblDSName" runat="server" />
            <asp:TextBox ID="txtDSName" runat="server" />
            <asp:RegularExpressionValidator ID="vlAlias" runat="server" ControlToValidate="txtDSName" ValidationExpression="^[a-zA-Z][a-zA-Z0-9() _-]*$" />
        </label>
    </div>
    <asp:TextBox ID="txtFormula" TextMode="MultiLine" runat="server" CssClass="grid-formula" placeholder="quantity * (value + 2.1) >= 10 or CATEGORY = [MYCATEGORY]" />
    <asp:Label ID="lblValidation" runat="server" CssClass="error" />
    <p>
        <asp:Literal ID="litDesc1" runat="server" /><br />
        <asp:Literal ID="litDesc2" runat="server" /><br />
        <asp:Literal ID="litDesc3" runat="server" />
    </p>
    <p>
        <asp:Literal ID="litFields" runat="server" />
    </p>
    <ul class="options">
        <li>
            <asp:Label ID="lblgrp" CssClass="expr-title" runat="server" />
            <asp:Label ID="lblstart" CssClass="expr-op" runat="server" /><asp:Label ID="lblend" CssClass="expr-op" runat="server" />
        </li>
        <li>
            <asp:Label ID="lblmath" CssClass="expr-title" runat="server" />
            <asp:Label ID="lbladd" CssClass="expr-op" runat="server" /><asp:Label ID="lblsub" CssClass="expr-op" runat="server" />
            <asp:Label ID="lblmult" CssClass="expr-op" Style="padding-top: 5px;" runat="server" /><asp:Label ID="lbldiv" CssClass="expr-op" runat="server" />
            <asp:Label ID="lblmod" CssClass="expr-op" runat="server" />
        </li>
        <li>
            <asp:Label ID="lblcomp" CssClass="expr-title" runat="server" />
            <asp:Label ID="lblless" CssClass="expr-op" runat="server" /><asp:Label ID="lblgt" CssClass="expr-op" runat="server" />
            <asp:Label ID="lbllesseq" CssClass="expr-op" runat="server" /><asp:Label ID="lblgteq" CssClass="expr-op" runat="server" />
            <asp:Label ID="lbleq" CssClass="expr-op" runat="server" /><asp:Label ID="lbldiff" CssClass="expr-op" runat="server" />
        </li>
        <li>
            <asp:Label ID="lbllogic" CssClass="expr-title" runat="server" />
            <asp:Label ID="lbland" CssClass="expr-op logical" runat="server" /><asp:Label ID="lblor" CssClass="expr-op logical" runat="server" />
        </li>
        <asp:Repeater ID="rptFields" runat="server">
            <ItemTemplate>
                <li class="field"><%# WebFoundations.WFForms.Management.MngGlossary.GetText("T77") %>: <b><%# Container.DataItem %></b></li>
            </ItemTemplate>
        </asp:Repeater>
    </ul>
</main>
