﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="FormSettings.ascx.vb" Inherits="Zuri.Forms.UI.FormSettings" %>
<%@ Register TagPrefix="fff" Namespace="Zuri.Forms.Engine.ServerControls" Assembly="Zuri.Forms.Engine" %>
<script type="text/javascript">
    function SuggestAlias(objTitulo, controlName, prefix) {
        var objApelido = document.getElementById(controlName);
        if (!objApelido.value) {
            var arrRegex = [/[ÃÁÀÂÄ]/g, /[ÉÈÊË]/g, /[ÍÌÎÏ]/g, /[ÕÓÒÔÖ]/g, /[ÚÙÛÜ]/g, /ÝŸ/g, /Ñ/g, /Ç/g];
            var arrNewValue = ['A', 'E', 'I', 'O', 'U', 'Y', 'N', 'C'];
            var valor = objTitulo.value.toUpperCase();
            for (var i = 0; i < arrRegex.length; i++) {
                valor = valor.replace(arrRegex[i], arrNewValue[i]);
            }
            valor = prefix + valor.replace(/[^A-Z0-9_]|\b[DN]{0,1}[AEO]S{0,1}\b/g, '');
            if (valor.length > 90) valor = valor.substr(0, 90);
            objApelido.value = valor;
        }
        if (window.onTitleChange) {
            window.onTitleChange(objTitulo.value);
        }
    }
</script>
<style>
    .errMessage {
        color: red;
        padding: 4px;
        margin-bottom: 1em;
        width: 100%;
        display: block;
        border: solid 1px #FFFFFF;
        border-radius: 4px;
        background: #FFFFFF;
        text-align: center;
    }
</style>
<fieldset>
    <legend>
        <asp:Literal runat="server" Text="Formulário" ID="litTitle" /></legend>
    <label>
        <asp:Label ID="lbltitulo" runat="server" Text="Nome" />
        <asp:TextBox ID="txttitulo" runat="server" MaxLength="60" CssClass="form-info-title" />
        <asp:RequiredFieldValidator ID="obrtitulo" ValidationGroup="forminfo" runat="server" ControlToValidate="txttitulo" Display="Dynamic" />
    </label>
    <label>
        <asp:Label ID="lblapelido" runat="server" Text="Apelido" />
        <asp:TextBox ID="txtapelido" runat="server" MaxLength="90" />
        <asp:RequiredFieldValidator ID="obrapelido" runat="server" ValidationGroup="forminfo" ControlToValidate="txtapelido" Display="Dynamic" />
        <asp:RegularExpressionValidator ID="vlapelido" runat="server" ValidationGroup="forminfo" ControlToValidate="txtapelido" Display="Dynamic" ValidationExpression="^[a-zA-Z][a-zA-Z0-9_]{2,99}$" />
    </label>
    <label>
        <asp:CheckBox ID="chkWorkflow" runat="server" />
    </label>
    <asp:PlaceHolder ID="phFormsConfigs" runat="server">
        <label>
            <asp:Label ID="lblOkButton" runat="server" />
            <asp:TextBox ID="txtOKText" runat="server" MaxLength="90" />
        </label>
        <label>
            <asp:CheckBox ID="chkAllowPartialSave" runat="server" />
        </label>
        <label>
            <asp:Label ID="lblPartialButton" runat="server" />
            <asp:TextBox ID="txtPartialText" runat="server" MaxLength="90" />
        </label>
        <div>
            <asp:Label ID="lblValidationValue" runat="server" />
            <fff:FormsContextPicker ID="ctxValidationValue" IncludeContext="false" runat="server" />
        </div>
        <div>
            <asp:Label ID="lblValidationMessage" runat="server" />
            <fff:FormsContextPicker ID="ctxValidationMessage" IncludeContext="false" runat="server" />
        </div>
    </asp:PlaceHolder>
    <asp:Label ID="lblError" runat="server" CssClass="errMessage" Visible="false" />
    <asp:Button ID="btnok" CssClass="form-save" ValidationGroup="forminfo" runat="server" />
</fieldset>
